/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.compat.sodium.gui;

import com.google.common.collect.ImmutableList;
import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.compat.sodium.gui.CFIOptionsStorage;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.AnimationType;
import com.koteinik.chunksfadein.core.Curve;
import com.koteinik.chunksfadein.core.FadeType;
import com.koteinik.chunksfadein.core.FogOverrideMode;
import com.koteinik.chunksfadein.core.TranslatableEnum;
import com.koteinik.chunksfadein.gui.GuiUtils;
import com.koteinik.chunksfadein.gui.SettingsScreen;
import com.koteinik.chunksfadein.hooks.CompatibilityHook;
import com.koteinik.chunksfadein.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.OptionGroup;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpact;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpl;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlValueFormatter;
import net.caffeinemc.mods.sodium.client.gui.options.control.CyclingControl;
import net.caffeinemc.mods.sodium.client.gui.options.control.SliderControl;
import net.caffeinemc.mods.sodium.client.gui.options.control.TickBoxControl;
import net.caffeinemc.mods.sodium.client.gui.options.storage.OptionStorage;
import net.minecraft.class_2561;

public class CFISodiumPage
extends OptionPage {
    private static final String SODIUM_PAGE_NAME = "settings.chunksfadein.sodium_page_name";
    private static final CFIOptionsStorage cfiStorage = new CFIOptionsStorage();

    public CFISodiumPage() {
        super((class_2561)class_2561.method_43471((String)SODIUM_PAGE_NAME), ImmutableList.copyOf(CFISodiumPage.makeOptions()));
    }

    private static List<OptionGroup> makeOptions() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        boolean forceEnableTab = !Services.PLATFORM.isForge() && !CompatibilityHook.isModMenuLoaded;
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.mod_enabled")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.mod_enabled")).setControl(TickBoxControl::new).setBinding((c, v) -> cfiStorage.setBooleanDirty("mod-enabled", (boolean)v), c -> Config.isModEnabled).setImpact(OptionImpact.LOW).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.update_notifier_enabled")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.update_notifier_enabled")).setControl(TickBoxControl::new).setBinding((c, v) -> Config.setBoolean("update-notifier-enabled", v), c -> Config.isUpdateNotifierEnabled).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.mod_tab_enabled")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.mod_tab_enabled").method_10852((class_2561)(forceEnableTab ? class_2561.method_43470((String)"\n").method_10852((class_2561)SettingsScreen.MOD_TAB_TOOLTIP) : class_2561.method_43473()))).setControl(TickBoxControl::new).setEnabled(() -> !forceEnableTab).setBinding((c, v) -> Config.setBoolean("show-mod-tab-in-settings", v), c -> forceEnableTab || Config.showModTabInSettings).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.fade_enabled")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.fade_enabled")).setControl(TickBoxControl::new).setBinding((c, v) -> cfiStorage.setBooleanDirty("fade-enabled", (boolean)v), c -> Config.isFadeEnabled).setImpact(OptionImpact.LOW).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.fade_near_player")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.fade_near_player")).setControl(TickBoxControl::new).setBinding((c, v) -> Config.setBoolean("fade-near-player", v), c -> Config.fadeNearPlayer).build()).add((Option)OptionImpl.createBuilder(FadeType.class, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.fade_type")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.fade_type")).setControl(o -> new CyclingControl((Option)o, FadeType.class, CFISodiumPage.translations(FadeType.class))).setBinding((c, v) -> cfiStorage.setIntegerDirty("fade-type", v.ordinal()), c -> Config.fadeType).build()).add((Option)OptionImpl.createBuilder(FogOverrideMode.class, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.fog_override")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.fog_override", "tooltip_pre_1_21_6")).setControl(o -> new CyclingControl((Option)o, FogOverrideMode.class, CFISodiumPage.translations(FogOverrideMode.class))).setBinding((c, v) -> cfiStorage.setIntegerDirty("fog-override", v.ordinal()), c -> Config.fogOverrideMode).build()).add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.fade_time")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.fade_time")).setControl(o -> new SliderControl((Option)o, MathUtils.roundToInt(1.0), MathUtils.roundToInt(1000.0), 1, CFISodiumPage.scaled(100, (class_2561)SettingsScreen.UNITS_SECONDS))).setBinding((c, v) -> Config.setDouble("fade-time", (double)v.intValue() / 100.0), c -> MathUtils.roundToInt(Config.secondsFromFadeChange() * 100.0f)).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.animation_enabled")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.animation_enabled")).setControl(TickBoxControl::new).setBinding((c, v) -> cfiStorage.setBooleanDirty("animation-enabled", (boolean)v), c -> Config.isAnimationEnabled).setImpact(OptionImpact.LOW).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.animate_near_player")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.animate_near_player")).setControl(TickBoxControl::new).setBinding((c, v) -> Config.setBoolean("animate-near-player", v), c -> Config.animateNearPlayer).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.animate_with_dh")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.animate_with_dh")).setControl(TickBoxControl::new).setBinding((c, v) -> Config.setBoolean("fade-with-dh", v), c -> Config.animateWithDH).build()).add((Option)OptionImpl.createBuilder(Curve.class, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.animation_curve")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.animation_curve")).setControl(o -> new CyclingControl((Option)o, Curve.class, CFISodiumPage.translations(Curve.class))).setBinding((c, v) -> cfiStorage.setIntegerDirty("animation-curve", v.ordinal()), c -> Config.animationCurve).build()).add((Option)OptionImpl.createBuilder(AnimationType.class, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.animation_type")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.animation_type")).setControl(o -> new CyclingControl((Option)o, AnimationType.class, CFISodiumPage.translations(AnimationType.class))).setBinding((c, v) -> cfiStorage.setIntegerDirty("animation-type", v.ordinal()), c -> Config.animationType).build()).add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.animation_time")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.animation_time")).setControl(o -> new SliderControl((Option)o, MathUtils.roundToInt(1.0), MathUtils.roundToInt(1000.0), 1, CFISodiumPage.scaled(100, (class_2561)SettingsScreen.UNITS_SECONDS))).setBinding((c, v) -> Config.setDouble("animation-time", (double)v.intValue() / 100.0), c -> MathUtils.roundToInt(Config.secondsFromAnimationChange() * 100.0)).build()).add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.animation_start")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.animation_start")).setControl(o -> new SliderControl((Option)o, MathUtils.roundToInt(-12800.0), MathUtils.roundToInt(12800.0), 1, CFISodiumPage.scaled(100, (class_2561)SettingsScreen.UNITS_BLOCKS))).setBinding((c, v) -> Config.setDouble("animation-offset", (double)v.intValue() / 100.0), c -> MathUtils.roundToInt(Config.animationOffset * 100.0f)).build()).add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.animation_angle")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.animation_angle")).setControl(o -> new SliderControl((Option)o, MathUtils.roundToInt(0.0), MathUtils.roundToInt(90.0), 1, CFISodiumPage.number((class_2561)SettingsScreen.UNITS_DEGREES))).setBinding((c, v) -> Config.setDouble("animation-angle", (double)v), c -> MathUtils.roundToInt(Config.animationAngle)).build()).add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.animation_factor")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.animation_factor")).setControl(o -> new SliderControl((Option)o, MathUtils.roundToInt(1.0), MathUtils.roundToInt(100.0), 1, CFISodiumPage.scaled(100))).setBinding((c, v) -> Config.setDouble("animation-factor", (double)v.intValue() / 100.0), c -> MathUtils.roundToInt(Config.animationFactor * 100.0f)).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.world_curvature_enabled")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.world_curvature_enabled")).setControl(TickBoxControl::new).setBinding((c, v) -> cfiStorage.setBooleanDirty("world-curvature-enabled", (boolean)v), c -> Config.isCurvatureEnabled).setImpact(OptionImpact.LOW).build()).add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)cfiStorage).setName((class_2561)class_2561.method_43471((String)"settings.chunksfadein.world_curvature")).setTooltip((class_2561)GuiUtils.tooltip("settings.chunksfadein.world_curvature")).setControl(o -> new SliderControl((Option)o, 0, 15, 1, v -> class_2561.method_43470((String)String.valueOf(SettingsScreen.CURVATURE_VALUES[v])))).setBinding((c, v) -> cfiStorage.setIntegerDirty("world-curvature", SettingsScreen.CURVATURE_VALUES[v]), c -> SettingsScreen.curvatureValueIdx(Config.worldCurvature)).build()).build());
        return groups;
    }

    private static ControlValueFormatter scaled(int scale) {
        return CFISodiumPage.scaled(scale, (class_2561)class_2561.method_43473());
    }

    private static ControlValueFormatter scaled(int scale, class_2561 units) {
        return v -> class_2561.method_43470((String)String.valueOf((double)v / (double)scale)).method_10852(units);
    }

    private static ControlValueFormatter number(class_2561 units) {
        return v -> class_2561.method_43470((String)String.valueOf(v)).method_10852(units);
    }

    private static <T extends Enum<T>> class_2561[] translations(Class<T> clazz) {
        return (class_2561[])Arrays.stream((Enum[])clazz.getEnumConstants()).map(rec$ -> ((TranslatableEnum)rec$).getTranslation()).toArray(class_2561[]::new);
    }
}

