/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.AnimationType;
import com.koteinik.chunksfadein.core.FadeType;
import java.util.ArrayList;
import java.util.List;

public class FadeShader {
    private List<String> lines = new ArrayList<String>();

    public FadeShader dummyApiFragSampleSkyLodTexture() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_sampleSkyLodTexture() { return vec3(0.0); }");
    }

    public FadeShader apiFragSampleSkyLodTexture() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_sampleSkyLodTexture() {");
        if (Config.isFadeEnabled) {
            this.newLine("return texture(cfi_sky, gl_FragCoord.xy / cfi_screenSize).rgb;");
        } else {
            this.newLine("return iris_FogColor.rgb;");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiFragApplySkyLodFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_applySkyLodFade(vec3 fullyFaded) { return vec3(0.0); }");
    }

    public FadeShader apiFragApplySkyLodFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_applySkyLodFade(vec3 fullyFaded) {");
        if (Config.isFadeEnabled) {
            this.newLine("return cfi_applyFade(cfi_sampleSkyLodTexture(), fullyFaded);");
        } else {
            this.newLine("return fullyFaded;");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiFragApplyFogFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_applyFogFade(vec3 fullyFaded) { return vec3(0.0); }");
    }

    public FadeShader apiFragApplyFogFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_applyFogFade(vec3 fullyFaded) {");
        if (Config.isFadeEnabled) {
            this.newLine("return cfi_applyFade(iris_FogColor.rgb, fullyFaded);");
        } else {
            this.newLine("return fullyFaded;");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiFragApplyFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_applyFade(vec3 fullyUnfaded, vec3 fullyFaded) { return vec3(0.0); }");
    }

    public FadeShader apiFragApplyFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_applyFade(vec3 fullyUnfaded, vec3 fullyFaded) {");
        if (Config.isFadeEnabled) {
            this.newLine("return mix(fullyUnfaded, fullyFaded, cfi_calculateFade());");
        } else {
            this.newLine("return fullyFaded;");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiFragCalculateFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("float cfi_calculateFade() { return 0.0; }");
    }

    public FadeShader apiFragCalculateFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("float cfi_calculateFade() {");
        if (Config.isFadeEnabled) {
            this.newLine("float fade = 0.0;");
            this.calculateFade("fade = ");
            this.newLine("return fade;");
        } else {
            this.newLine("return 1.0;");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiVertCalculateCurvature2() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_calculateCurvature() { return vec3(0.0); }");
    }

    public FadeShader apiVertCalculateCurvature2() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_calculateCurvature() {");
        this.newLine("return cfi_calculateCurvature(getVertexPosition().xyz);");
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiVertCalculateCurvature() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_calculateCurvature(vec3 globalPos) { return vec3(0.0); }");
    }

    public FadeShader apiVertCalculateCurvature() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_calculateCurvature(vec3 globalPos) {");
        if (Config.isCurvatureEnabled) {
            this.newLine("return vec3(0.0, -dot(globalPos, globalPos) / " + Config.worldCurvature + ", 0.0);");
        } else {
            this.newLine("return vec3(0.0);");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiVertCalculateDisplacement2() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_calculateDisplacement() { return vec3(0.0); }");
    }

    public FadeShader apiVertCalculateDisplacement2() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_calculateDisplacement() {");
        this.newLine("return cfi_calculateDisplacement(_vert_position);");
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiVertCalculateDisplacement() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_calculateDisplacement(vec3 localPos) { return vec3(0.0); }");
    }

    public FadeShader apiVertCalculateDisplacement() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_calculateDisplacement(vec3 localPos) {");
        if (Config.isAnimationEnabled) {
            this.newLine("vec3 originalPos = localPos;");
            this.newLine("localPos = vec3(localPos);");
            this.newLine("vec4 chunkFadeData = cfi_getFadeData();");
            if (Config.animationType == AnimationType.JAGGED || Config.animationType == AnimationType.DISPLACEMENT) {
                this.rand("rand", "localPos + vec3(_draw_id)");
            }
            this.calculateVertexDisplacement("localPos", null, true, "_draw_id");
            this.newLine("return localPos - originalPos;");
        } else {
            this.newLine("return vec3(0.0);");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiVertGetFadeData() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec4 cfi_getFadeData() { return vec4(0.0); }");
    }

    public FadeShader apiVertGetFadeData(String drawId) {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec4 cfi_getFadeData() {");
        this.newLine("return cfi_ChunkFadeDatas[%s].fadeData;".formatted(drawId));
        this.newLine("}");
        return this;
    }

    public FadeShader vertInVars() {
        this.newLine("struct cfi_ChunkFadeData { vec4 fadeData; };");
        this.newLine("layout(std140) uniform cfi_ubo_ChunkFadeDatas { cfi_ChunkFadeData cfi_ChunkFadeDatas[256]; };");
        return this;
    }

    public FadeShader vertOutVars() {
        if (!Config.isModEnabled || !Config.isFadeEnabled) {
            return this;
        }
        this.newLine("flat out float cfi_FadeFactor;");
        if (Config.fadeType == FadeType.BLOCK) {
            this.newLine("out vec3 cfi_BlockSeed;");
        }
        if (Config.fadeType == FadeType.LINED) {
            this.newLine("out float cfi_RefFactor;");
        }
        if (Config.fadeType == FadeType.VERTEX) {
            this.newLine("flat out float cfi_RefFactor;");
        }
        return this;
    }

    public FadeShader fragInVars() {
        if (!Config.isModEnabled || !Config.isFadeEnabled) {
            return this;
        }
        this.newLine("uniform sampler2D cfi_sky;");
        this.newLine("uniform vec2 cfi_screenSize;");
        this.newLine("flat in float cfi_FadeFactor;");
        if (Config.fadeType == FadeType.BLOCK) {
            this.newLine("in vec3 cfi_BlockSeed;");
        }
        if (Config.fadeType == FadeType.LINED) {
            this.newLine("in float cfi_RefFactor;");
        }
        if (Config.fadeType == FadeType.VERTEX) {
            this.newLine("flat in float cfi_RefFactor;");
        }
        return this;
    }

    public FadeShader vertInitOutVarsDrawId(String localPos, String drawId) {
        if (!Config.isModEnabled) {
            return this;
        }
        if (Config.isAnimationEnabled || Config.isFadeEnabled) {
            this.newLine("vec4 chunkFadeData = cfi_ChunkFadeDatas[%s].fadeData;".formatted(drawId));
        }
        return this.vertInitOutVars(localPos, "vec3(%s)".formatted(drawId));
    }

    public FadeShader vertInitOutVars(String localPos, String randSeed) {
        if (!Config.isModEnabled) {
            return this;
        }
        if ((Config.isAnimationEnabled || Config.isFadeEnabled) && (Config.animationType == AnimationType.JAGGED || Config.animationType == AnimationType.DISPLACEMENT || Config.fadeType == FadeType.VERTEX)) {
            this.rand("rand", "%s + %s".formatted(localPos, randSeed));
        }
        if (Config.isFadeEnabled) {
            this.newLine("cfi_FadeFactor = chunkFadeData.w;");
            if (Config.fadeType == FadeType.BLOCK) {
                this.newLine("cfi_BlockSeed = %s + %s;".formatted(localPos, randSeed));
            }
            if (Config.fadeType == FadeType.VERTEX) {
                this.newLine("cfi_RefFactor = cfi_FadeFactor > rand ? 1.0 : cfi_FadeFactor / rand;");
            }
            if (Config.fadeType == FadeType.LINED) {
                this.newLine("float refFactor = %s.y / 16.0;".formatted(localPos));
                this.newLine("cfi_RefFactor = refFactor - floor(refFactor);");
            }
        }
        return this;
    }

    public FadeShader vertInitMod(String localPos, String position, boolean modifyLocal, String randSeed, boolean addCurvature) {
        if (!Config.isModEnabled) {
            return this;
        }
        if (Config.isAnimationEnabled) {
            this.calculateVertexDisplacement(localPos, position, modifyLocal, randSeed);
        }
        if (addCurvature && Config.isCurvatureEnabled) {
            this.newLine("%s.y -= dot(%s, %s) / %s;".formatted(modifyLocal ? localPos : position, position, position, Config.worldCurvature));
        }
        return this;
    }

    public FadeShader fragColorMod(String color) {
        return this.fragColorMod(color, true);
    }

    public FadeShader fragColorMod(String color, boolean addIf) {
        return this.fragColorMod(color, "texture(cfi_sky, gl_FragCoord.xy / cfi_screenSize).rgb", addIf);
    }

    public FadeShader fragColorMod(String color, String fadeColor) {
        return this.fragColorMod(color, fadeColor, true);
    }

    public FadeShader fragColorMod(String color, String fadeColor, boolean addIf) {
        if (!Config.isModEnabled || !Config.isFadeEnabled) {
            return this;
        }
        if (addIf) {
            this.newLine("if (cfi_FadeFactor < 1.0) {");
        }
        this.calculateFade("float fade = ");
        this.newLine("%s = mix(%s, %s, fade);".formatted(color, fadeColor, color));
        if (addIf) {
            this.newLine("}");
        }
        return this;
    }

    public FadeShader calculateVertexDisplacement(String localPos, String position, boolean modifyLocal, String randSeed) {
        switch (Config.animationType) {
            case FULL: 
            case JAGGED: {
                this.newLine("%s += chunkFadeData.xyz".formatted(modifyLocal ? localPos : position));
                if (Config.animationType == AnimationType.JAGGED) {
                    this.append(" * rand");
                }
                this.append(";");
                break;
            }
            case DISPLACEMENT: {
                this.newLine("if (%s.x != 0.0 && %s.y != 0.0 && %s.z != 0.0 && %s.x != 16.0 && %s.y != 16.0 && %s.z != 16.0) {".replace("%s", localPos));
                this.randAppend("rand2", "%s - %s".formatted(localPos, randSeed));
                this.randAppend("rand3", "%s + (%s * 2)".formatted(localPos, randSeed));
                this.append("%s += vec3(rand - 0.5, rand2 - 0.5, rand3 - 0.5) * vec3(chunkFadeData.y);".formatted(modifyLocal ? localPos : position));
                this.append("}");
                break;
            }
            case SCALE: {
                if (modifyLocal) {
                    this.newLine("%s = mix(vec3(8.0), %s, 1.0 - chunkFadeData.y);".formatted(localPos, localPos));
                    break;
                }
                this.newLine("%s += vec3(8.0) - mix(vec3(8.0), %s, chunkFadeData.y);".formatted(position, localPos));
            }
        }
        return this;
    }

    public FadeShader calculateFade(String prefix) {
        if (Config.fadeType == FadeType.FULL) {
            this.newLine(prefix + "cfi_FadeFactor;");
        }
        if (Config.fadeType == FadeType.LINED) {
            this.newLine(prefix + "cfi_RefFactor <= cfi_FadeFactor ? 1.0 : 0.0;");
        }
        if (Config.fadeType == FadeType.BLOCK) {
            this.rand("rand", "floor(cfi_BlockSeed)");
            this.newLine(prefix + "cfi_FadeFactor > rand ? 1.0 : cfi_FadeFactor / rand;");
        }
        if (Config.fadeType == FadeType.VERTEX) {
            this.newLine(prefix + "cfi_RefFactor;");
        }
        return this;
    }

    public FadeShader dhApiGetFadeData() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec4 cfi_getFadeData() {");
        this.newLine("return cfi_chunkFadeData;");
        this.newLine("}");
        return this;
    }

    public FadeShader dhApiLodIsMasked2() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("bool cfi_dhLodIsMasked() {");
        this.newLine("return cfi_dhLodIsMasked(cfi_localPos, cfi_worldPos);");
        this.newLine("}");
        return this;
    }

    public FadeShader dhApiLodIsMasked() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("bool cfi_dhLodIsMasked(vec3 localPos, vec3 worldPos) {");
        this.dhMaskLod("return true;", "localPos", "worldPos", false);
        this.newLine("return false;");
        this.newLine("}");
        return this;
    }

    public FadeShader dhApiVertCalculateDisplacement2() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_calculateDisplacement() {");
        this.newLine("return cfi_calculateDisplacement(_vert_position, _cfi_worldPos);");
        this.newLine("}");
        return this;
    }

    public FadeShader dhApiVertCalculateDisplacement() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_calculateDisplacement(vec3 localPos, vec3 worldPos) {");
        if (Config.isAnimationEnabled) {
            this.newLine("vec3 originalPos = localPos;");
            this.newLine("localPos = vec3(localPos);");
            this.newLine("vec4 chunkFadeData = cfi_getFadeData();");
            if (Config.animationType == AnimationType.JAGGED || Config.animationType == AnimationType.DISPLACEMENT) {
                this.rand("rand", "worldPos");
            }
            this.newLine("vec3 offsetPos = floor((worldPos - mod(localPos, 16.0)) / 16.0) + cfi_lodMaskOrigin;");
            this.calculateVertexDisplacement("localPos", null, true, "offsetPos");
            this.newLine("return localPos - originalPos;");
        } else {
            this.newLine("return vec3(0.0);");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dhApiVertInitOutVars2() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("void cfi_initOutVars() {");
        this.newLine("cfi_initOutVars(_vert_position, cfi_worldPos);");
        this.newLine("}");
        return this;
    }

    public FadeShader dhApiVertInitOutVars() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("void cfi_initOutVars(vec3 localPos, vec3 worldPos) {");
        if (Config.isAnimationEnabled || Config.isFadeEnabled) {
            this.newLine("vec4 chunkFadeData = cfi_getFadeData();");
        }
        this.newLine("vec3 offsetPos = floor((worldPos - mod(localPos, 16.0)) / 16.0) + cfi_lodMaskOrigin;");
        this.vertInitOutVars("localPos", "offsetPos");
        this.newLine("}");
        return this;
    }

    public FadeShader dhMaskLod(String whenOccluded, String vertexPos, String vertexWorldPos, boolean addDhFadeCheck) {
        this.newLine("vec2 absWorldPosXZ = abs(%s.xz);".formatted(vertexWorldPos));
        this.newLine("if (absWorldPosXZ.x < cfi_lodMaskMaxDist.x &&absWorldPosXZ.y < cfi_lodMaskMaxDist.z" + (addDhFadeCheck ? " && dot(%s, %s) < cfi_dhStartFadeBlockDistanceSq".formatted(vertexWorldPos, vertexWorldPos) : "") + ") {");
        this.newLine("vec3 offsetPos = %s - mod(%s.xyz + sign(%s) * 0.01, 16.0);".formatted(vertexWorldPos, vertexPos, vertexWorldPos));
        this.newLine("vec3 offsetChunkPos = floor(offsetPos / 16.0) + vec3(1.0);");
        this.newLine("vec2 texChunkXZ = offsetChunkPos.xz + floor(cfi_lodMaskDim.xz / 2.0);");
        this.newLine("float texChunkY = offsetChunkPos.y + cfi_lodMaskOrigin.y - cfi_lodMaskMinY;");
        this.newLine("vec3 uvw = (vec3(texChunkXZ.x, texChunkY, texChunkXZ.y) + vec3(0.5)) / cfi_lodMaskDim;");
        this.newLine("if (texture(cfi_lodMask, uvw).r == 1.0) { %s }".formatted(whenOccluded));
        this.newLine("}");
        return this;
    }

    public FadeShader dhVertOutVars() {
        this.vertOutVars();
        this.newLine("out vec3 cfi_localPos;");
        this.newLine("out vec3 cfi_worldPos;");
        return this;
    }

    public FadeShader dhFragInVars() {
        this.fragInVars();
        this.newLine("in vec3 cfi_localPos;");
        this.newLine("in vec3 cfi_worldPos;");
        return this;
    }

    public FadeShader dhUniforms() {
        this.newLine("uniform vec4 cfi_chunkFadeData;");
        this.newLine("uniform sampler3D cfi_lodMask;");
        this.newLine("uniform vec3 cfi_lodMaskDim;");
        this.newLine("uniform vec3 cfi_lodMaskMaxDist;");
        this.newLine("uniform vec3 cfi_lodMaskOrigin;");
        this.newLine("uniform float cfi_lodMaskMinY;");
        return this;
    }

    public FadeShader rand(String name, String vector) {
        this.newLine("float %s = fract(sin(dot(%s, vec3(12.9898, 78.233, 132.383))) * 43758.5453);".formatted(name, vector));
        this.newLine("if (%s == 0.0) %s = 0.001;".formatted(name, name));
        return this;
    }

    public void randAppend(String name, String vector) {
        this.append("float %s = fract(sin(dot(%s, vec3(12.9898, 78.233, 132.383))) * 43758.5453);".formatted(name, vector));
        this.append("if (%s == 0.0) %s = 0.001;".formatted(name, name));
    }

    public FadeShader newLine(String line) {
        this.lines.add(line);
        return this;
    }

    public FadeShader newLineIf(boolean condition, String line) {
        if (condition) {
            this.lines.add(line);
        }
        return this;
    }

    public FadeShader append(String value) {
        int last = this.lines.size() - 1;
        this.lines.set(last, this.lines.get(last) + value);
        return this;
    }

    public String flushMultiline() {
        return String.join((CharSequence)"\n", this.flushList());
    }

    public String flushSingleLine() {
        return String.join((CharSequence)" ", this.flushList());
    }

    public String[] flushArray() {
        return (String[])this.flushList().toArray(String[]::new);
    }

    public List<String> flushList() {
        List<String> lines = this.lines;
        this.lines = new ArrayList<String>();
        return lines;
    }
}

