/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.AnimationType;
import com.koteinik.chunksfadein.core.FadeMixType;
import com.koteinik.chunksfadein.core.FadeType;
import java.util.ArrayList;
import java.util.List;

public class FadeShader {
    private List<String> lines = new ArrayList<String>();
    private String inPrefix = "";
    private String outPrefix = "";
    private boolean animation = Config.isAnimationEnabled;
    private boolean fade = Config.isFadeEnabled;
    private boolean curvature = Config.isCurvatureEnabled;

    public FadeShader overrideAnimation(boolean value) {
        this.animation = value;
        return this;
    }

    public FadeShader overrideFade(boolean value) {
        this.fade = value;
        return this;
    }

    public FadeShader overrideCurvature(boolean value) {
        this.curvature = value;
        return this;
    }

    public FadeShader inPrefix(String value) {
        this.inPrefix = value;
        return this;
    }

    public FadeShader outPrefix(String value) {
        this.outPrefix = value;
        return this;
    }

    public FadeShader dummyApiFragSampleSkyLodTexture() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_sampleSkyLodTexture() { return vec3(0.0); }");
    }

    public FadeShader apiFragSampleSkyLodTexture() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_sampleSkyLodTexture() {");
        if (this.fade) {
            this.newLine("return texture(cfi_sky, gl_FragCoord.xy / cfi_screenSize).rgb;");
        } else {
            this.newLine("return iris_FogColor.rgb;");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiFragApplySkyLodFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_applySkyLodFade(vec3 fullyFaded) { return vec3(0.0); }");
    }

    public FadeShader apiFragApplySkyLodFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_applySkyLodFade(vec3 fullyFaded) {");
        if (this.fade) {
            this.newLine("return cfi_applyFade(cfi_sampleSkyLodTexture(), fullyFaded);");
        } else {
            this.newLine("return fullyFaded;");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiFragApplyFogFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_applyFogFade(vec3 fullyFaded) { return vec3(0.0); }");
    }

    public FadeShader apiFragApplyFogFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_applyFogFade(vec3 fullyFaded) {");
        if (this.fade) {
            this.newLine("return cfi_applyFade(iris_FogColor.rgb, fullyFaded);");
        } else {
            this.newLine("return fullyFaded;");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiFragApplyFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_applyFade(vec3 fullyUnfaded, vec3 fullyFaded) { return vec3(0.0); }");
    }

    public FadeShader apiFragApplyFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_applyFade(vec3 fullyUnfaded, vec3 fullyFaded) {");
        if (this.fade) {
            this.newLine("return mix(fullyUnfaded, fullyFaded, cfi_calculateFade());");
        } else {
            this.newLine("return fullyFaded;");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiFragCalculateFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("float cfi_calculateFade() { return 0.0; }");
    }

    public FadeShader apiFragCalculateFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("float cfi_calculateFade() {");
        if (this.fade) {
            this.newLine("float fade = 0.0;");
            this.calculateFade("fade = ");
            this.newLine("return fade;");
        } else {
            this.newLine("return 1.0;");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiVertCalculateCurvature2() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_calculateCurvature() { return vec3(0.0); }");
    }

    public FadeShader apiVertCalculateCurvature2() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_calculateCurvature() {");
        this.newLine("return cfi_calculateCurvature(getVertexPosition().xyz);");
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiVertCalculateCurvature() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_calculateCurvature(vec3 globalPos) { return vec3(0.0); }");
    }

    public FadeShader apiVertCalculateCurvature() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_calculateCurvature(vec3 globalPos) {");
        if (this.curvature) {
            this.newLine("return vec3(0.0, -dot(globalPos, globalPos) / " + Config.worldCurvature + ", 0.0);");
        } else {
            this.newLine("return vec3(0.0);");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiVertCalculateDisplacement2() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_calculateDisplacement() { return vec3(0.0); }");
    }

    public FadeShader apiVertCalculateDisplacement2() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_calculateDisplacement() {");
        this.newLine("return cfi_calculateDisplacement(_vert_position);");
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiVertCalculateDisplacement() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_calculateDisplacement(vec3 localPos) { return vec3(0.0); }");
    }

    public FadeShader apiVertCalculateDisplacement() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_calculateDisplacement(vec3 localPos) {");
        if (this.animation) {
            this.newLine("vec3 originalPos = localPos;");
            this.newLine("localPos = vec3(localPos);");
            this.newLine("vec4 chunkFadeData = cfi_getFadeData();");
            if (Config.animationType == AnimationType.JAGGED || Config.animationType == AnimationType.DISPLACEMENT) {
                this.newLine("float rand = _cfi_rand(localPos + vec3(_draw_id));");
            }
            this.calculateVertexDisplacement("localPos", null, true, "int(_draw_id)");
            this.newLine("return localPos - originalPos;");
        } else {
            this.newLine("return vec3(0.0);");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiVertGetFadeData() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec4 cfi_getFadeData() { return vec4(0.0); }");
    }

    public FadeShader apiVertGetFadeData(String drawId) {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec4 cfi_getFadeData() {");
        this.newLine("return cfi_ChunkFadeDatas[%s].fadeData;".formatted(drawId));
        this.newLine("}");
        return this;
    }

    public FadeShader vertInVars() {
        this.newLine("struct cfi_ChunkFadeData { vec4 fadeData; };");
        this.newLine("layout(std140) uniform cfi_ubo_ChunkFadeDatas { cfi_ChunkFadeData cfi_ChunkFadeDatas[256]; };");
        return this;
    }

    public FadeShader vertOutVars() {
        if (!Config.isModEnabled || !this.fade) {
            return this;
        }
        this.insertVars("out", "flat out", "{out}", "");
        return this;
    }

    public FadeShader geomVars() {
        if (!Config.isModEnabled || !this.fade) {
            return this;
        }
        this.insertVars("in", "flat in", "{in}", "[]");
        this.insertVars("out", "flat out", "{out}", "");
        if (Config.fadeType != FadeType.FULL) {
            this.newLine("int cfi_counter;");
        }
        return this;
    }

    public FadeShader geomMainHead() {
        if (!Config.isModEnabled || !this.fade) {
            return this;
        }
        if (Config.fadeType != FadeType.FULL) {
            this.newLine("cfi_counter = 0;");
        }
        this.newLine("{out}cfi_FadeFactor = {in}cfi_FadeFactor[0];");
        return this;
    }

    public FadeShader geomProxyVars() {
        if (!Config.isModEnabled || !this.fade) {
            return this;
        }
        if (Config.fadeType != FadeType.FULL) {
            this.newLine("cfi_counter++;");
            this.newLine("cfi_counter = int(mod(cfi_counter, gl_in.length()));");
        }
        if (Config.fadeType == FadeType.BLOCK || Config.fadeType == FadeType.FRAGMENTED) {
            this.newLine("{out}cfi_BlockSeed = {in}cfi_BlockSeed[cfi_counter];");
        }
        if (Config.fadeType == FadeType.LINED) {
            this.newLine("{out}cfi_RefFactor = {in}cfi_RefFactor[cfi_counter];");
        }
        if (Config.fadeType == FadeType.VERTEX) {
            this.newLine("{out}cfi_RefFactor = {in}cfi_RefFactor[cfi_counter];");
        }
        return this;
    }

    public FadeShader tessControlVars() {
        if (!Config.isModEnabled || !this.fade) {
            return this;
        }
        this.insertVars("in", "flat in", "{in}", "[]");
        this.insertVars("patch out", "patch out", "{out}", "");
        return this;
    }

    public FadeShader tessControlProxyVars() {
        if (!Config.isModEnabled || !this.fade) {
            return this;
        }
        this.newLine("{out}cfi_FadeFactor = {in}cfi_FadeFactor[0];");
        if (Config.fadeType == FadeType.BLOCK || Config.fadeType == FadeType.FRAGMENTED) {
            this.newLine("{out}cfi_BlockSeed = {in}cfi_BlockSeed[0];");
        }
        if (Config.fadeType == FadeType.LINED) {
            this.newLine("{out}cfi_RefFactor = {in}cfi_RefFactor[0];");
        }
        if (Config.fadeType == FadeType.VERTEX) {
            this.newLine("{out}cfi_RefFactor = {in}cfi_RefFactor[0];");
        }
        return this;
    }

    public FadeShader tessEvalVars(boolean hasTessControl) {
        if (!Config.isModEnabled || !this.fade) {
            return this;
        }
        if (hasTessControl) {
            this.insertVars("patch in", "patch in", "{in}", "");
        } else {
            this.insertVars("in", "flat in", "{in}", "[]");
        }
        this.insertVars("out", "flat out", "{out}", "");
        return this;
    }

    public FadeShader tessEvalProxyVars(boolean hasTessControl) {
        if (!Config.isModEnabled || !this.fade) {
            return this;
        }
        if (hasTessControl) {
            this.newLine("{out}cfi_FadeFactor = {in}cfi_FadeFactor;");
            if (Config.fadeType == FadeType.BLOCK || Config.fadeType == FadeType.FRAGMENTED) {
                this.newLine("{out}cfi_BlockSeed = {in}cfi_BlockSeed;");
            }
            if (Config.fadeType == FadeType.LINED) {
                this.newLine("{out}cfi_RefFactor = {in}cfi_RefFactor;");
            }
            if (Config.fadeType == FadeType.VERTEX) {
                this.newLine("{out}cfi_RefFactor = {in}cfi_RefFactor;");
            }
        } else {
            this.newLine("{out}cfi_FadeFactor = {in}cfi_FadeFactor[0];");
            if (Config.fadeType == FadeType.BLOCK || Config.fadeType == FadeType.FRAGMENTED) {
                this.newLine("{out}cfi_BlockSeed = {in}cfi_BlockSeed[0];");
            }
            if (Config.fadeType == FadeType.LINED) {
                this.newLine("{out}cfi_RefFactor = {in}cfi_RefFactor[0];");
            }
            if (Config.fadeType == FadeType.VERTEX) {
                this.newLine("{out}cfi_RefFactor = {in}cfi_RefFactor[0];");
            }
        }
        return this;
    }

    public FadeShader fragInVars() {
        if (!Config.isModEnabled || !this.fade) {
            return this;
        }
        this.newLine("uniform sampler2D cfi_sky;");
        this.newLine("uniform vec2 cfi_screenSize;");
        this.insertVars("in", "flat in", "{in}", "");
        return this;
    }

    private FadeShader insertVars(String mods, String flatMods, String prefix, String suffix) {
        this.newLine("%s float %scfi_FadeFactor%s;".formatted(flatMods, prefix, suffix));
        if (Config.fadeType == FadeType.BLOCK || Config.fadeType == FadeType.FRAGMENTED) {
            this.newLine("%s vec3 %scfi_BlockSeed%s;".formatted(mods, prefix, suffix));
        }
        if (Config.fadeType == FadeType.LINED) {
            this.newLine("%s float %scfi_RefFactor%s;".formatted(mods, prefix, suffix));
        }
        if (Config.fadeType == FadeType.VERTEX) {
            this.newLine("%s float %scfi_RefFactor%s;".formatted(flatMods, prefix, suffix));
        }
        return this;
    }

    public FadeShader vertInitOutVarsDrawId(String localPos, String drawId) {
        if (!Config.isModEnabled) {
            return this;
        }
        if (this.animation || this.fade) {
            this.newLine("vec4 chunkFadeData = cfi_ChunkFadeDatas[%s].fadeData;".formatted(drawId));
        }
        return this.vertInitOutVars(localPos, "vec3(%s)".formatted(drawId));
    }

    public FadeShader vertInitOutVars(String localPos, String randSeed) {
        if (!Config.isModEnabled) {
            return this;
        }
        if ((this.animation || this.fade) && (Config.animationType == AnimationType.JAGGED || Config.animationType == AnimationType.DISPLACEMENT || Config.fadeType == FadeType.VERTEX)) {
            this.newLine("float rand = _cfi_rand(%s + %s);".formatted(localPos, randSeed));
        }
        if (this.fade) {
            this.newLine("{out}cfi_FadeFactor = chunkFadeData.w;");
            if (Config.fadeType == FadeType.BLOCK || Config.fadeType == FadeType.FRAGMENTED) {
                this.newLine("{out}cfi_BlockSeed = %s + %s;".formatted(localPos, randSeed));
            }
            if (Config.fadeType == FadeType.VERTEX) {
                this.newLine("{out}cfi_RefFactor = {out}cfi_FadeFactor > rand ? 1.0 : {out}cfi_FadeFactor / rand;");
            }
            if (Config.fadeType == FadeType.LINED) {
                this.newLine("float refFactor = %s.y / 17.0;".formatted(localPos));
                this.newLine("{out}cfi_RefFactor = refFactor - floor(refFactor);");
            }
        }
        return this;
    }

    public FadeShader vertInitMod(String localPos, String position, boolean modifyLocal, String randSeed, boolean addCurvature) {
        if (!Config.isModEnabled) {
            return this;
        }
        if (this.animation) {
            this.calculateVertexDisplacement(localPos, position, modifyLocal, randSeed);
        }
        if (addCurvature && this.curvature) {
            this.newLine("%s.y -= dot(%s, %s) / %s;".formatted(modifyLocal ? localPos : position, position, position, Config.worldCurvature));
        }
        return this;
    }

    public FadeShader fragColorMod(String color) {
        return this.fragColorMod(color, true);
    }

    public FadeShader fragColorMod(String color, boolean addIf) {
        return this.fragColorMod(color, "texture(cfi_sky, gl_FragCoord.xy / cfi_screenSize).rgb", addIf);
    }

    public FadeShader fragColorMod(String color, String fadeColor) {
        return this.fragColorMod(color, fadeColor, true);
    }

    public FadeShader fragColorMod(String color, String fadeColor, boolean addIf) {
        if (!Config.isModEnabled || !this.fade) {
            return this;
        }
        if (addIf) {
            this.newLine("if ({in}cfi_FadeFactor < 1.0) {");
        }
        this.calculateFade("float fade = ");
        if (Config.fadeMixType == FadeMixType.OKLAB) {
            this.newLine("%s = _cfi_mix_srgb_in_oklab(%s, %s, fade);".formatted(color, fadeColor, color));
        } else {
            this.newLine("%s = mix(%s, %s, fade);".formatted(color, fadeColor, color));
        }
        if (addIf) {
            this.newLine("}");
        }
        return this;
    }

    public FadeShader calculateVertexDisplacement(String localPos, String position, boolean modifyLocal, String randSeed) {
        switch (Config.animationType) {
            case FULL: 
            case JAGGED: {
                this.newLine("%s += chunkFadeData.xyz".formatted(modifyLocal ? localPos : position));
                if (Config.animationType == AnimationType.JAGGED) {
                    this.append(" * rand");
                }
                this.append(";");
                break;
            }
            case DISPLACEMENT: {
                this.newLine("if (%s.x != 0.0 && %s.y != 0.0 && %s.z != 0.0 && %s.x != 16.0 && %s.y != 16.0 && %s.z != 16.0) {".replace("%s", localPos));
                this.newLine("float rand2 = _cfi_rand(%s - %s);".formatted(localPos, randSeed));
                this.newLine("float rand3 = _cfi_rand(%s + (%s * 2));".formatted(localPos, randSeed));
                this.append("%s += vec3(rand - 0.5, rand2 - 0.5, rand3 - 0.5) * vec3(chunkFadeData.y);".formatted(modifyLocal ? localPos : position));
                this.append("}");
                break;
            }
            case SCALE: {
                if (modifyLocal) {
                    this.newLine("%s = mix(vec3(8.0), %s, 1.0 - chunkFadeData.y);".formatted(localPos, localPos));
                    break;
                }
                this.newLine("%s += vec3(8.0) - mix(vec3(8.0), %s, chunkFadeData.y);".formatted(position, localPos));
            }
        }
        return this;
    }

    public FadeShader calculateFade(String prefix) {
        if (Config.fadeType == FadeType.FULL) {
            this.newLine(prefix + "{in}cfi_FadeFactor;");
        }
        if (Config.fadeType == FadeType.LINED) {
            this.newLine(prefix + "{in}cfi_RefFactor <= {in}cfi_FadeFactor ? 1.0 : 0.0;");
        }
        if (Config.fadeType == FadeType.BLOCK) {
            this.newLine("float rand = _cfi_rand(floor({in}cfi_BlockSeed));");
            this.newLine(prefix + "{in}cfi_FadeFactor > rand ? 1.0 : {in}cfi_FadeFactor / rand;");
        }
        if (Config.fadeType == FadeType.VERTEX) {
            this.newLine(prefix + "{in}cfi_RefFactor;");
        }
        if (Config.fadeType == FadeType.FRAGMENTED) {
            this.newLine("float rand = _cfi_rand(floor({in}cfi_BlockSeed));");
            this.newLine("float start = rand * (1.0 - 0.2);");
            this.newLine(prefix + "smoothstep(start, start + 0.2, {in}cfi_FadeFactor);");
        }
        return this;
    }

    public FadeShader dhApiGetFadeData() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec4 cfi_getFadeData() {");
        this.newLine("return cfi_chunkFadeData;");
        this.newLine("}");
        return this;
    }

    public FadeShader dhApiLodIsMasked2() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("bool cfi_dhLodIsMasked() {");
        this.newLine("return cfi_dhLodIsMasked(cfi_localPos, cfi_worldPos);");
        this.newLine("}");
        return this;
    }

    public FadeShader dhApiLodIsMasked() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("bool cfi_dhLodIsMasked(vec3 localPos, vec3 worldPos) {");
        this.dhMaskLod("return true;", "localPos", "worldPos", false);
        this.newLine("return false;");
        this.newLine("}");
        return this;
    }

    public FadeShader dhApiVertCalculateDisplacement2() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_calculateDisplacement() {");
        this.newLine("return cfi_calculateDisplacement(_vert_position, _cfi_worldPos);");
        this.newLine("}");
        return this;
    }

    public FadeShader dhApiVertCalculateDisplacement() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_calculateDisplacement(vec3 localPos, vec3 worldPos) {");
        if (this.animation) {
            this.newLine("vec3 originalPos = localPos;");
            this.newLine("localPos = vec3(localPos);");
            this.newLine("vec4 chunkFadeData = cfi_getFadeData();");
            if (Config.animationType == AnimationType.JAGGED || Config.animationType == AnimationType.DISPLACEMENT) {
                this.newLine("float rand = _cfi_rand(worldPos);");
            }
            this.newLine("vec3 offsetPos = floor((worldPos - mod(localPos, 16.0)) / 16.0) + cfi_lodMaskOrigin;");
            this.calculateVertexDisplacement("localPos", null, true, "offsetPos");
            this.newLine("return localPos - originalPos;");
        } else {
            this.newLine("return vec3(0.0);");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dhApiVertInitOutVars2() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("void cfi_initOutVars() {");
        this.newLine("cfi_initOutVars(_vert_position, cfi_worldPos);");
        this.newLine("}");
        return this;
    }

    public FadeShader dhApiVertInitOutVars() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("void cfi_initOutVars(vec3 localPos, vec3 worldPos) {");
        if (this.animation || this.fade) {
            this.newLine("vec4 chunkFadeData = cfi_getFadeData();");
        }
        this.newLine("vec3 offsetPos = floor((worldPos - mod(localPos, 16.0)) / 16.0) + cfi_lodMaskOrigin;");
        this.vertInitOutVars("localPos", "offsetPos");
        this.newLine("}");
        return this;
    }

    public FadeShader dhMaskLod(String whenOccluded, String vertexPos, String vertexWorldPos, boolean addDhFadeCheck) {
        this.newLine("vec2 absWorldPosXZ = abs(%s.xz);".formatted(vertexWorldPos));
        this.newLine("if (absWorldPosXZ.x < cfi_lodMaskMaxDist.x &&absWorldPosXZ.y < cfi_lodMaskMaxDist.z" + (addDhFadeCheck ? " && dot(%s, %s) < cfi_dhStartFadeBlockDistanceSq".formatted(vertexWorldPos, vertexWorldPos) : "") + ") {");
        this.newLine("vec3 offsetPos = %s - mod(%s.xyz + sign(%s) * 0.01, 16.0);".formatted(vertexWorldPos, vertexPos, vertexWorldPos));
        this.newLine("vec3 offsetChunkPos = floor(offsetPos / 16.0) + vec3(1.0);");
        this.newLine("vec2 texChunkXZ = offsetChunkPos.xz + floor(cfi_lodMaskDim.xz / 2.0);");
        this.newLine("float texChunkY = offsetChunkPos.y + cfi_lodMaskOrigin.y - cfi_lodMaskMinY;");
        this.newLine("vec3 uvw = (vec3(texChunkXZ.x, texChunkY, texChunkXZ.y) + vec3(0.5)) / cfi_lodMaskDim;");
        this.newLine("if (texture(cfi_lodMask, uvw).r == 1.0) { %s }".formatted(whenOccluded));
        this.newLine("}");
        return this;
    }

    public FadeShader dhVertOutVars() {
        this.vertOutVars();
        this.newLine("out vec3 cfi_localPos;");
        this.newLine("out vec3 cfi_worldPos;");
        return this;
    }

    public FadeShader dhFragInVars() {
        this.fragInVars();
        this.newLine("in vec3 cfi_localPos;");
        this.newLine("in vec3 cfi_worldPos;");
        return this;
    }

    public FadeShader dhUniforms() {
        this.newLine("uniform vec4 cfi_chunkFadeData;");
        this.newLine("uniform sampler3D cfi_lodMask;");
        this.newLine("uniform vec3 cfi_lodMaskDim;");
        this.newLine("uniform vec3 cfi_lodMaskMaxDist;");
        this.newLine("uniform vec3 cfi_lodMaskOrigin;");
        this.newLine("uniform float cfi_lodMaskMinY;");
        return this;
    }

    public FadeShader utilFunctions() {
        this.utilRand();
        this.utilSrgbToOklab();
        this.utilOklabToSrgb();
        this.utilMixSrgbInOklab();
        return this;
    }

    public FadeShader utilRand() {
        this.newLine("float _cfi_rand(vec3 vec) {");
        this.newLine("    float value = fract(sin(dot(vec, vec3(12.9898, 78.233, 132.383))) * 43758.5453);");
        this.newLine("    if (value == 0.0) value = 0.001;");
        this.newLine("    return value;");
        this.newLine("}");
        return this;
    }

    public FadeShader utilSrgbToOklab() {
        this.newLine("vec3 _cfi_srgb_to_oklab(vec3 c) {");
        this.newLine("    vec3 lin = c * c;");
        this.newLine("    float l = 0.4122214708 * lin.r + 0.5363325363 * lin.g + 0.0514459929 * lin.b;");
        this.newLine("    float m = 0.2119034982 * lin.r + 0.6806995451 * lin.g + 0.1073969566 * lin.b;");
        this.newLine("    float s = 0.0883024619 * lin.r + 0.2817188376 * lin.g + 0.6299787005 * lin.b;");
        this.newLine("    float l_ = pow(l, 0.3333333333);");
        this.newLine("    float m_ = pow(m, 0.3333333333);");
        this.newLine("    float s_ = pow(s, 0.3333333333);");
        this.newLine("    return vec3(");
        this.newLine("        0.2104542553 * l_ + 0.7936177850 * m_ - 0.0040720468 * s_,");
        this.newLine("        1.9779984951 * l_ - 2.4285922050 * m_ + 0.4505937099 * s_,");
        this.newLine("        0.0259040371 * l_ + 0.7827717662 * m_ - 0.8086757660 * s_");
        this.newLine("    );");
        this.newLine("}");
        return this;
    }

    public FadeShader utilOklabToSrgb() {
        this.newLine("vec3 _cfi_oklab_to_srgb(vec3 c) {");
        this.newLine("    float l_ = c.x + 0.3963377774 * c.y + 0.2158037573 * c.z;");
        this.newLine("    float m_ = c.x - 0.1055613458 * c.y - 0.0638541728 * c.z;");
        this.newLine("    float s_ = c.x - 0.0894841775 * c.y - 1.2914855480 * c.z;");
        this.newLine("    float l = l_ * l_ * l_;");
        this.newLine("    float m = m_ * m_ * m_;");
        this.newLine("    float s = s_ * s_ * s_;");
        this.newLine("    return sqrt(vec3(");
        this.newLine("        4.0767416621 * l - 3.3077115913 * m + 0.2309699292 * s,");
        this.newLine("        -1.2684380046 * l + 2.6097574011 * m - 0.3413193965 * s,");
        this.newLine("        -0.0041960863 * l - 0.7034186147 * m + 1.7076147010 * s");
        this.newLine("    ));");
        this.newLine("}");
        return this;
    }

    public FadeShader utilMixSrgbInOklab() {
        this.newLine("vec3 _cfi_mix_srgb_in_oklab(vec3 a, vec3 b, float t) {");
        this.newLine("    vec3 labA = _cfi_srgb_to_oklab(a);");
        this.newLine("    vec3 labB = _cfi_srgb_to_oklab(b);");
        this.newLine("    vec3 mixedLab = mix(labA, labB, t);");
        this.newLine("    return _cfi_oklab_to_srgb(mixedLab);");
        this.newLine("}");
        return this;
    }

    public FadeShader newLine(String line) {
        this.lines.add(this.parseLine(line));
        return this;
    }

    public FadeShader newLineIf(boolean condition, String line) {
        if (condition) {
            this.lines.add(this.parseLine(line));
        }
        return this;
    }

    public FadeShader append(String value) {
        int last = this.lines.size() - 1;
        this.lines.set(last, this.parseLine(this.lines.get(last) + value));
        return this;
    }

    private String parseLine(String line) {
        return line.replace("{in}", this.inPrefix).replace("{out}", this.outPrefix);
    }

    public String flushMultiline() {
        return String.join((CharSequence)"\n", this.flushList());
    }

    public String flushSingleLine() {
        return String.join((CharSequence)" ", this.flushList());
    }

    public String[] flushArray() {
        return (String[])this.flushList().toArray(String[]::new);
    }

    public List<String> flushList() {
        List<String> lines = this.lines;
        this.lines = new ArrayList<String>();
        return lines;
    }
}

