package com.koteinik.chunksfadein.compat.sodium.mixin.ext;

import com.koteinik.chunksfadein.compat.sodium.ext.RenderSectionManagerExt;
import com.koteinik.chunksfadein.compat.sodium.ext.SodiumWorldRendererExt;
import com.koteinik.chunksfadein.config.Config;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionManager;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3191;
import net.minecraft.class_4076;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_746;
import net.minecraft.class_824;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.SortedSet;

@Mixin(value = SodiumWorldRenderer.class, remap = false)
public class SodiumWorldRendererMixin implements SodiumWorldRendererExt {
	@Shadow
	private RenderSectionManager renderSectionManager;

	@Override
	public float[] getAnimationOffset(class_243 pos) {
		class_4076 chunkPos = class_4076.method_18680(pos);
		float[] offset = ((RenderSectionManagerExt) renderSectionManager).getAnimationOffset(
			chunkPos.method_10263(),
			chunkPos.method_10264(),
			chunkPos.method_10260()
		);

		if (Config.isCurvatureEnabled) {
			class_310 client = class_310.method_1551();

			class_1297 camera = client.method_1560();
			if (camera != null) {
				float len = (float) pos.method_1020(camera.method_19538()).method_1033();

				if (offset == null)
					offset = new float[3];
				else
					offset = offset.clone();

				offset[1] -= (len * len) / Config.worldCurvature;
			}
		}

		return offset;
	}

	@Override
	public @Nullable RenderSectionManagerExt getRenderSectionManager() {
		return (RenderSectionManagerExt) renderSectionManager;
	}

	@Inject(method = "<init>", at = @At("RETURN"))
	private void modifyInit(class_310 client, CallbackInfo ci) {
		SodiumWorldRendererExt.Holder.instance = this;
	}

	@Inject(
		method = "renderBlockEntity",
		at = @At(
			value = "INVOKE",
			target = "Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V",
			shift = At.Shift.AFTER,
			remap = true
		)
	)
	private static void modifySubmitBlockEntities(
		class_4587 matrices, class_4599 bufferBuilders, Long2ObjectMap<SortedSet<class_3191>> blockBreakingProgressions, float tickDelta, class_4597.class_4598 immediate, double x, double y, double z, class_824 dispatcher, class_2586 entity, class_746 player, LocalBooleanRef isGlowing, CallbackInfo ci
	) {
		if (!Config.isModEnabled || (!Config.isAnimationEnabled && !Config.isCurvatureEnabled))
			return;

		SodiumWorldRendererExt ext = ((SodiumWorldRendererExt) SodiumWorldRenderer.instance());
		if (ext.getRenderSectionManager() == null)
			return;

		float[] offset = ext.getAnimationOffset(entity.method_11016().method_46558());

		matrices.method_46416(offset[0], offset[1], offset[2]);
	}
}
