package com.koteinik.chunksfadein.core;

import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

import javax.imageio.ImageIO;
import net.minecraft.class_243;
import net.minecraft.class_310;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Utils {
	public static int mainTargetWidth() {
		return class_310.method_1551().method_1522().field_1482;
	}

	public static int mainTargetHeight() {
		return class_310.method_1551().method_1522().field_1481;
	}

	public static int mainColorTexture() {
		return class_310.method_1551().method_1522().method_30277();
	}

	public static class_243 cameraPosition() {
		return class_310.method_1551().field_1773.method_19418().method_19326();
	}

	public static int chunkRenderDistance() {
		return (int) Math.floor(class_310.method_1551().field_1773.method_3193() / 16);
	}

	public static void debugWriteTexture(int texture, int width, int height, File file) {
		if (file.exists()) return;
		file.getParentFile().mkdirs();

		ByteBuffer buffer = BufferUtils.createByteBuffer(width * height * 4);
		GL11.glBindTexture(GL11.GL_TEXTURE_2D, texture);
		GL12.glGetTexImage(GL12.GL_TEXTURE_2D, 0, GL12.GL_RGBA, GL12.GL_UNSIGNED_BYTE, buffer);

		BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
		for (int y = 0; y < height; y++) {
			for (int x = 0; x < width; x++) {
				int i = (x + y * width) * 4;

				int r = buffer.get(i) & 0xFF;
				int g = buffer.get(i + 1) & 0xFF;
				int b = buffer.get(i + 2) & 0xFF;
				int a = buffer.get(i + 3) & 0xFF;
				a = 255;

				int argb = (a << 24) | (r << 16) | (g << 8) | b;

				image.setRGB(x, height - 1 - y, argb);
			}
		}

		try {
			ImageIO.write(image, "png", file);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
