/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.Logger;
import com.koteinik.chunksfadein.core.GlStateSaver;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryStack;

public class SkyFBO {
    private static SkyFBO instance = null;
    public final int id;
    public final int textureId;
    public final int width;
    public final int height;
    private int cachedReadId = -1;

    public static synchronized SkyFBO getInstance() {
        Window window = Minecraft.getInstance().getWindow();
        int windowWidth = window.getWidth();
        int windowHeight = window.getHeight();
        try {
            if (instance == null) {
                instance = new SkyFBO(windowWidth, windowHeight);
            } else if (SkyFBO.instance.width != windowWidth || SkyFBO.instance.height != windowHeight) {
                instance.cleanup();
                instance = new SkyFBO(windowWidth, windowHeight);
            }
        }
        catch (Exception e) {
            Logger.error("Failed to create SkyFBO: ", e);
            instance = null;
        }
        return instance;
    }

    public static int getWidth() {
        SkyFBO instance = SkyFBO.getInstance();
        if (instance == null) {
            return -1;
        }
        return instance.width;
    }

    public static int getHeight() {
        SkyFBO instance = SkyFBO.getInstance();
        if (instance == null) {
            return -1;
        }
        return instance.height;
    }

    public static int getTextureId() {
        SkyFBO instance = SkyFBO.getInstance();
        if (instance == null) {
            return -1;
        }
        return instance.textureId;
    }

    public static void active(int texture) {
        SkyFBO instance = SkyFBO.getInstance();
        if (instance == null) {
            return;
        }
        instance.activeTexture(texture);
    }

    public static void bindAttachment(int attachment) {
        SkyFBO instance = SkyFBO.getInstance();
        if (instance == null) {
            return;
        }
        instance.bindColorAttachment(attachment);
    }

    public SkyFBO(int width, int height) throws Exception {
        this.width = width;
        this.height = height;
        this.id = GL30.glGenFramebuffers();
        GlStateSaver.GlSavedState state = GlStateSaver.saveState();
        GlStateManager._glBindFramebuffer((int)36160, (int)this.id);
        this.textureId = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)this.textureId);
        GlStateManager._texImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        GlStateManager._texParameter((int)3553, (int)10241, (int)9729);
        GlStateManager._texParameter((int)3553, (int)10240, (int)9729);
        GlStateManager._texParameter((int)3553, (int)10242, (int)33071);
        GlStateManager._texParameter((int)3553, (int)10243, (int)33071);
        GlStateManager._glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.textureId, (int)0);
        SkyFBO.checkStatus(36160);
        state.restore();
    }

    public void blitFromTexture(int srcTex, int srcWidth, int srcHeight, boolean restoreState) {
        if (this.cachedReadId == -1) {
            this.cachedReadId = GL30.glGenFramebuffers();
        }
        int lastRead = restoreState ? GL11.glGetInteger((int)36010) : 0;
        int lastDraw = restoreState ? GL11.glGetInteger((int)36006) : 0;
        GlStateManager._glBindFramebuffer((int)36008, (int)this.cachedReadId);
        GlStateManager._glFramebufferTexture2D((int)36008, (int)36064, (int)3553, (int)srcTex, (int)0);
        GlStateManager._glBindFramebuffer((int)36009, (int)this.id);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)srcWidth, (int)srcHeight, (int)0, (int)0, (int)this.width, (int)this.height, (int)16384, (int)9728);
        GlStateManager._glBindFramebuffer((int)36008, (int)lastRead);
        GlStateManager._glBindFramebuffer((int)36009, (int)lastDraw);
    }

    public void blitFromFramebuffer(int buffer, int srcWidth, int srcHeight, boolean restoreState) {
        int lastRead = restoreState ? GL11.glGetInteger((int)36010) : 0;
        int lastDraw = restoreState ? GL11.glGetInteger((int)36006) : 0;
        GlStateManager._glBindFramebuffer((int)36008, (int)buffer);
        GlStateManager._glBindFramebuffer((int)36009, (int)this.id);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)srcWidth, (int)srcHeight, (int)0, (int)0, (int)this.width, (int)this.height, (int)16384, (int)9728);
        GlStateManager._glBindFramebuffer((int)36008, (int)lastRead);
        GlStateManager._glBindFramebuffer((int)36009, (int)lastDraw);
    }

    public void bindColorAttachment(int attachment) {
        GL30.glFramebufferTexture2D((int)36160, (int)attachment, (int)3553, (int)this.textureId, (int)0);
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer drawBuffers = stack.mallocInt(2);
            drawBuffers.put(36064);
            drawBuffers.put(attachment);
            drawBuffers.flip();
            GL20.glDrawBuffers((IntBuffer)drawBuffers);
        }
    }

    public void activeTexture(int slot) {
        GL13.glActiveTexture((int)(33984 + slot));
        GL11.glBindTexture((int)3553, (int)this.textureId);
    }

    public void cleanup() {
        if (this.id != -1) {
            GL30.glDeleteFramebuffers((int)this.id);
        }
        if (this.textureId != -1) {
            GL11.glDeleteTextures((int)this.textureId);
        }
        if (this.cachedReadId != -1) {
            GL30.glDeleteFramebuffers((int)this.cachedReadId);
        }
    }

    private static void checkStatus(int target) throws Exception {
        int status = GL30.glCheckFramebufferStatus((int)target);
        if (status != 36053) {
            GL30.glBindFramebuffer((int)target, (int)0);
            throw new Exception("Framebuffer incomplete: " + status);
        }
    }
}

