/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.crowdin;

import com.koteinik.chunksfadein.crowdin.Translations;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class TranslationsPack
implements PackResources {
    public IoSupplier<InputStream> getRootResource(String ... names) {
        File file = new File(Translations.getPackRootDir(), names[0]);
        if (file.exists()) {
            return IoSupplier.create((Path)file.toPath());
        }
        return null;
    }

    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation loc) {
        return this.getRootResource(type.getDirectory() + "/" + loc.getNamespace() + "/" + loc.getPath());
    }

    public void listResources(PackType type, String namespace, String prefix, PackResources.ResourceOutput consumer) {
        String[] files = new File(Translations.getPackRootDir(), "assets/" + namespace + "/" + prefix).list();
        if (files == null || files.length == 0) {
            return;
        }
        List results = Arrays.asList(files).stream().map(TranslationsPack::fromPath).collect(Collectors.toList());
        for (ResourceLocation result : results) {
            consumer.accept((Object)result, this.getResource(type, result));
        }
    }

    public Set<String> getNamespaces(PackType type) {
        return Set.of("chunksfadein");
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> deserializer) throws IOException {
        return null;
    }

    public PackLocationInfo location() {
        return new PackLocationInfo("chunksfadein-translations", (Component)Component.literal((String)"Chunks Fade In internal pack with translations"), PackSource.DEFAULT, Optional.empty());
    }

    public void close() {
    }

    private static ResourceLocation fromPath(String path) {
        if (path.startsWith("assets/")) {
            path = path.substring("assets/".length());
        }
        String[] split = path.split("/", 2);
        return ResourceLocation.fromNamespaceAndPath((String)split[0], (String)split[1]);
    }
}

