package com.koteinik.chunksfadein.compat.dh;

import com.koteinik.chunksfadein.core.Fader;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import org.joml.Vector2i;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class DHState {
	public static final ThreadLocal<Long> sectionPosForCreatingBuffer = new ThreadLocal<>();

	private static final Map<Vector2i, Fader> faders = new ConcurrentHashMap<>();
	private static int lastLevel = 0;

	public synchronized static Fader getFader(long pos) {
		class_638 level = class_310.method_1551().field_1687;
		if (level != null && lastLevel != level.hashCode()) {
			lastLevel = level.hashCode();
			faders.clear();
		}

		Vector2i blockPos = blockPos(pos);
		Fader fader = faders.get(blockPos);

		if (fader == null)
			populateDescendantFaders(pos, fader = new Fader(blockPos.x, blockPos.y));

		return fader;
	}

	private static void populateDescendantFaders(long pos, Fader fader) {
		faders.put(blockPos(pos), fader);

		if (DhSectionPos.getDetailLevel(pos) > 0)
			for (int i = 0; i < 4; i++)
				populateDescendantFaders(DhSectionPos.getChildByIndex(pos, i), fader);
	}

	private static Vector2i blockPos(long pos) {
		return new Vector2i(
			DhSectionPos.getMinCornerBlockX(pos),
			DhSectionPos.getMinCornerBlockZ(pos)
		);
	}
}
