package com.koteinik.chunksfadein.compat.sodium.mixin;

import com.koteinik.chunksfadein.compat.sodium.ext.RenderSectionManagerExt;
import com.koteinik.chunksfadein.compat.sodium.ext.SodiumWorldRendererExt;
import com.koteinik.chunksfadein.config.Config;
import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionManager;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value = SodiumWorldRenderer.class, remap = false)
public class SodiumWorldRendererMixin implements SodiumWorldRendererExt {
	@Shadow
	private RenderSectionManager renderSectionManager;

	@Override
	public float[] getAnimationOffset(class_243 pos) {
		class_4076 chunkPos = class_4076.method_18680(pos);
		float[] offset = ((RenderSectionManagerExt) renderSectionManager).getAnimationOffset(
			chunkPos.method_10263(),
			chunkPos.method_10264(),
			chunkPos.method_10260()
		);

		if (Config.isCurvatureEnabled) {
			class_310 client = class_310.method_1551();

			class_1297 camera = client.method_1560();
			if (camera != null) {
				float len = (float) pos.method_1020(camera.method_73189()).method_1033();

				if (offset == null)
					offset = new float[3];
				else
					offset = offset.clone();

				offset[1] -= (len * len) / Config.worldCurvature;
			}
		}

		return offset;
	}

	@Override
	public @Nullable RenderSectionManager getRenderSectionManager() {
		return renderSectionManager;
	}
}
