/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.compat.dh.mixin;

import com.koteinik.chunksfadein.compat.dh.LodMaskTexture;
import com.koteinik.chunksfadein.compat.dh.ext.DhRenderProgramExt;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.FadeShader;
import com.koteinik.chunksfadein.core.ShaderInjector;
import com.koteinik.chunksfadein.core.SkyFBO;
import com.koteinik.chunksfadein.core.Utils;
import com.koteinik.chunksfadein.hooks.CompatibilityHook;
import com.seibel.distanthorizons.api.enums.config.EDhApiMcRenderingFadeMode;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.renderer.DhTerrainShaderProgram;
import com.seibel.distanthorizons.core.util.RenderUtil;
import java.util.function.Supplier;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL30;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DhTerrainShaderProgram.class}, remap=false)
public abstract class DhTerrainShaderProgramMixin
extends ShaderProgram
implements DhRenderProgramExt {
    @Unique
    private int screenSize;
    @Unique
    private int chunkFadeData;
    @Unique
    private int lodMask;
    @Unique
    private int lodMaskDim;
    @Unique
    private int lodMaskMaxDist;
    @Unique
    private int lodMaskOrigin;
    @Unique
    private int lodMaskMinY;
    @Unique
    private int terrainFadeTexture;
    @Unique
    private int dhFadeActive;
    @Unique
    private int dhStartFadeBlockDistanceSq;

    public DhTerrainShaderProgramMixin() {
        super(null, null, null);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void modifyConstructor(CallbackInfo ci) {
        this.screenSize = this.tryGetUniformLocation("cfi_screenSize");
        this.chunkFadeData = this.tryGetUniformLocation("cfi_chunkFadeData");
        this.lodMask = this.tryGetUniformLocation("cfi_lodMask");
        this.lodMaskDim = this.tryGetUniformLocation("cfi_lodMaskDim");
        this.lodMaskMaxDist = this.tryGetUniformLocation("cfi_lodMaskMaxDist");
        this.lodMaskOrigin = this.tryGetUniformLocation("cfi_lodMaskOrigin");
        this.lodMaskMinY = this.tryGetUniformLocation("cfi_lodMaskMinY");
        this.terrainFadeTexture = this.tryGetUniformLocation("cfi_sky");
        this.dhFadeActive = this.tryGetUniformLocation("cfi_dhFadeActive");
        this.dhStartFadeBlockDistanceSq = this.tryGetUniformLocation("cfi_dhStartFadeBlockDistanceSq");
    }

    @Override
    public void bindUniforms(float x, float y, float z, float w) {
        if (this.chunkFadeData != -1) {
            GL30.glUniform4f((int)this.chunkFadeData, (float)x, (float)y, (float)z, (float)w);
        }
    }

    @Inject(method={"bind"}, at={@At(value="TAIL")})
    private void modifyBind(CallbackInfo ci) {
        if (!Config.isModEnabled) {
            return;
        }
        if (this.lodMask != -1) {
            LodMaskTexture.bind(14);
        }
        if (!Config.isFadeEnabled) {
            return;
        }
        if (this.terrainFadeTexture != -1) {
            SkyFBO.bind(15);
        }
    }

    @Inject(method={"fillUniformData"}, at={@At(value="TAIL")})
    private void modifyFillUniformData(DhApiRenderParam renderParameters, CallbackInfo ci) {
        if (!Config.isModEnabled) {
            return;
        }
        if (Config.isFadeEnabled) {
            if (this.screenSize != -1) {
                GL30.glUniform2f((int)this.screenSize, (float)SkyFBO.getWidth(), (float)SkyFBO.getHeight());
            }
            if (this.terrainFadeTexture != -1) {
                GL30.glUniform1i((int)this.terrainFadeTexture, (int)15);
            }
        }
        if (DhTerrainShaderProgramMixin.dhFadeEnabled()) {
            if (this.dhFadeActive != -1) {
                GL30.glUniform1i((int)this.dhFadeActive, (int)1);
            }
            float dhNearClipDistance = RenderUtil.getNearClipPlaneInBlocksForFading((float)0.0f);
            float fadeStartDistance = (dhNearClipDistance += 16.0f) * 1.5f;
            if (this.dhStartFadeBlockDistanceSq != -1) {
                GL30.glUniform1f((int)this.dhStartFadeBlockDistanceSq, (float)(fadeStartDistance * fadeStartDistance));
            }
        } else {
            if (this.dhFadeActive != -1) {
                GL30.glUniform1i((int)this.dhFadeActive, (int)0);
            }
            if (this.dhStartFadeBlockDistanceSq != -1) {
                GL30.glUniform1f((int)this.dhStartFadeBlockDistanceSq, (float)0.0f);
            }
        }
        LodMaskTexture texture = LodMaskTexture.getInstance();
        if (texture != null) {
            if (this.lodMask != -1) {
                GL30.glUniform1i((int)this.lodMask, (int)14);
            }
            if (this.lodMaskDim != -1) {
                GL30.glUniform3f((int)this.lodMaskDim, (float)texture.sizeX, (float)texture.sizeY, (float)texture.sizeZ);
            }
            if (this.lodMaskMaxDist != -1) {
                GL30.glUniform3f((int)this.lodMaskMaxDist, (float)((float)texture.sizeX * 8.0f + 16.0f), (float)((float)texture.sizeY * 8.0f + 16.0f), (float)((float)texture.sizeZ * 8.0f + 16.0f));
            }
            if (this.lodMaskOrigin != -1) {
                Vec3 cameraPos = Utils.cameraPosition();
                GL30.glUniform3f((int)this.lodMaskOrigin, (float)((float)Math.floor(cameraPos.x / 16.0)), (float)((float)Math.floor(cameraPos.y / 16.0)), (float)((float)Math.floor(cameraPos.z / 16.0)));
            }
            if (this.lodMaskMinY != -1) {
                GL30.glUniform1f((int)this.lodMaskMinY, (float)texture.minY);
            }
        }
    }

    @Inject(method={"unbind"}, at={@At(value="TAIL")})
    private void modifyUnbind(CallbackInfo ci) {
        if (!Config.isModEnabled) {
            return;
        }
        GL13.glActiveTexture((int)33984);
        if (Config.isFadeEnabled) {
            GL13.glBindTexture((int)3553, (int)0);
        }
        GL13.glBindTexture((int)32879, (int)0);
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lcom/seibel/distanthorizons/core/render/glObject/shader/ShaderProgram;<init>(Ljava/util/function/Supplier;Ljava/util/function/Supplier;Ljava/lang/String;[Ljava/lang/String;)V"), index=0)
    private static Supplier<String> modifySourceVert(Supplier<String> source) {
        return () -> {
            String sauce = (String)source.get();
            if (!Config.isModEnabled) {
                return sauce;
            }
            return DhTerrainShaderProgramMixin.prepareVertexInjector().get(sauce);
        };
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lcom/seibel/distanthorizons/core/render/glObject/shader/ShaderProgram;<init>(Ljava/util/function/Supplier;Ljava/util/function/Supplier;Ljava/lang/String;[Ljava/lang/String;)V"), index=1)
    private static Supplier<String> modifySourceFrag(Supplier<String> source) {
        return () -> {
            String sauce = (String)source.get();
            if (!Config.isModEnabled) {
                return sauce;
            }
            return DhTerrainShaderProgramMixin.prepareFragmentInjector().get(sauce);
        };
    }

    @Unique
    private static ShaderInjector prepareVertexInjector() {
        ShaderInjector injector = new ShaderInjector();
        FadeShader shader = new FadeShader();
        injector.insertAfterInVars("in vec4 irisExtra;");
        if (Config.isFadeEnabled) {
            injector.insertAfterOutVars("out float cfi_material;");
        }
        injector.insertAfterOutVars(shader.newLine("uniform vec4 cfi_chunkFadeData;").newLine("uniform vec3 cfi_lodMaskOrigin;").vertOutVars().utilFunctions().flushMultiline());
        injector.insertAfterStr("vertexWorldPos = ", shader.newLine("vec4 chunkFadeData = cfi_chunkFadeData;").newLine("vec3 localPos = vec3(vPosition.xyz);").newLine("vec3 offsetPos = floor((vertexWorldPos - mod(localPos, 16.0)) / 16.0) + cfi_lodMaskOrigin;").vertInitOutVars("localPos", "offsetPos").vertInitMod("localPos", "vertexWorldPos", false, "offsetPos", true).newLine("if (irisExtra.x == 12.0 || irisExtra.x == 6.0) { vertexWorldPos.y -= 0.115; }").newLineIf(Config.isFadeEnabled, "cfi_material = irisExtra.x;").flushMultiline());
        return injector;
    }

    @Unique
    private static ShaderInjector prepareFragmentInjector() {
        ShaderInjector injector = new ShaderInjector();
        FadeShader shader = new FadeShader();
        if (Config.isFadeEnabled) {
            injector.replace("#version 150", "#version 330 core");
            injector.replace("out vec4 fragColor;", "layout(location = 0) out vec4 fragColor;", "layout(location = 1) out vec4 cfi_terrainFadeOut;");
        }
        injector.insertAfterInVars(shader.fragInVars().utilFunctions().flushMultiline());
        shader.fragColorMod("fragColor.rgb", false);
        if (Config.isFadeEnabled && CompatibilityHook.isDHSSAOEnabled()) {
            shader.newLine("cfi_terrainFadeOut.a = fade;");
        }
        if (Config.isFadeEnabled) {
            shader.newLine("bool shouldDiscardFrag = false;");
        }
        injector.insertAfterStr("fragColor = vertexColor;", shader.flushMultiline());
        injector.insertAfterInVars("uniform sampler3D cfi_lodMask;", "uniform vec3 cfi_lodMaskDim;", "uniform vec3 cfi_lodMaskMaxDist;", "uniform vec3 cfi_lodMaskOrigin;", "uniform float cfi_lodMaskMinY;", "uniform bool cfi_dhFadeActive;", "uniform float cfi_dhStartFadeBlockDistanceSq;");
        if (Config.isFadeEnabled) {
            injector.insertAfterInVars("in float cfi_material;");
        }
        String whenOccluded = Config.isFadeEnabled ? "if (cfi_material != 12.0) { discard; }" : "discard;";
        shader.dhMaskLod(whenOccluded, "vPos", "vertexWorldPos", true);
        if (Config.isFadeEnabled) {
            shader.newLine("if (fragColor.a < 1.0) {");
            shader.newLine("vec3 destinationColor = texture(cfi_sky, gl_FragCoord.xy / cfi_screenSize).rgb;");
            shader.newLine("cfi_terrainFadeOut.rgb = mix(destinationColor, fragColor.rgb, fragColor.a);");
            shader.newLine("} else {");
            shader.newLine("cfi_terrainFadeOut.rgb = fragColor.rgb;");
            shader.newLine("}");
        }
        injector.appendToFunction("main", shader.flushMultiline());
        injector.replace("viewDist < uClipDistance && uClipDistance > 0.0", "uClipDistance == -13.3");
        injector.replace("if (uDitherDhRendering)", "if (false)");
        return injector;
    }

    private static boolean dhFadeEnabled() {
        return Config.Client.Advanced.Graphics.Quality.vanillaFadeMode.get() != EDhApiMcRenderingFadeMode.NONE;
    }
}

