/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.compat.dh.mixin.iris;

import com.koteinik.chunksfadein.Logger;
import com.koteinik.chunksfadein.ShaderUtils;
import com.koteinik.chunksfadein.compat.dh.LodMaskTexture;
import com.koteinik.chunksfadein.compat.dh.ext.DhRenderProgramExt;
import com.koteinik.chunksfadein.compat.dh.ext.LodRendererExt;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.SkyFBO;
import com.koteinik.chunksfadein.core.Utils;
import com.koteinik.chunksfadein.hooks.CompatibilityHook;
import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiShaderProgram;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.core.render.RenderBufferHandler;
import com.seibel.distanthorizons.core.render.renderer.DhTerrainShaderProgram;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.render.renderer.shaders.SSAOApplyShader;
import com.seibel.distanthorizons.core.render.renderer.shaders.SSAOShader;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.compat.dh.DHCompat;
import net.irisshaders.iris.compat.dh.DHCompatInternal;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LodRenderer.class}, remap=false)
public abstract class IrisLodRendererMixin
implements LodRendererExt {
    @Shadow
    private IDhApiShaderProgram lodRenderProgram;

    @Shadow
    public static int getActiveColorTextureId() {
        return 0;
    }

    @Override
    public DhRenderProgramExt getShader() {
        IDhApiShaderProgram iDhApiShaderProgram = this.lodRenderProgram;
        if (iDhApiShaderProgram instanceof DhRenderProgramExt) {
            DhRenderProgramExt ext = (DhRenderProgramExt)iDhApiShaderProgram;
            return ext;
        }
        return null;
    }

    @Override
    public void rebuildShaders() {
        this.lodRenderProgram.unbind();
        this.lodRenderProgram.free();
        this.lodRenderProgram = new DhTerrainShaderProgram();
        SSAOShader.INSTANCE.free();
        SSAOShader.INSTANCE = new SSAOShader();
        SSAOApplyShader.INSTANCE.free();
        SSAOApplyShader.INSTANCE = new SSAOApplyShader();
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void modifyConstructor(RenderBufferHandler bufferHandler, GenericObjectRenderer genericObjectRenderer, CallbackInfo ci) {
        ShaderUtils.lodRenderer = this;
    }

    @Inject(method={"setupGLStateAndRenderObjects"}, at={@At(value="INVOKE", target="Lcom/seibel/distanthorizons/api/interfaces/override/rendering/IDhApiFramebuffer;bind()V", shift=At.Shift.AFTER)})
    private void modifySetupGLStateAndRenderObjects(IProfilerWrapper profiler, DhApiRenderParam renderEventParam, boolean firstPass, CallbackInfo ci) {
        if (!Config.isModEnabled) {
            return;
        }
        LodMaskTexture.createAndUpdate();
        if (!Config.isFadeEnabled || !CompatibilityHook.isDHSSAOEnabled()) {
            return;
        }
        SkyFBO.bindAttachment(36065);
    }

    @Inject(method={"renderLodPass"}, at={@At(value="INVOKE", target="Lcom/seibel/distanthorizons/api/interfaces/override/rendering/IDhApiShaderProgram;unbind()V", shift=At.Shift.AFTER)})
    private void modifyRenderLodPass(IClientLevelWrapper clientLevelWrapper, DhApiRenderParam renderEventParam, IProfilerWrapper profiler, boolean runningDeferredPass, CallbackInfo ci) {
        if (!(Config.isModEnabled && Config.isFadeEnabled && CompatibilityHook.isDHRenderingEnabled())) {
            return;
        }
        SkyFBO fbo = SkyFBO.getInstance();
        if (fbo == null) {
            return;
        }
        try {
            if (CompatibilityHook.isIrisShaderPackInUse()) {
                DHCompatInternal irisDh = Iris.getPipelineManager().getPipeline().map(WorldRenderingPipeline::getDHCompat).map(DHCompat::getInstance).orElse(null);
                if (irisDh == null) {
                    return;
                }
                fbo.blitFromFramebuffer(irisDh.getSolidFBWrapper().getId(), Utils.mainTargetWidth(), Utils.mainTargetHeight(), false);
            } else {
                fbo.blitFromTexture(IrisLodRendererMixin.getActiveColorTextureId(), Utils.mainTargetWidth(), Utils.mainTargetHeight(), false);
            }
        }
        catch (Exception e) {
            Logger.error("Failed to blit main color texture after DH rendering:", e);
        }
    }
}

