/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.compat.sodium.gui;

import com.koteinik.chunksfadein.ShaderUtils;
import com.koteinik.chunksfadein.config.Config;

public class CFIOptionsStorage {
    private boolean needReload = false;

    public void setBooleanDirty(String key, boolean value) {
        if (Config.getBoolean(key) != value) {
            this.needReload = true;
        }
        Config.setBoolean(key, value);
    }

    public void setIntegerDirty(String key, int value) {
        if (Config.getInteger(key) != value) {
            this.needReload = true;
        }
        Config.setInteger(key, value);
    }

    public <T extends Enum<T>> void setEnumDirty(String key, T value) {
        if (!((Enum)Config.getEnum(key)).equals(value)) {
            this.needReload = true;
        }
        Config.setEnum(key, value);
    }

    public void setDoubleDirty(String key, double value) {
        if (Config.getDouble(key) != value) {
            this.needReload = true;
        }
        Config.setDouble(key, value);
    }

    public void flush() {
        if (this.needReload) {
            ShaderUtils.reloadWorldRenderer();
            this.needReload = false;
        }
        Config.save();
    }
}

