/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.compat.sodium.gui;

import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.compat.sodium.gui.CFIOptionsStorage;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.AnimationCurve;
import com.koteinik.chunksfadein.core.AnimationType;
import com.koteinik.chunksfadein.core.FadeCurve;
import com.koteinik.chunksfadein.core.FadeMixType;
import com.koteinik.chunksfadein.core.FadeType;
import com.koteinik.chunksfadein.core.FogOverrideMode;
import com.koteinik.chunksfadein.core.TranslatableEnum;
import com.koteinik.chunksfadein.crowdin.Translations;
import com.koteinik.chunksfadein.gui.GuiUtils;
import com.koteinik.chunksfadein.gui.SettingsScreen;
import com.koteinik.chunksfadein.hooks.CompatibilityHook;
import com.koteinik.chunksfadein.platform.Services;
import java.util.Arrays;
import net.caffeinemc.mods.sodium.api.config.ConfigEntryPoint;
import net.caffeinemc.mods.sodium.api.config.StorageEventHandler;
import net.caffeinemc.mods.sodium.api.config.option.ControlValueFormatter;
import net.caffeinemc.mods.sodium.api.config.option.OptionImpact;
import net.caffeinemc.mods.sodium.api.config.structure.ConfigBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.PageBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

public class CFISodiumPage
implements ConfigEntryPoint {
    private static final String SODIUM_PAGE_NAME = "settings.chunksfadein.sodium_page_name";
    private final CFIOptionsStorage cfiStorage = new CFIOptionsStorage();
    private final StorageEventHandler handler = this.cfiStorage::flush;

    public void registerConfigLate(ConfigBuilder builder) {
        boolean forceEnableTab = !Services.PLATFORM.isForge() && !CompatibilityHook.isModMenuLoaded;
        builder.registerOwnModOptions().setIcon(Identifier.parse((String)"chunksfadein:icon.png")).addPage((PageBuilder)builder.createOptionPage().setName((Component)Translations.translatable(SODIUM_PAGE_NAME)).addOptionGroup(builder.createOptionGroup().addOption((OptionBuilder)builder.createBooleanOption(Identifier.parse((String)"chunksfadein:mod_enabled")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.mod_enabled")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.mod_enabled")).setBinding(v -> this.cfiStorage.setBooleanDirty("mod-enabled", (boolean)v), () -> Config.isModEnabled).setDefaultValue(Boolean.valueOf(true)).setImpact(OptionImpact.VARIES)).addOption((OptionBuilder)builder.createBooleanOption(Identifier.parse((String)"chunksfadein:update_notifier_enabled")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.update_notifier_enabled")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.update_notifier_enabled")).setBinding(v -> Config.setBoolean("update-notifier-enabled", v), () -> Config.isUpdateNotifierEnabled).setDefaultValue(Boolean.valueOf(true))).addOption((OptionBuilder)builder.createBooleanOption(Identifier.parse((String)"chunksfadein:mod_tab_enabled")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.mod_tab_enabled")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.mod_tab_enabled").append((Component)(forceEnableTab ? Component.literal((String)"\n").append((Component)SettingsScreen.MOD_TAB_TOOLTIP) : Component.empty()))).setEnabled(!forceEnableTab).setBinding(v -> Config.setBoolean("show-mod-tab-in-settings", v), () -> forceEnableTab || Config.showModTabInSettings).setDefaultValue(Boolean.valueOf(true)))).addOptionGroup(builder.createOptionGroup().addOption((OptionBuilder)builder.createBooleanOption(Identifier.parse((String)"chunksfadein:fade_enabled")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.fade_enabled")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.fade_enabled")).setBinding(v -> this.cfiStorage.setBooleanDirty("fade-enabled", (boolean)v), () -> Config.isFadeEnabled).setDefaultValue(Boolean.valueOf(true)).setImpact(OptionImpact.LOW)).addOption((OptionBuilder)builder.createBooleanOption(Identifier.parse((String)"chunksfadein:fade_patch_shaders")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.fade_patch_shaders")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.fade_patch_shaders")).setBinding(v -> this.cfiStorage.setBooleanDirty("fade-patch-shaders", (boolean)v), () -> Config.patchShaderFade).setDefaultValue(Boolean.valueOf(true))).addOption((OptionBuilder)builder.createBooleanOption(Identifier.parse((String)"chunksfadein:fade_near_player")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.fade_near_player")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.fade_near_player")).setBinding(v -> Config.setBoolean("fade-near-player", v), () -> Config.fadeNearPlayer).setDefaultValue(Boolean.valueOf(true))).addOption((OptionBuilder)builder.createEnumOption(Identifier.parse((String)"chunksfadein:fade_type"), FadeType.class).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.fade_type")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.fade_type")).setBinding(v -> this.cfiStorage.setEnumDirty("fade-type", v), () -> Config.fadeType).setDefaultValue((Enum)Config.DEFAULT_FADE_TYPE)).addOption((OptionBuilder)builder.createEnumOption(Identifier.parse((String)"chunksfadein:fade_curve"), FadeCurve.class).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.fade_curve")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.fade_curve")).setBinding(v -> this.cfiStorage.setEnumDirty("fade-curve", v), () -> Config.fadeCurve).setDefaultValue((Enum)Config.DEFAULT_FADE_CURVE)).addOption((OptionBuilder)builder.createEnumOption(Identifier.parse((String)"chunksfadein:fade_mix_type"), FadeMixType.class).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.fade_mix_type")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.fade_mix_type")).setBinding(v -> this.cfiStorage.setEnumDirty("fade-mix-type", v), () -> Config.fadeMixType).setDefaultValue((Enum)Config.DEFAULT_FADE_MIX_TYPE)).addOption((OptionBuilder)builder.createEnumOption(Identifier.parse((String)"chunksfadein:fog_override"), FogOverrideMode.class).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.fog_override")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.fog_override")).setBinding(v -> this.cfiStorage.setEnumDirty("fog-override", v), () -> Config.fogOverrideMode).setDefaultValue((Enum)Config.DEFAULT_FOG_OVERRIDE)).addOption((OptionBuilder)builder.createIntegerOption(Identifier.parse((String)"chunksfadein:fade_time")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.fade_time")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.fade_time")).setRange(MathUtils.roundToInt(1.0), MathUtils.roundToInt(1000.0), 1).setValueFormatter(CFISodiumPage.scaled(100, (Component)SettingsScreen.UNITS_SECONDS)).setBinding(v -> Config.setDouble("fade-time", (double)v.intValue() / 100.0), () -> MathUtils.roundToInt(Config.secondsFromFadeChange() * 100.0f)).setDefaultValue(Integer.valueOf(MathUtils.roundToInt(75.0))))).addOptionGroup(builder.createOptionGroup().addOption((OptionBuilder)builder.createBooleanOption(Identifier.parse((String)"chunksfadein:animation_enabled")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.animation_enabled")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animation_enabled")).setBinding(v -> this.cfiStorage.setBooleanDirty("animation-enabled", (boolean)v), () -> Config.isAnimationEnabled).setDefaultValue(Boolean.valueOf(false)).setImpact(OptionImpact.LOW)).addOption((OptionBuilder)builder.createBooleanOption(Identifier.parse((String)"chunksfadein:animation_patch_shaders")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.animation_patch_shaders")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animation_patch_shaders")).setBinding(v -> this.cfiStorage.setBooleanDirty("animation-patch-shaders", (boolean)v), () -> Config.patchShaderAnimation).setDefaultValue(Boolean.valueOf(true))).addOption((OptionBuilder)builder.createBooleanOption(Identifier.parse((String)"chunksfadein:animate_near_player")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.animate_near_player")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animate_near_player")).setBinding(v -> Config.setBoolean("animate-near-player", v), () -> Config.animateNearPlayer).setDefaultValue(Boolean.valueOf(true))).addOption((OptionBuilder)builder.createBooleanOption(Identifier.parse((String)"chunksfadein:animate_with_dh")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.animate_with_dh")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animate_with_dh")).setBinding(v -> Config.setBoolean("fade-with-dh", v), () -> Config.animateWithDH).setDefaultValue(Boolean.valueOf(false))).addOption((OptionBuilder)builder.createEnumOption(Identifier.parse((String)"chunksfadein:animation_curve"), AnimationCurve.class).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.animation_curve")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animation_curve")).setBinding(v -> this.cfiStorage.setEnumDirty("animation-curve", v), () -> Config.animationCurve).setDefaultValue((Enum)Config.DEFAULT_ANIMATION_CURVE)).addOption((OptionBuilder)builder.createEnumOption(Identifier.parse((String)"chunksfadein:animation_type"), AnimationType.class).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.animation_type")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animation_type")).setBinding(v -> this.cfiStorage.setEnumDirty("animation-type", v), () -> Config.animationType).setDefaultValue((Enum)Config.DEFAULT_ANIMATION_TYPE)).addOption((OptionBuilder)builder.createIntegerOption(Identifier.parse((String)"chunksfadein:animation_time")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.animation_time")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animation_time")).setRange(MathUtils.roundToInt(1.0), MathUtils.roundToInt(1000.0), 1).setValueFormatter(CFISodiumPage.scaled(100, (Component)SettingsScreen.UNITS_SECONDS)).setBinding(v -> Config.setDouble("animation-time", (double)v.intValue() / 100.0), () -> MathUtils.roundToInt(Config.secondsFromAnimationChange() * 100.0)).setDefaultValue(Integer.valueOf(MathUtils.roundToInt(256.0)))).addOption((OptionBuilder)builder.createIntegerOption(Identifier.parse((String)"chunksfadein:animation_offset")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.animation_start")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animation_start")).setRange(MathUtils.roundToInt(-12800.0), MathUtils.roundToInt(12800.0), 1).setValueFormatter(CFISodiumPage.scaled(100, (Component)SettingsScreen.UNITS_BLOCKS)).setBinding(v -> Config.setDouble("animation-offset", (double)v.intValue() / 100.0), () -> MathUtils.roundToInt(Config.animationOffset * 100.0f)).setDefaultValue(Integer.valueOf(MathUtils.roundToInt(-6400.0)))).addOption((OptionBuilder)builder.createIntegerOption(Identifier.parse((String)"chunksfadein:animation_angle")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.animation_angle")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animation_angle")).setRange(MathUtils.roundToInt(0.0), MathUtils.roundToInt(90.0), 1).setValueFormatter(CFISodiumPage.number((Component)SettingsScreen.UNITS_DEGREES)).setBinding(v -> Config.setDouble("animation-angle", (double)v), () -> MathUtils.roundToInt(Config.animationAngle)).setDefaultValue(Integer.valueOf(MathUtils.roundToInt(0.0)))).addOption((OptionBuilder)builder.createIntegerOption(Identifier.parse((String)"chunksfadein:animation_factor")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.animation_factor")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.animation_factor")).setRange(MathUtils.roundToInt(1.0), MathUtils.roundToInt(100.0), 1).setValueFormatter(CFISodiumPage.scaled(100)).setBinding(v -> Config.setDouble("animation-factor", (double)v.intValue() / 100.0), () -> MathUtils.roundToInt(Config.animationFactor * 100.0f)).setDefaultValue(Integer.valueOf(MathUtils.roundToInt(100.0))))).addOptionGroup(builder.createOptionGroup().addOption((OptionBuilder)builder.createBooleanOption(Identifier.parse((String)"chunksfadein:curvature_enabled")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.world_curvature_enabled")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.world_curvature_enabled")).setBinding(v -> this.cfiStorage.setBooleanDirty("world-curvature-enabled", (boolean)v), () -> Config.isCurvatureEnabled).setDefaultValue(Boolean.valueOf(false)).setImpact(OptionImpact.LOW)).addOption((OptionBuilder)builder.createBooleanOption(Identifier.parse((String)"chunksfadein:curvature_patch_shaders")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.world_curvature_patch_shaders")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.world_curvature_patch_shaders")).setBinding(v -> this.cfiStorage.setBooleanDirty("world-curvature-patch-shaders", (boolean)v), () -> Config.patchShaderCurvature).setDefaultValue(Boolean.valueOf(true))).addOption((OptionBuilder)builder.createIntegerOption(Identifier.parse((String)"chunksfadein:curvature")).setStorageHandler(this.handler).setName((Component)Translations.translatable("settings.chunksfadein.world_curvature")).setTooltip((Component)GuiUtils.tooltip("settings.chunksfadein.world_curvature")).setRange(0, 15, 1).setValueFormatter(v -> Component.literal((String)String.valueOf(SettingsScreen.CURVATURE_VALUES[v]))).setBinding(v -> this.cfiStorage.setIntegerDirty("world-curvature", SettingsScreen.CURVATURE_VALUES[v]), () -> SettingsScreen.curvatureValueIdx(Config.worldCurvature)).setDefaultValue(Integer.valueOf(SettingsScreen.curvatureValueIdx(16384))))));
    }

    private static ControlValueFormatter scaled(int scale) {
        return CFISodiumPage.scaled(scale, (Component)Component.empty());
    }

    private static ControlValueFormatter scaled(int scale, Component units) {
        return v -> Component.literal((String)String.valueOf((double)v / (double)scale)).append(units);
    }

    private static ControlValueFormatter number(Component units) {
        return v -> Component.literal((String)String.valueOf(v)).append(units);
    }

    private static <T extends Enum<T>> Component[] translations(Class<T> clazz) {
        return (Component[])Arrays.stream((Enum[])clazz.getEnumConstants()).map(rec$ -> ((TranslatableEnum)rec$).getTranslation()).toArray(Component[]::new);
    }
}

