/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.compat.sodium.mixin;

import com.koteinik.chunksfadein.compat.sodium.ext.RenderSectionManagerExt;
import com.koteinik.chunksfadein.compat.sodium.ext.SodiumWorldRendererExt;
import com.koteinik.chunksfadein.config.Config;
import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionManager;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={SodiumWorldRenderer.class}, remap=false)
public class SodiumWorldRendererMixin
implements SodiumWorldRendererExt {
    @Shadow
    private RenderSectionManager renderSectionManager;

    @Override
    public float[] getAnimationOffset(Vec3 pos) {
        Minecraft client;
        Entity camera;
        SectionPos chunkPos = SectionPos.of((Position)pos);
        float[] offset = ((RenderSectionManagerExt)this.renderSectionManager).getAnimationOffset(chunkPos.getX(), chunkPos.getY(), chunkPos.getZ());
        if (Config.isCurvatureEnabled && (camera = (client = Minecraft.getInstance()).getCameraEntity()) != null) {
            float len = (float)pos.subtract(camera.position()).length();
            offset = offset == null ? new float[3] : (float[])offset.clone();
            offset[1] = offset[1] - len * len / (float)Config.worldCurvature;
        }
        return offset;
    }

    @Override
    @Nullable
    public RenderSectionManager getRenderSectionManager() {
        return this.renderSectionManager;
    }
}

