/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.config;

import com.koteinik.chunksfadein.Logger;
import com.koteinik.chunksfadein.config.ConfigEntry;
import com.moandjiezana.toml.Toml;
import java.util.Arrays;

public class ConfigEntryEnum<T extends Enum<T>>
extends ConfigEntry<T> {
    private final Class<T> enumType;

    public ConfigEntryEnum(Class<T> enumType, T defaultValue, String description, String configKey) {
        super(defaultValue, configKey, description, ConfigEntry.Type.STRING);
        this.enumType = enumType;
    }

    @Override
    public void load(Toml toml) {
        Enum tomlValue;
        block8: {
            tomlValue = null;
            try {
                String value = (String)this.type.get(toml, this.configKey);
                if (value != null) {
                    try {
                        tomlValue = (Enum)Enum.valueOf(this.enumType, value.toUpperCase());
                    }
                    catch (Exception e) {
                        Logger.warn("Unknown enum value '%s', expected one of: %s".formatted(value, Arrays.toString(this.enumType.getEnumConstants())));
                    }
                }
            }
            catch (ClassCastException e) {
                Integer value = (Integer)ConfigEntry.Type.INTEGER.get(toml, this.configKey);
                if (value == null) break block8;
                try {
                    tomlValue = ((Enum[])this.enumType.getEnumConstants())[value];
                }
                catch (Exception e1) {
                    Logger.warn("Unknown enum value '%s', expected one of: %s".formatted(value, Arrays.toString(this.enumType.getEnumConstants())));
                }
            }
        }
        if (tomlValue == null) {
            tomlValue = (Enum)this.defaultValue;
        }
        this.value = tomlValue;
        this.pollListeners();
    }

    @Override
    public String toString() {
        return "# %s\n#\n".formatted(this.description.replace("\n", "\n# ")) + "# Default: %s\n".formatted(((Enum)this.defaultValue).name().toLowerCase()) + "# Possible: %s\n".formatted(Arrays.toString(this.enumType.getEnumConstants()).toLowerCase()) + "%s = %s\n".formatted(this.configKey, this.type.makeString(this.value).toLowerCase());
    }
}

