/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.gui.components;

import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.TranslatableEnum;
import com.koteinik.chunksfadein.gui.GuiUtils;
import com.koteinik.chunksfadein.gui.SettingsScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CFIButton
extends Button.Plain {
    private final Supplier<Component> createText;

    public CFIButton(int x, int y, int width, int height, Supplier<Component> createText, Runnable onPress, boolean active, Component tooltip) {
        super(x, y, width, height, createText.get(), btn -> {
            onPress.run();
            ((CFIButton)btn).updateText();
        }, DEFAULT_NARRATION);
        this.active = active;
        this.createText = createText;
        if (tooltip != null) {
            this.setTooltip(Tooltip.create((Component)tooltip));
        }
    }

    public void updateText() {
        this.setMessage(this.createText.get());
    }

    public static class CFIButtonBuilder {
        private int x = 0;
        private int y = 0;
        private int width = 180;
        private int height = 20;
        private Supplier<Component> createText = () -> Component.empty();
        private List<Runnable> onPress = new ArrayList<Runnable>();
        private boolean active = true;
        private MutableComponent tooltip = null;

        public CFIButtonBuilder x(int x) {
            this.x = x;
            return this;
        }

        public CFIButtonBuilder y(int y) {
            this.y = y;
            return this;
        }

        public CFIButtonBuilder width(int width) {
            this.width = width;
            return this;
        }

        public CFIButtonBuilder height(int height) {
            this.height = height;
            return this;
        }

        public CFIButtonBuilder text(Component component) {
            return this.text(() -> component);
        }

        public CFIButtonBuilder text(Supplier<Component> createText) {
            this.createText = createText;
            return this;
        }

        public CFIButtonBuilder onPress(Runnable onPress) {
            this.onPress.add(onPress);
            return this;
        }

        public CFIButtonBuilder tooltip(MutableComponent tooltip) {
            if (this.tooltip == null) {
                this.tooltip = tooltip;
            } else {
                this.tooltip.append("\n").append((Component)tooltip);
            }
            return this;
        }

        public CFIButtonBuilder active(boolean active) {
            this.active = active;
            return this;
        }

        public CFIButtonBuilder applyIf(boolean value, Consumer<CFIButtonBuilder> action) {
            if (value) {
                action.accept(this);
            }
            return this;
        }

        public CFIButton build() {
            return new CFIButton(this.x, this.y, this.width, this.height, this.createText, () -> this.onPress.forEach(Runnable::run), this.active, (Component)this.tooltip);
        }

        public static <T extends Enum<T>> CFIButtonBuilder cycle(String textKey, String configKey, Class<T> clazz) {
            Enum[] constants = (Enum[])clazz.getEnumConstants();
            return new CFIButtonBuilder().text(() -> CFIButtonBuilder.coloredFormatted(textKey, "\u00a7e", ((TranslatableEnum)Config.getEnum(configKey)).getTranslation())).onPress(() -> {
                int next = ((Enum)Config.getEnum(configKey)).ordinal() + 1;
                if (next >= constants.length) {
                    next = 0;
                }
                Config.setEnum(configKey, constants[next]);
            }).tooltip(GuiUtils.tooltip(textKey));
        }

        public static CFIButtonBuilder toggle(String textKey, String configKey) {
            return CFIButtonBuilder.binaryToggle(textKey, configKey, (Component)SettingsScreen.ON, (Component)SettingsScreen.OFF);
        }

        public static CFIButtonBuilder choice(String textKey, String configKey) {
            return CFIButtonBuilder.binaryToggle(textKey, configKey, (Component)SettingsScreen.YES, (Component)SettingsScreen.NO);
        }

        private static CFIButtonBuilder binaryToggle(String textKey, String configKey, Component on, Component off) {
            return new CFIButtonBuilder().text(() -> {
                boolean value = Config.getBoolean(configKey);
                return CFIButtonBuilder.coloredFormatted(textKey, CFIButtonBuilder.color(value), value ? on : off);
            }).onPress(() -> Config.flipBoolean(configKey)).tooltip(GuiUtils.tooltip(textKey));
        }

        private static Component coloredFormatted(String key, String color, Component arg) {
            return GuiUtils.text(key, color + arg.getString());
        }

        private static String color(boolean value) {
            return value ? "\u00a72" : "\u00a7c";
        }
    }
}

