/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.compat.dh;

import com.koteinik.chunksfadein.core.Fader;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import org.joml.Vector2i;

public class DHState {
    public static final ThreadLocal<Long> sectionPosForCreatingBuffer = new ThreadLocal();
    private static final Map<Byte, Map<Vector2i, Fader>> faders = new ConcurrentHashMap<Byte, Map<Vector2i, Fader>>();
    private static int lastLevel = 0;

    public static synchronized Fader getFader(long pos) {
        Vector2i blockPos;
        Map<Vector2i, Fader> faders;
        Fader fader;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && lastLevel != level.hashCode()) {
            lastLevel = level.hashCode();
            DHState.faders.clear();
        }
        if ((fader = (faders = DHState.fadersAtLevel(DHState.detailLevel(pos))).get(blockPos = DHState.blockPos(pos))) != null) {
            return fader;
        }
        fader = new Fader((int)Math.floor((double)blockPos.x / 16.0), (int)Math.floor((double)blockPos.y / 16.0));
        DHState.populateDescendantFaders(pos, fader);
        return fader;
    }

    private static void populateDescendantFaders(long pos, Fader fader) {
        DHState.fadersAtLevel(DHState.detailLevel(pos)).put(DHState.blockPos(pos), fader);
        if (DHState.detailLevel(pos) > 0) {
            for (int i = 0; i < 4; ++i) {
                DHState.populateDescendantFaders(DhSectionPos.getChildByIndex((long)pos, (int)i), fader);
            }
        }
    }

    private static Map<Vector2i, Fader> fadersAtLevel(byte level) {
        return faders.computeIfAbsent(level, k -> new ConcurrentHashMap());
    }

    private static byte detailLevel(long pos) {
        return DhSectionPos.getDetailLevel((long)pos);
    }

    private static Vector2i blockPos(long pos) {
        return new Vector2i(DhSectionPos.getMinCornerBlockX((long)pos), DhSectionPos.getMinCornerBlockZ((long)pos));
    }
}

