/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.compat.monocle;

import com.koteinik.chunksfadein.compat.iris.IrisPatcher;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.Version;
import io.github.douira.glsl_transformer.ast.node.abstract_node.ASTNode;
import io.github.douira.glsl_transformer.ast.print.ASTPrinter;
import io.github.douira.glsl_transformer.ast.print.PrintType;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.RootSupplier;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import io.github.douira.glsl_transformer.ast.transform.ASTTransformer;
import io.github.douira.glsl_transformer.ast.transform.JobParameters;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.irisshaders.iris.pipeline.transform.PatchShaderType;

public class MonoclePatcher {
    private static final Pattern versionPattern = Pattern.compile("#version\\s+(\\d+)", 32);
    private static final ASTTransformer<Parameters, String> transformer = new ASTTransformer<Parameters, String>(){
        {
            this.setRootSupplier(RootSupplier.PREFIX_UNORDERED_ED_EXACT);
        }

        public TranslationUnit parseTranslationUnit(Root rootInstance, String input) {
            Matcher matcher = versionPattern.matcher(input);
            if (matcher.find()) {
                MonoclePatcher.transformer.getLexer().version = Version.fromNumber((int)Integer.parseInt(matcher.group(1)));
            }
            return super.parseTranslationUnit(rootInstance, input);
        }

        public String transform(RootSupplier rootSupplier, String input) {
            TranslationUnit tree = this.parseTranslationUnit(rootSupplier, input);
            Root root = tree.getRoot();
            root.indexBuildSession(() -> MonoclePatcher.patch(transformer, tree, root, (Parameters)this.getJobParameters()));
            return ASTPrinter.print((PrintType)this.getPrintType(), (ASTNode)tree);
        }
    };

    public static String patch(PatchShaderType type, String source) {
        transformer.setJobParameters((JobParameters)new Parameters(type));
        return (String)transformer.transform((Object)source);
    }

    private static void patch(ASTParser t, TranslationUnit tree, Root root, Parameters parameters) {
        IrisPatcher.injectModAndAPI(t, tree, root, parameters.type.glShaderType);
    }

    private record Parameters(PatchShaderType type) implements JobParameters
    {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Parameters) {
                Parameters other = (Parameters)obj;
                return this.type == other.type;
            }
            return false;
        }
    }
}

