/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.compat.sodium.mixin.ext;

import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.compat.dh.LodMaskTexture;
import com.koteinik.chunksfadein.compat.sodium.ext.RenderSectionExt;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.DataBuffer;
import com.koteinik.chunksfadein.core.Fader;
import com.koteinik.chunksfadein.core.Utils;
import com.koteinik.chunksfadein.hooks.CompatibilityHook;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderSection.class}, remap=false)
public class RenderSectionMixin
implements RenderSectionExt {
    @Shadow
    @Final
    private int chunkX;
    @Shadow
    @Final
    private int chunkY;
    @Shadow
    @Final
    private int chunkZ;
    private Fader fader;
    private boolean completedFade = false;
    private boolean completedAnimation = false;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void modifyInit(RenderRegion region, int chunkX, int chunkY, int chunkZ, CallbackInfo ci) {
        this.fader = new Fader(chunkX, chunkZ);
    }

    @Override
    public boolean hasRenderedBefore() {
        return this.fader.hasRenderedBefore();
    }

    @Override
    public void setRenderedBefore() {
        this.fader.setRenderedBefore();
    }

    @Override
    public void dhMarkRendered() {
        if (this.completedFade) {
            LodMaskTexture.markRendered(this.chunkX, this.chunkY, this.chunkZ);
        }
    }

    @Override
    public boolean incrementFadeCoeff(long delta, int sectionIndex, DataBuffer buffer) {
        if (this.completedFade) {
            return false;
        }
        float fadeCoeff = this.fader.incrementFadeCoeff(delta, this.isNearPlayer());
        buffer.put(sectionIndex, 3, fadeCoeff);
        this.completedFade |= fadeCoeff == 1.0f;
        return true;
    }

    @Override
    public boolean incrementAnimationOffset(long delta, int sectionIndex, DataBuffer buffer) {
        if (this.completedAnimation) {
            return false;
        }
        if (!Config.animateWithDH && CompatibilityHook.isDHRenderingEnabled()) {
            this.completedAnimation = true;
            return true;
        }
        float[] offset = this.fader.incrementAnimationOffset(delta, this.isNearPlayer());
        for (int i = 0; i < 3; ++i) {
            buffer.put(sectionIndex, i, offset[i]);
        }
        this.completedAnimation |= offset[0] == 0.0f && offset[1] == 0.0f && offset[2] == 0.0f;
        return true;
    }

    @Override
    public long calculateAndGetDelta() {
        return this.fader.calculateAndGetDelta();
    }

    @Override
    public float[] getAnimationOffset() {
        return this.fader.getAnimationOffset();
    }

    @Override
    public float getFadeCoeff() {
        return this.fader.getFadeCoeff();
    }

    private boolean isNearPlayer() {
        SectionPos chunkPos = SectionPos.of((Position)Utils.cameraPosition());
        int camChunkX = chunkPos.getX();
        int camChunkZ = chunkPos.getZ();
        return MathUtils.chunkInRange(this.chunkX, this.chunkZ, camChunkX, camChunkZ, 1);
    }
}

