/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.crowdin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.koteinik.chunksfadein.crowdin.TranslationsDownloader;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import org.jetbrains.annotations.NotNull;

public class Translations {
    private static Map<String, String> enUs;
    private static volatile Map<String, Map<String, String>> translations;

    static void addTranslations(Map<String, Map<String, String>> newTranslations) {
        translations.putAll(newTranslations);
    }

    public static MutableComponent translatable(final String key) {
        return MutableComponent.create((ComponentContents)new ComponentContents(){

            @NotNull
            public ComponentContents.Type<?> type() {
                return PlainTextContents.TYPE;
            }

            @NotNull
            public <T> Optional<T> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull FormattedText.ContentConsumer<T> consumer) {
                return consumer.accept(Translations.resolve(key));
            }

            @NotNull
            public <T> Optional<T> visit(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull FormattedText.StyledContentConsumer<T> consumer, @NotNull Style style) {
                return consumer.accept(style, Translations.resolve(key));
            }
        });
    }

    public static synchronized String resolve(String key) {
        String value;
        String language = Minecraft.getInstance().options.languageCode;
        Map<String, String> map = translations.get(language);
        if (map != null && (value = map.get(key)) != null) {
            return value;
        }
        return Translations.getDefault(key);
    }

    public static String getDefault(String key) {
        String value = enUs.get(key);
        if (value == null) {
            return "null";
        }
        return value;
    }

    public static void download() {
        new TranslationsDownloader().start();
    }

    static Map<String, String> parseJsonTranslations(String json) {
        JsonObject jsonPairs = JsonParser.parseString((String)json).getAsJsonObject();
        return jsonPairs.asMap().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), ((JsonElement)e.getValue()).getAsString())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    static {
        translations = new ConcurrentHashMap<String, Map<String, String>>();
        try (InputStream inputStream = Translations.class.getClassLoader().getResourceAsStream("assets/chunksfadein/lang/en_us.json");){
            BufferedInputStream bis = new BufferedInputStream(Objects.requireNonNull(inputStream));
            enUs = Translations.parseJsonTranslations(new String(bis.readAllBytes()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

