/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.compat.mc.mixin;

import com.koteinik.chunksfadein.compat.sodium.ext.RenderRegionExt;
import com.koteinik.chunksfadein.compat.sodium.ext.RenderSectionExt;
import com.koteinik.chunksfadein.compat.sodium.ext.SodiumWorldRendererExt;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.SkyFBO;
import com.koteinik.chunksfadein.core.Utils;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.framegraph.FrameGraphBuilder;
import com.mojang.blaze3d.framegraph.FramePass;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.vertex.PoseStack;
import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionManager;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.util.iterator.ByteIterator;
import net.caffeinemc.mods.sodium.client.world.LevelRendererExtension;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LevelTargetBundle;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.state.LevelRenderState;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Shadow
    @Final
    private LevelTargetBundle targets;

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;addMainPass(Lcom/mojang/blaze3d/framegraph/FrameGraphBuilder;Lnet/minecraft/client/renderer/culling/Frustum;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;ZLnet/minecraft/client/renderer/state/LevelRenderState;Lnet/minecraft/client/DeltaTracker;Lnet/minecraft/util/profiling/ProfilerFiller;)V")})
    private void modifyRenderLevel(GraphicsResourceAllocator graphicsResourceAllocator, DeltaTracker deltaTracker, boolean bl, Camera camera, Matrix4f matrix4f, Matrix4f matrix4f2, Matrix4f matrix4f3, GpuBufferSlice gpuBufferSlice, Vector4f vector4f, boolean bl2, CallbackInfo ci, @Local FrameGraphBuilder frameGraphBuilder) {
        SodiumWorldRenderer sodiumWorld;
        SodiumWorldRendererExt ext;
        RenderSectionManager manager;
        if (!Config.isModEnabled || !Config.isFadeEnabled && !Config.isAnimationEnabled) {
            return;
        }
        if (Config.isFadeEnabled) {
            FramePass framePass = frameGraphBuilder.addPass("cfi_blit_sky");
            this.targets.main = framePass.readsAndWrites(this.targets.main);
            framePass.executes(() -> {
                SkyFBO fbo = SkyFBO.getInstance();
                if (fbo != null) {
                    fbo.blitFromTexture(Utils.mainColorTexture(), Utils.mainTargetWidth(), Utils.mainTargetHeight(), true);
                }
            });
        }
        if ((manager = (ext = (SodiumWorldRendererExt)(sodiumWorld = ((LevelRendererExtension)this).sodium$getWorldRenderer())).getRenderSectionManager()) == null) {
            return;
        }
        for (ChunkRenderList renderList : manager.getRenderLists()) {
            ByteIterator geometrySections = renderList.sectionsWithGeometryIterator(false);
            if (geometrySections == null) continue;
            while (geometrySections.hasNext()) {
                LevelRendererMixin.processChunk(renderList.getRegion(), geometrySections.nextByteAsInt());
            }
        }
    }

    @Inject(method={"submitBlockEntities"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V", shift=At.Shift.AFTER)})
    private void modifySubmitBlockEntities(PoseStack matrices, LevelRenderState levelRenderState, SubmitNodeStorage submitNodeStorage, CallbackInfo ci, @Local BlockEntityRenderState state) {
        if (!Config.isModEnabled || !Config.isAnimationEnabled && !Config.isCurvatureEnabled) {
            return;
        }
        SodiumWorldRendererExt ext = (SodiumWorldRendererExt)SodiumWorldRenderer.instance();
        if (ext.getRenderSectionManager() == null) {
            return;
        }
        float[] offset = ext.getAnimationOffset(state.blockPos.getCenter());
        matrices.translate(offset[0], offset[1], offset[2]);
    }

    private static void processChunk(RenderRegion region, int sectionIndex) {
        RenderSection section = region.getSection(sectionIndex);
        if (section == null) {
            return;
        }
        RenderRegionExt regionExt = (RenderRegionExt)region;
        regionExt.processChunk((RenderSectionExt)section, sectionIndex);
    }
}

