/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.gui.components;

import com.koteinik.chunksfadein.gui.components.CFIListWidget;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;

public class CFIWidgetsEntry
extends ContainerObjectSelectionList.Entry<CFIWidgetsEntry> {
    private static final int SPACING_X = 4;
    private static final int BUTTON_W = 180;
    private final List<AbstractWidget> widgets;
    private final Screen parent;
    private final CFIListWidget listWidget;
    private final int y;

    public CFIWidgetsEntry(List<AbstractWidget> widgets, Screen parent, CFIListWidget listWidget, int y) {
        this.widgets = widgets;
        this.parent = parent;
        this.listWidget = listWidget;
        this.y = y;
    }

    public List<? extends GuiEventListener> children() {
        return this.widgets;
    }

    public List<? extends NarratableEntry> narratables() {
        return this.widgets;
    }

    public void renderContent(GuiGraphics context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        for (int i = 0; i < this.widgets.size(); ++i) {
            AbstractWidget widget = this.widgets.get(i);
            int gridX = i;
            if (this.widgets.size() > 1 && i == 0) {
                gridX = -1;
            }
            widget.setPosition(this.calculateX(gridX), this.y - (int)this.listWidget.scrollAmount());
            widget.render(context, mouseX, mouseY, tickDelta);
        }
    }

    private int calculateX(int column) {
        int halfScreen = this.parent.width / 2;
        return column == 0 ? halfScreen - 90 : halfScreen + 180 * (column - (column < 0 ? 0 : 1)) + 4 * column;
    }
}

