/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.AnimationType;
import com.koteinik.chunksfadein.core.FadeType;
import java.util.ArrayList;
import java.util.List;

public class FadeShader {
    private List<String> lines = new ArrayList<String>();

    public FadeShader dummyApiFragApplyFogFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_applyFogFade(vec3 fullyFaded) { return vec3(0.0); }");
    }

    public FadeShader apiFragApplyFogFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_applyFogFade(vec3 fullyFaded) {");
        if (Config.isFadeEnabled) {
            this.newLine("return cfi_applyFade(iris_FogColor.rgb, fullyFaded);");
        } else {
            this.newLine("return fullyFaded;");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiFragApplyFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_applyFade(vec3 fullyUnfaded, vec3 fullyFaded) { return vec3(0.0); }");
    }

    public FadeShader apiFragApplyFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_applyFade(vec3 fullyUnfaded, vec3 fullyFaded) {");
        if (Config.isFadeEnabled) {
            this.newLine("return mix(fullyUnfaded, fullyFaded, cfi_calculateFade());");
        } else {
            this.newLine("return fullyFaded;");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiFragCalculateFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("float cfi_calculateFade() { return 0.0; }");
    }

    public FadeShader apiFragCalculateFade() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("float cfi_calculateFade() {");
        if (Config.isFadeEnabled) {
            this.newLine("float fade = 0.0;");
            this.calculateFade("fade = ");
            this.newLine("return fade;");
        } else {
            this.newLine("return 1.0;");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiVertCalculateCurvature2() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_calculateCurvature() { return vec3(0.0); }");
    }

    public FadeShader apiVertCalculateCurvature2() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_calculateCurvature() {");
        this.newLine("return cfi_calculateCurvature(getVertexPosition().xyz);");
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiVertCalculateCurvature() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_calculateCurvature(vec3 globalPos) { return vec3(0.0); }");
    }

    public FadeShader apiVertCalculateCurvature() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_calculateCurvature(vec3 globalPos) {");
        if (Config.isCurvatureEnabled) {
            this.newLine("return vec3(0.0, -dot(globalPos, globalPos) / " + Config.worldCurvature + ", 0.0);");
        } else {
            this.newLine("return vec3(0.0);");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiVertCalculateDisplacement2() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_calculateDisplacement() { return vec3(0.0); }");
    }

    public FadeShader apiVertCalculateDisplacement2() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_calculateDisplacement() {");
        this.newLine("return cfi_calculateDisplacement(_vert_position);");
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiVertCalculateDisplacement() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec3 cfi_calculateDisplacement(vec3 localPos) { return vec3(0.0); }");
    }

    public FadeShader apiVertCalculateDisplacement() {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec3 cfi_calculateDisplacement(vec3 localPos) {");
        if (Config.isAnimationEnabled) {
            this.newLine("vec3 originalPos = localPos;");
            this.newLine("localPos = vec3(localPos);");
            this.newLine("vec4 chunkFadeData = cfi_getFadeData();");
            if (Config.animationType == AnimationType.JAGGED || Config.animationType == AnimationType.DISPLACEMENT) {
                this.rand("rand", "localPos + vec3(_draw_id)");
            }
            this.calculateVertexDisplacement("localPos", null, true, "_draw_id");
            this.newLine("return localPos - originalPos;");
        } else {
            this.newLine("return vec3(0.0);");
        }
        this.newLine("}");
        return this;
    }

    public FadeShader dummyApiVertGetFadeData() {
        if (!Config.isModEnabled) {
            return this;
        }
        return this.newLine("vec4 cfi_getFadeData() { return vec4(0.0); }");
    }

    public FadeShader apiVertGetFadeData(String drawId) {
        if (!Config.isModEnabled) {
            return this;
        }
        this.newLine("vec4 cfi_getFadeData() {");
        this.newLine("return cfi_ChunkFadeDatas[%s].fadeData;".formatted(drawId));
        this.newLine("}");
        return this;
    }

    public FadeShader vertInVars() {
        this.newLine("struct cfi_ChunkFadeData { vec4 fadeData; };");
        this.newLine("layout(std140) uniform cfi_ubo_ChunkFadeDatas { cfi_ChunkFadeData cfi_ChunkFadeDatas[256]; };");
        return this;
    }

    public FadeShader vertOutVars() {
        if (!Config.isModEnabled || !Config.isFadeEnabled) {
            return this;
        }
        this.newLine("flat out float cfi_FadeFactor;");
        if (Config.fadeType == FadeType.BLOCK) {
            this.newLine("out vec3 cfi_BlockSeed;");
        }
        if (Config.fadeType == FadeType.LINED) {
            this.newLine("out float cfi_RefFactor;");
        }
        if (Config.fadeType == FadeType.VERTEX) {
            this.newLine("flat out float cfi_RefFactor;");
        }
        return this;
    }

    public FadeShader fragInVars() {
        if (!Config.isModEnabled || !Config.isFadeEnabled) {
            return this;
        }
        this.newLine("flat in float cfi_FadeFactor;");
        if (Config.fadeType == FadeType.BLOCK) {
            this.newLine("in vec3 cfi_BlockSeed;");
        }
        if (Config.fadeType == FadeType.LINED) {
            this.newLine("in float cfi_RefFactor;");
        }
        if (Config.fadeType == FadeType.VERTEX) {
            this.newLine("flat in float cfi_RefFactor;");
        }
        return this;
    }

    public FadeShader vertInitOutVars(String localPos, String drawId) {
        if (!Config.isModEnabled) {
            return this;
        }
        if (Config.isAnimationEnabled || Config.isFadeEnabled) {
            this.newLine("vec4 chunkFadeData = cfi_ChunkFadeDatas[%s].fadeData;".formatted(drawId));
            if (Config.animationType == AnimationType.JAGGED || Config.animationType == AnimationType.DISPLACEMENT || Config.fadeType == FadeType.VERTEX) {
                this.rand("rand", "%s + vec3(%s)".formatted(localPos, drawId));
            }
        }
        if (Config.isFadeEnabled) {
            this.newLine("cfi_FadeFactor = chunkFadeData.w;");
            if (Config.fadeType == FadeType.BLOCK) {
                this.newLine("cfi_BlockSeed = %s + vec3(%s);".formatted(localPos, drawId));
            }
            if (Config.fadeType == FadeType.VERTEX) {
                this.newLine("cfi_RefFactor = cfi_FadeFactor > rand ? 1.0 : cfi_FadeFactor / rand;");
            }
            if (Config.fadeType == FadeType.LINED) {
                this.newLine("cfi_RefFactor = %s.y / 16.0;".formatted(localPos));
            }
        }
        return this;
    }

    public FadeShader vertInitMod(String localPos, String position, boolean modifyLocal, String drawId, boolean addCurvature) {
        if (!Config.isModEnabled) {
            return this;
        }
        if (Config.isAnimationEnabled) {
            this.calculateVertexDisplacement(localPos, position, modifyLocal, drawId);
        }
        if (addCurvature && Config.isCurvatureEnabled) {
            this.newLine("%s.y -= dot(%s, %s) / %s;".formatted(modifyLocal ? localPos : position, position, position, Config.worldCurvature));
        }
        return this;
    }

    public FadeShader fragColorMod(String color, String fog) {
        if (!Config.isModEnabled || !Config.isFadeEnabled) {
            return this;
        }
        this.newLine("if (cfi_FadeFactor >= 0.0 && cfi_FadeFactor < 1.0) {");
        this.calculateFade("float fade = ");
        this.newLine("%s = mix(%s, %s, fade);".formatted(color, fog, color));
        this.newLine("}");
        return this;
    }

    public FadeShader calculateVertexDisplacement(String localPos, String position, boolean modifyLocal, String drawId) {
        switch (Config.animationType) {
            case FULL: 
            case JAGGED: {
                this.newLine("%s += chunkFadeData.xyz".formatted(modifyLocal ? localPos : position));
                if (Config.animationType == AnimationType.JAGGED) {
                    this.append(" * rand");
                }
                this.append(";");
                break;
            }
            case DISPLACEMENT: {
                this.newLine("if (%s.x != 0.0 && %s.y != 0.0 && %s.z != 0.0 && %s.x != 16.0 && %s.y != 16.0 && %s.z != 16.0) {".replace("%s", localPos));
                this.randAppend("rand2", "%s - vec3(%s)".formatted(localPos, drawId));
                this.randAppend("rand3", "%s + vec3(%s * uint(2))".formatted(localPos, drawId));
                this.append("%s += vec3(rand - 0.5, rand2 - 0.5, rand3 - 0.5) * vec3(chunkFadeData.y);".formatted(modifyLocal ? localPos : position));
                this.append("}");
                break;
            }
            case SCALE: {
                if (modifyLocal) {
                    this.newLine("%s = mix(vec3(8.0), %s, 1.0 - chunkFadeData.y);".formatted(localPos, localPos));
                    break;
                }
                this.newLine("%s += vec3(8.0) - mix(vec3(8.0), %s, chunkFadeData.y);".formatted(position, localPos));
            }
        }
        return this;
    }

    public FadeShader calculateFade(String prefix) {
        if (Config.fadeType == FadeType.FULL) {
            this.newLine(prefix + "cfi_FadeFactor;");
        }
        if (Config.fadeType == FadeType.LINED) {
            this.newLine(prefix + "cfi_RefFactor <= cfi_FadeFactor ? 1.0 : 0.0;");
        }
        if (Config.fadeType == FadeType.BLOCK) {
            this.rand("rand", "floor(cfi_BlockSeed)");
            this.newLine(prefix + "cfi_FadeFactor > rand ? 1.0 : cfi_FadeFactor / rand;");
        }
        if (Config.fadeType == FadeType.VERTEX) {
            this.newLine(prefix + "cfi_RefFactor;");
        }
        return this;
    }

    public void rand(String name, String vector) {
        this.newLine("float %s = fract(sin(dot(%s, vec3(12.9898, 78.233, 132.383))) * 43758.5453);".formatted(name, vector));
        this.newLine("if (%s == 0.0) %s = 0.001;".formatted(name, name));
    }

    public void randAppend(String name, String vector) {
        this.append("float %s = fract(sin(dot(%s, vec3(12.9898, 78.233, 132.383))) * 43758.5453);".formatted(name, vector));
        this.append("if (%s == 0.0) %s = 0.001;".formatted(name, name));
    }

    public FadeShader newLine(String line) {
        this.lines.add(line);
        return this;
    }

    public FadeShader append(String value) {
        int last = this.lines.size() - 1;
        this.lines.set(last, this.lines.get(last) + value);
        return this;
    }

    public String flushMultiline() {
        return String.join((CharSequence)"\n", this.flushList());
    }

    public String flushSingleLine() {
        return String.join((CharSequence)" ", this.flushList());
    }

    public String[] flushArray() {
        return (String[])this.flushList().toArray(String[]::new);
    }

    public List<String> flushList() {
        List<String> lines = this.lines;
        this.lines = new ArrayList<String>();
        return lines;
    }
}

