/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.core.FadeShader;
import io.github.douira.glsl_transformer.ast.data.ChildNodeList;
import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.Version;
import io.github.douira.glsl_transformer.ast.node.abstract_node.ASTNode;
import io.github.douira.glsl_transformer.ast.node.declaration.Declaration;
import io.github.douira.glsl_transformer.ast.node.declaration.DeclarationMember;
import io.github.douira.glsl_transformer.ast.node.declaration.InterfaceBlockDeclaration;
import io.github.douira.glsl_transformer.ast.node.declaration.TypeAndInitDeclaration;
import io.github.douira.glsl_transformer.ast.node.expression.LiteralExpression;
import io.github.douira.glsl_transformer.ast.node.external_declaration.DeclarationExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.ExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.FunctionDefinition;
import io.github.douira.glsl_transformer.ast.node.statement.Statement;
import io.github.douira.glsl_transformer.ast.node.type.FullySpecifiedType;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.LayoutQualifier;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.LayoutQualifierPart;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.NamedLayoutQualifierPart;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.TypeQualifier;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.TypeQualifierPart;
import io.github.douira.glsl_transformer.ast.node.type.specifier.BuiltinNumericTypeSpecifier;
import io.github.douira.glsl_transformer.ast.node.type.specifier.TypeSpecifier;
import io.github.douira.glsl_transformer.ast.print.ASTPrinter;
import io.github.douira.glsl_transformer.ast.print.PrintType;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.RootSupplier;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import io.github.douira.glsl_transformer.ast.transform.ASTTransformer;
import io.github.douira.glsl_transformer.ast.transform.JobParameters;
import io.github.douira.glsl_transformer.ast.traversal.ASTListener;
import io.github.douira.glsl_transformer.ast.traversal.ASTWalker;
import io.github.douira.glsl_transformer.util.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.irisshaders.iris.pipeline.transform.PatchShaderType;
import net.irisshaders.iris.pipeline.transform.parameter.SodiumParameters;
import net.minecraft.class_3545;

public class IrisPatcher {
    public static ThreadLocal<String> currentShaderName = ThreadLocal.withInitial(() -> null);
    private static final Set<String> sorterWhitelist = new HashSet<String>(){
        {
            this.add("getVertexPosition");
            this.add("u_RegionOffset");
            this.add("_get_draw_translation");
            this.add("_get_relative_chunk_coord");
        }
    };
    private static final Pattern versionPattern = Pattern.compile("#version\\s+(\\d+)", 32);
    private static final ASTTransformer<Parameters, String> transformer = new ASTTransformer<Parameters, String>(){
        {
            this.setRootSupplier(RootSupplier.PREFIX_UNORDERED_ED_EXACT);
        }

        public TranslationUnit parseTranslationUnit(Root rootInstance, String input) {
            Matcher matcher = versionPattern.matcher(input);
            if (matcher.find()) {
                IrisPatcher.transformer.getLexer().version = Version.fromNumber((int)Integer.parseInt(matcher.group(1)));
            }
            return super.parseTranslationUnit(rootInstance, input);
        }

        public String transform(RootSupplier rootSupplier, String input) {
            TranslationUnit tree = this.parseTranslationUnit(rootSupplier, input);
            Root root = tree.getRoot();
            root.indexBuildSession(() -> IrisPatcher.internalInjectVarsAndDummyAPI(transformer, tree, root, (Parameters)this.getJobParameters()));
            return ASTPrinter.print((PrintType)this.getPrintType(), (ASTNode)tree);
        }
    };

    private static void internalInjectVarsAndDummyAPI(ASTParser t, TranslationUnit tree, Root root, Parameters parameters) {
        if (IrisPatcher.hasFn(tree, "_cfi_injected")) {
            return;
        }
        FadeShader shader = new FadeShader();
        boolean inject = !IrisPatcher.hasFn(tree, "_cfi_noInjectMarker");
        switch (parameters.type) {
            case VERTEX: {
                tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, shader.vertInVars().flushList().stream());
                tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, new String[]{shader.dummyApiVertGetFadeData().flushSingleLine(), shader.dummyApiVertCalculateDisplacement().flushSingleLine(), shader.dummyApiVertCalculateDisplacement2().flushSingleLine(), shader.dummyApiVertCalculateCurvature().flushSingleLine(), shader.dummyApiVertCalculateCurvature2().flushSingleLine()});
                if (!inject) break;
                tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, shader.vertOutVars().flushList().stream());
                break;
            }
            case FRAGMENT: {
                if (!inject) break;
                tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, new String[]{shader.dummyApiFragCalculateFade().flushSingleLine(), shader.dummyApiFragApplyFade().flushSingleLine(), shader.dummyApiFragApplyFogFade().flushSingleLine()});
                tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, shader.fragInVars().flushList().stream());
                break;
            }
            default: {
                return;
            }
        }
        tree.parseAndInjectNodes(t, ASTInjectionPoint.END, new String[]{"void _cfi_injected() {}"});
    }

    public static String injectVarsAndDummyAPI(PatchShaderType type, String source) {
        if (source.contains("_cfi_ignoreMarker") || !source.contains("cfi_") && !source.contains("CFI_") && !source.contains("CHUNKS_FADE_IN_")) {
            return source;
        }
        transformer.setJobParameters((JobParameters)new Parameters(type));
        return (String)transformer.transform((Object)source);
    }

    public static void injectModAndAPI(ASTParser t, TranslationUnit tree, Root root, SodiumParameters parameters) {
        FadeShader shader = new FadeShader();
        boolean injected = IrisPatcher.hasFn(tree, "_cfi_injected");
        boolean inject = !IrisPatcher.hasFn(tree, "_cfi_noInjectMarker");
        boolean injectMod = !IrisPatcher.hasFn(tree, "_cfi_noInjectModMarker");
        boolean injectFragMod = injectMod && !IrisPatcher.hasFn(tree, "_cfi_noInjectFragModMarker");
        boolean injectVertMod = injectMod && !IrisPatcher.hasFn(tree, "_cfi_noInjectVertModMarker");
        boolean injectCurvature = !IrisPatcher.hasFn(tree, "_cfi_noCurvatureMarker");
        switch (parameters.type.glShaderType) {
            case VERTEX: {
                IrisPatcher.removeFn(tree, "cfi_getFadeData");
                IrisPatcher.removeFn(tree, "cfi_calculateDisplacement");
                IrisPatcher.removeFn(tree, "cfi_calculateCurvature");
                if (!injected) {
                    tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, shader.vertInVars().flushList().stream());
                }
                tree.injectNodes(ASTInjectionPoint.BEFORE_FUNCTIONS, IrisPatcher.parseDeclarations(t, root, shader.apiVertGetFadeData("_draw_id").flushSingleLine(), shader.apiVertCalculateDisplacement().flushSingleLine(), shader.apiVertCalculateDisplacement2().flushSingleLine(), shader.apiVertCalculateCurvature().flushSingleLine(), shader.apiVertCalculateCurvature2().flushSingleLine()));
                if (!inject) break;
                shader.newLine("vec3 position = getVertexPosition().xyz;").vertInitOutVars("_vert_position", "_draw_id");
                if (injectVertMod) {
                    shader.vertInitMod("_vert_position", "position", true, "_draw_id", injectCurvature);
                }
                tree.appendFunctionBody("_vert_init", IrisPatcher.parseStatements(t, root, shader.flushArray()));
                if (injected) break;
                tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, shader.vertOutVars().flushList().stream());
                break;
            }
            case FRAGMENT: {
                if (!inject) {
                    return;
                }
                IrisPatcher.removeFn(tree, "cfi_applyFogFade");
                IrisPatcher.removeFn(tree, "cfi_applyFade");
                IrisPatcher.removeFn(tree, "cfi_calculateFade");
                tree.injectNodes(ASTInjectionPoint.BEFORE_FUNCTIONS, IrisPatcher.parseDeclarations(t, root, shader.apiFragCalculateFade().flushSingleLine(), shader.apiFragApplyFade().flushSingleLine(), shader.apiFragApplyFogFade().flushSingleLine()));
                if (!injected) {
                    tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, shader.fragInVars().flushList().stream());
                }
                if (!injectFragMod) break;
                List<class_3545<Type, String>> layouts = IrisPatcher.findOutputColors(tree);
                class_3545<Type, String> first = layouts.get(0);
                tree.appendMainFunctionBody(IrisPatcher.parseStatements(t, root, shader.fragColorMod((String)first.method_15441() + ".rgb", "iris_FogColor.rgb").flushMultiline()));
                break;
            }
        }
        IrisPatcher.sortUses(t, tree);
        IrisPatcher.sortUses(t, tree);
    }

    private static void sortUses(ASTParser t, TranslationUnit tree) {
        tree.getRoot().identifierIndex.index.entrySet().stream().filter(e -> sorterWhitelist.contains(e.getKey()) || !((String)e.getKey()).startsWith("_") && ((String)e.getKey()).contains("cfi_")).forEach(e -> {
            ChildNodeList children = tree.getChildren();
            FunctionDefinition declaration = null;
            int firstUseIdx = -1;
            for (Identifier id : (Set)e.getValue()) {
                InterfaceBlockDeclaration intDeclaration;
                Declaration patt0$temp;
                FunctionDefinition fnDefinition = (FunctionDefinition)id.getBranchAncestor(FunctionDefinition.class, FunctionDefinition::getFunctionPrototype);
                DeclarationExternalDeclaration externalDeclaration = (DeclarationExternalDeclaration)id.getBranchAncestor(DeclarationExternalDeclaration.class, DeclarationExternalDeclaration::getDeclaration);
                if (externalDeclaration != null && ((String)e.getKey()).equals("cfi_ChunkFadeData") && (patt0$temp = externalDeclaration.getDeclaration()) instanceof InterfaceBlockDeclaration && !(intDeclaration = (InterfaceBlockDeclaration)patt0$temp).getBlockName().getName().equals(e.getKey())) {
                    externalDeclaration = null;
                }
                if (fnDefinition == null && externalDeclaration == null) {
                    int i;
                    ExternalDeclaration child = (ExternalDeclaration)id.getAncestor(FunctionDefinition.class);
                    if (child == null) {
                        child = (ExternalDeclaration)id.getAncestor(DeclarationExternalDeclaration.class);
                    }
                    if ((i = children.indexOf((Object)child)) != -1 && (firstUseIdx == -1 || firstUseIdx > i)) {
                        firstUseIdx = i;
                    }
                }
                if (declaration != null) continue;
                if (fnDefinition != null) {
                    declaration = fnDefinition;
                    continue;
                }
                if (externalDeclaration == null) continue;
                declaration = externalDeclaration;
            }
            if (firstUseIdx == -1) {
                return;
            }
            if (declaration != null && children.indexOf(declaration) > firstUseIdx) {
                declaration.detach();
                children.add(firstUseIdx, declaration);
            }
        });
    }

    private static List<class_3545<Type, String>> findOutputColors(TranslationUnit tree) {
        final ArrayList<class_3545<Type, String>> colors = new ArrayList<class_3545<Type, String>>();
        ASTListener listener = new ASTListener(){

            public void enterTypeAndInitDeclaration(TypeAndInitDeclaration declaration) {
                FullySpecifiedType fullType = declaration.getType();
                TypeSpecifier typeSpecifier = fullType.getTypeSpecifier();
                if (!(typeSpecifier instanceof BuiltinNumericTypeSpecifier)) {
                    return;
                }
                BuiltinNumericTypeSpecifier numSpecifier = (BuiltinNumericTypeSpecifier)typeSpecifier;
                TypeQualifier typeQualifier = fullType.getTypeQualifier();
                if (typeQualifier == null) {
                    return;
                }
                for (TypeQualifierPart part : typeQualifier.getParts()) {
                    if (!(part instanceof LayoutQualifier)) continue;
                    LayoutQualifier qualifier = (LayoutQualifier)part;
                    for (LayoutQualifierPart layoutPart : qualifier.getParts()) {
                        NamedLayoutQualifierPart namedPart;
                        if (!(layoutPart instanceof NamedLayoutQualifierPart) || !((namedPart = (NamedLayoutQualifierPart)layoutPart).getExpression() instanceof LiteralExpression)) continue;
                        colors.add(new class_3545((Object)numSpecifier.type, (Object)((DeclarationMember)declaration.getMembers().get(0)).getName().getName()));
                    }
                }
            }
        };
        ASTWalker.walk((ASTListener)listener, (ASTNode)tree);
        return colors;
    }

    private static void removeFn(TranslationUnit tree, String name) {
        try {
            for (int i = 0; i < 2; ++i) {
                tree.getOneFunctionDefinitionBody(name).getParent().detachAndDelete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean hasFn(TranslationUnit tree, String name) {
        try {
            tree.getOneFunctionDefinitionBody(name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static List<ExternalDeclaration> parseDeclarations(ASTParser t, Root root, String ... input) {
        if (input.length == 0 || Arrays.stream(input).allMatch(s -> s.isBlank())) {
            return List.of();
        }
        return t.parseExternalDeclarations(root, input);
    }

    private static List<Statement> parseStatements(ASTParser t, Root root, String ... input) {
        if (input.length == 0 || Arrays.stream(input).allMatch(s -> s.isBlank())) {
            return List.of();
        }
        return t.parseStatements(root, input);
    }

    private static class Parameters
    implements JobParameters {
        public final PatchShaderType type;

        public Parameters(PatchShaderType type) {
            this.type = type;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Parameters) {
                Parameters other = (Parameters)obj;
                return this.type == other.type;
            }
            return false;
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }
}

