/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.mixin.iris;

import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.AnimationType;
import com.koteinik.chunksfadein.core.FadeType;
import com.koteinik.chunksfadein.core.IrisPatcher;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.HashSet;
import java.util.Set;
import net.irisshaders.iris.helpers.StringPair;
import net.irisshaders.iris.shaderpack.preprocessor.JcppProcessor;
import org.anarres.cpp.Preprocessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={JcppProcessor.class}, remap=false)
public class JcppProcessorMixin {
    private static final Set<String> whitelistedPrograms = new HashSet<String>(){
        {
            this.add("shadow");
            this.add("shadow_solid");
            this.add("shadow_cutout");
            this.add("shadow_water");
            this.add("gbuffers_terrain");
            this.add("gbuffers_water");
        }
    };

    @Inject(method={"glslPreprocessSource"}, at={@At(value="INVOKE", target="Lorg/anarres/cpp/Preprocessor;setListener(Lorg/anarres/cpp/PreprocessorListener;)V", shift=At.Shift.BEFORE)})
    private static void modifyGlslPreprocessSource(String source, Iterable<StringPair> environmentDefines, CallbackInfoReturnable<String> cir, @Local(name={"pp"}) Preprocessor pp) {
        if (!Config.isModEnabled) {
            return;
        }
        if (!source.contains("CHUNKS_FADE_IN_FORCE_DEFINES") && !whitelistedPrograms.contains(IrisPatcher.currentShaderName.get())) {
            return;
        }
        try {
            pp.addMacro("CHUNKS_FADE_IN_ENABLED");
            if (Config.isFadeEnabled) {
                for (Enum enum_ : FadeType.values()) {
                    pp.addMacro("CFI_FADE_" + enum_.name().toUpperCase(), "" + enum_.ordinal());
                }
                pp.addMacro("CFI_FADE", "" + Config.fadeType.ordinal());
            }
            if (Config.isAnimationEnabled) {
                for (Enum enum_ : AnimationType.values()) {
                    pp.addMacro("CFI_ANIMATION_" + enum_.name().toUpperCase(), "" + enum_.ordinal());
                }
                pp.addMacro("CFI_ANIMATION", "" + Config.animationType.ordinal());
            }
            if (Config.isCurvatureEnabled) {
                pp.addMacro("CFI_CURVATURE", "" + Config.worldCurvature);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ModifyVariable(method={"glslPreprocessSource"}, at=@At(value="INVOKE", target="Lorg/anarres/cpp/Preprocessor;setListener(Lorg/anarres/cpp/PreprocessorListener;)V", shift=At.Shift.BEFORE))
    private static String modifyGlslPreprocessSource2(String source) {
        if (!Config.isModEnabled) {
            return source;
        }
        if (!whitelistedPrograms.contains(IrisPatcher.currentShaderName.get())) {
            source = (String)source + "\nvoid _cfi_ignoreMarker() {}\n";
            return source;
        }
        if (((String)source).contains("CHUNKS_FADE_IN_NO_MOD_INJECT")) {
            source = (String)source + "\nvoid _cfi_noInjectModMarker() {}\n";
        }
        if (((String)source).contains("CHUNKS_FADE_IN_NO_FRAG_MOD_INJECT")) {
            source = (String)source + "\nvoid _cfi_noInjectFragModMarker() {}\n";
        }
        if (((String)source).contains("CHUNKS_FADE_IN_NO_VERT_MOD_INJECT")) {
            source = (String)source + "\nvoid _cfi_noInjectVertModMarker() {}\n";
        }
        if (((String)source).contains("CHUNKS_FADE_IN_NO_INJECT")) {
            source = (String)source + "\nvoid _cfi_noInjectMarker() {}\n";
        }
        if (((String)source).contains("CHUNKS_FADE_IN_NO_CURVATURE")) {
            source = (String)source + "\nvoid _cfi_noCurvatureMarker() {}\n";
        }
        return source;
    }
}

