/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.config;

import com.koteinik.chunksfadein.Logger;
import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.config.ConfigEntry;
import com.koteinik.chunksfadein.config.ConfigEntryDoubleLimitable;
import com.koteinik.chunksfadein.core.AnimationType;
import com.koteinik.chunksfadein.core.Curve;
import com.koteinik.chunksfadein.core.FadeType;
import com.koteinik.chunksfadein.core.FogOverrideMode;
import com.koteinik.chunksfadein.platform.Services;
import com.moandjiezana.toml.Toml;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;

public class Config {
    private static final int CONFIG_VERSION = 4;
    public static final double MIN_FADE_TIME = 0.01;
    public static final double MAX_FADE_TIME = 10.0;
    public static final double MIN_ANIMATION_TIME = 0.01;
    public static final double MAX_ANIMATION_TIME = 10.0;
    public static final double MIN_ANIMATION_OFFSET = -128.0;
    public static final double MAX_ANIMATION_OFFSET = 128.0;
    public static final double MIN_ANIMATION_FACTOR = 0.01;
    public static final double MAX_ANIMATION_FACTOR = 1.0;
    public static final double MIN_ANIMATION_ANGLE = 0.0;
    public static final double MAX_ANIMATION_ANGLE = 90.0;
    public static final int MIN_CURVATURE = -65536;
    public static final int MAX_CURVATURE = 65536;
    public static final String CONFIG_VERSION_KEY = "config-version";
    public static final String MOD_ENABLED_KEY = "mod-enabled";
    public static final String SHOW_MOD_TAB_IN_SETTINGS_KEY = "show-mod-tab-in-settings";
    public static final String UPDATE_NOTIFIER_ENABLED_KEY = "update-notifier-enabled";
    public static final String FADE_ENABLED_KEY = "fade-enabled";
    public static final String FADE_TIME_KEY = "fade-time";
    public static final String FADE_TYPE_KEY = "fade-type";
    public static final String FOG_OVERRIDE_KEY = "fog-override";
    public static final String FADE_NEAR_PLAYER_KEY = "fade-near-player";
    public static final String ANIMATION_ENABLED_KEY = "animation-enabled";
    public static final String ANIMATION_TYPE_KEY = "animation-type";
    public static final String ANIMATE_NEAR_PLAYER_KEY = "animate-near-player";
    public static final String ANIMATE_WITH_DH_KEY = "fade-with-dh";
    public static final String ANIMATION_TIME_KEY = "animation-time";
    public static final String ANIMATION_CURVE_KEY = "animation-curve";
    public static final String ANIMATION_OFFSET_KEY = "animation-offset";
    public static final String ANIMATION_ANGLE_KEY = "animation-angle";
    public static final String ANIMATION_FACTOR_KEY = "animation-factor";
    public static final String CURVATURE_ENABLED_KEY = "world-curvature-enabled";
    public static final String CURVATURE_KEY = "world-curvature";
    private static final Map<String, ConfigEntry<?>> entries = new HashMap();
    private static File configFile;
    public static boolean isModEnabled;
    public static boolean isFadeEnabled;
    public static boolean isAnimationEnabled;
    public static boolean isCurvatureEnabled;
    public static boolean isUpdateNotifierEnabled;
    public static boolean showModTabInSettings;
    public static boolean animateNearPlayer;
    public static boolean animateWithDH;
    public static boolean fadeNearPlayer;
    public static float animationAngle;
    public static float animationOffset;
    public static float animationFactor;
    public static float animationChangePerMs;
    public static float fadeChangePerMs;
    public static int worldCurvature;
    public static int configVersion;
    public static Curve animationCurve;
    public static FadeType fadeType;
    public static FogOverrideMode fogOverrideMode;
    public static AnimationType animationType;

    public static float fadeChangeFromSeconds(double seconds) {
        float secondsInMs = (float)(seconds * 1000.0);
        return 1.0f / secondsInMs;
    }

    public static float secondsFromFadeChange() {
        return 1.0f / fadeChangePerMs / 1000.0f;
    }

    public static float animationChangeFromSeconds(double seconds) {
        float secondsInMs = (float)(seconds * 1000.0);
        return 1.0f / secondsInMs;
    }

    public static double secondsFromAnimationChange() {
        return (double)(1.0f / animationChangePerMs) / 1000.0;
    }

    public static void load() {
        configFile = new File(Services.PLATFORM.getConfigDirectory(), "chunksfadein.properties");
        Toml toml = new Toml();
        try {
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            toml.read(configFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ConfigEntry<?> entry : entries.values()) {
            entry.load(toml);
        }
        if (configVersion < 3) {
            Config.setDouble(ANIMATION_OFFSET_KEY, -Config.getDouble(ANIMATION_OFFSET_KEY));
        }
        Config.setInteger(CONFIG_VERSION_KEY, 4);
        Config.save();
    }

    public static void save() {
        StringBuilder string = new StringBuilder();
        for (ConfigEntry<?> entry : entries.values()) {
            string.append(entry.toString());
        }
        try {
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(configFile));
            writer.write(string.toString());
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.error("Failed to save config! If this is an error, please create an issue on github!");
        }
    }

    public static int setInteger(String key, Integer value) {
        ConfigEntry<Integer> entry = Config.get(key);
        return entry.set(value);
    }

    public static boolean setBoolean(String key, Boolean value) {
        ConfigEntry<Boolean> entry = Config.get(key);
        return entry.set(value);
    }

    public static double setDouble(String key, Double value) {
        ConfigEntry<Double> entry = Config.get(key);
        return entry.set(value);
    }

    public static boolean getBoolean(String key) {
        ConfigEntry entry = Config.get(key);
        return (Boolean)entry.get();
    }

    public static int getInteger(String key) {
        ConfigEntry entry = Config.get(key);
        return (Integer)entry.get();
    }

    public static double getDouble(String key) {
        ConfigEntry entry = Config.get(key);
        return (Double)entry.get();
    }

    public static boolean flipBoolean(String key) {
        return Config.setBoolean(key, !Config.getBoolean(key));
    }

    public static double getMin(String key) {
        ConfigEntry entry = Config.get(key);
        if (entry instanceof ConfigEntryDoubleLimitable) {
            ConfigEntryDoubleLimitable limitable = (ConfigEntryDoubleLimitable)entry;
            return limitable.getMin();
        }
        throw new UnsupportedOperationException();
    }

    public static double getMax(String key) {
        ConfigEntry entry = Config.get(key);
        if (entry instanceof ConfigEntryDoubleLimitable) {
            ConfigEntryDoubleLimitable limitable = (ConfigEntryDoubleLimitable)entry;
            return limitable.getMax();
        }
        throw new UnsupportedOperationException();
    }

    public static void reset(String key) {
        Config.get(key).reset();
    }

    private static <T> ConfigEntry<T> get(String key) {
        return entries.get(key);
    }

    private static <T> ConfigEntry<T> addEntry(ConfigEntry<T> entry) {
        entries.put(entry.configKey, entry);
        return entry;
    }

    static {
        Config.addEntry(new ConfigEntry<Integer>(4, CONFIG_VERSION_KEY, ConfigEntry.Type.INTEGER)).addListener(o -> {
            configVersion = o;
        });
        Config.addEntry(new ConfigEntry<Integer>(Curve.EASE_OUT.ordinal(), ANIMATION_CURVE_KEY, ConfigEntry.Type.INTEGER)).addListener(o -> {
            animationCurve = Curve.values()[MathUtils.clamp(o, 0, Curve.values().length - 1)];
        });
        Config.addEntry(new ConfigEntry<Integer>(FadeType.FULL.ordinal(), FADE_TYPE_KEY, ConfigEntry.Type.INTEGER)).addListener(o -> {
            fadeType = FadeType.values()[MathUtils.clamp(o, 0, FadeType.values().length - 1)];
        });
        Config.addEntry(new ConfigEntry<Integer>(FogOverrideMode.CYLINDRICAL.ordinal(), FOG_OVERRIDE_KEY, ConfigEntry.Type.INTEGER)).addListener(o -> {
            fogOverrideMode = FogOverrideMode.values()[MathUtils.clamp(o, 0, FogOverrideMode.values().length - 1)];
        });
        Config.addEntry(new ConfigEntry<Integer>(AnimationType.FULL.ordinal(), ANIMATION_TYPE_KEY, ConfigEntry.Type.INTEGER)).addListener(o -> {
            animationType = AnimationType.values()[MathUtils.clamp(o, 0, AnimationType.values().length - 1)];
        });
        Config.addEntry(new ConfigEntry<Integer>(16384, CURVATURE_KEY, ConfigEntry.Type.INTEGER)).addListener(o -> {
            worldCurvature = o;
        });
        Config.addEntry(new ConfigEntryDoubleLimitable(0.01, 10.0, 0.75, FADE_TIME_KEY)).addListener(o -> {
            fadeChangePerMs = Config.fadeChangeFromSeconds(o);
        });
        Config.addEntry(new ConfigEntryDoubleLimitable(0.01, 10.0, 2.56, ANIMATION_TIME_KEY)).addListener(o -> {
            animationChangePerMs = Config.animationChangeFromSeconds(o);
        });
        Config.addEntry(new ConfigEntryDoubleLimitable(-128.0, 128.0, -64.0, ANIMATION_OFFSET_KEY)).addListener(o -> {
            animationOffset = o.floatValue();
        });
        Config.addEntry(new ConfigEntryDoubleLimitable(0.0, 90.0, 0.0, ANIMATION_ANGLE_KEY)).addListener(o -> {
            animationAngle = o.floatValue();
        });
        Config.addEntry(new ConfigEntryDoubleLimitable(0.01, 1.0, 1.0, ANIMATION_FACTOR_KEY)).addListener(o -> {
            animationFactor = o.floatValue();
        });
        Config.addEntry(new ConfigEntry<Boolean>(true, MOD_ENABLED_KEY, ConfigEntry.Type.BOOLEAN)).addListener(o -> {
            isModEnabled = o;
        });
        Config.addEntry(new ConfigEntry<Boolean>(true, FADE_ENABLED_KEY, ConfigEntry.Type.BOOLEAN)).addListener(o -> {
            isFadeEnabled = o;
        });
        Config.addEntry(new ConfigEntry<Boolean>(false, ANIMATION_ENABLED_KEY, ConfigEntry.Type.BOOLEAN)).addListener(o -> {
            isAnimationEnabled = o;
        });
        Config.addEntry(new ConfigEntry<Boolean>(false, CURVATURE_ENABLED_KEY, ConfigEntry.Type.BOOLEAN)).addListener(o -> {
            isCurvatureEnabled = o;
        });
        Config.addEntry(new ConfigEntry<Boolean>(true, UPDATE_NOTIFIER_ENABLED_KEY, ConfigEntry.Type.BOOLEAN)).addListener(o -> {
            isUpdateNotifierEnabled = o;
        });
        Config.addEntry(new ConfigEntry<Boolean>(true, SHOW_MOD_TAB_IN_SETTINGS_KEY, ConfigEntry.Type.BOOLEAN)).addListener(o -> {
            showModTabInSettings = o;
        });
        Config.addEntry(new ConfigEntry<Boolean>(true, ANIMATE_NEAR_PLAYER_KEY, ConfigEntry.Type.BOOLEAN)).addListener(o -> {
            animateNearPlayer = o;
        });
        Config.addEntry(new ConfigEntry<Boolean>(false, ANIMATE_WITH_DH_KEY, ConfigEntry.Type.BOOLEAN)).addListener(o -> {
            animateWithDH = o;
        });
        Config.addEntry(new ConfigEntry<Boolean>(true, FADE_NEAR_PLAYER_KEY, ConfigEntry.Type.BOOLEAN)).addListener(o -> {
            fadeNearPlayer = o;
        });
    }
}

