/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.config;

import com.moandjiezana.toml.Toml;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class ConfigEntry<T> {
    protected final Set<Consumer<T>> updateListeners = new HashSet<Consumer<T>>();
    protected final Type type;
    public final T defaultValue;
    public final String configKey;
    protected T value;

    public ConfigEntry(T defaultValue, String configKey, Type type) {
        this.defaultValue = defaultValue;
        this.configKey = configKey;
        this.type = type;
    }

    public void reset() {
        this.value = this.defaultValue;
        this.pollListeners();
    }

    public T get() {
        return this.value;
    }

    public T set(T value) {
        this.value = value;
        this.pollListeners();
        return value;
    }

    public void load(Toml toml) {
        Object tomlValue = this.type.get(toml, this.configKey);
        if (tomlValue == null) {
            tomlValue = this.defaultValue;
        }
        this.value = tomlValue;
        this.pollListeners();
    }

    protected void pollListeners() {
        this.updateListeners.forEach(c -> c.accept(this.value));
    }

    public Consumer<T> addListener(Consumer<T> consumer) {
        this.updateListeners.add(consumer);
        return consumer;
    }

    public void removeListener(Consumer<?> consumer) {
        this.updateListeners.remove(consumer);
    }

    public String toString() {
        return this.configKey + " = " + String.valueOf(this.value) + "\n";
    }

    public static enum Type {
        INTEGER((t, k) -> t.getLong(k) == null ? null : Integer.valueOf(t.getLong(k).intValue())),
        DOUBLE((t, k) -> t.getDouble(k)),
        BOOLEAN((t, k) -> t.getBoolean(k));

        private BiFunction<Toml, String, Object> get;

        private Type(BiFunction<Toml, String, Object> get) {
            this.get = get;
        }

        public Object get(Toml toml, String key) {
            return this.get.apply(toml, key);
        }
    }
}

