/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.hooks;

import com.seibel.distanthorizons.api.enums.rendering.EDhApiRendererMode;
import com.seibel.distanthorizons.core.config.Config;
import net.irisshaders.iris.api.v0.IrisApi;

public class CompatibilityHook {
    public static final boolean isModMenuLoaded = CompatibilityHook.isModMenuLoaded();
    public static final boolean isIrisLoaded = CompatibilityHook.isIrisLoaded();
    public static final boolean isDHLoaded = CompatibilityHook.isDHLoaded();

    public static boolean isIrisShaderPackInUse() {
        if (!isIrisLoaded) {
            return false;
        }
        try {
            return IrisApi.getInstance().isShaderPackInUse();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDHSSAOEnabled() {
        if (!isDHLoaded) {
            return false;
        }
        try {
            return !CompatibilityHook.isIrisShaderPackInUse() && (Boolean)Config.Client.Advanced.Graphics.Ssao.enableSsao.get() != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDHRenderingEnabled() {
        if (!isDHLoaded) {
            return false;
        }
        try {
            return Config.Client.Advanced.Debugging.rendererMode.get() != EDhApiRendererMode.DISABLED;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isIrisLoaded() {
        try {
            Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isModMenuLoaded() {
        try {
            Class.forName("com.terraformersmc.modmenu.api.ModMenuApi");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isDHLoaded() {
        try {
            Class.forName("com.seibel.distanthorizons.api.DhApi");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

