package com.koteinik.chunksfadein.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_746;
import com.koteinik.chunksfadein.core.ModrinthApi.ModrinthVersion;
import com.koteinik.chunksfadein.platform.Services;

public class UpdateNotifier {
	public static void checkAndNotify() {
		new Thread(() -> {
			ModrinthVersion latestVersion = ModrinthApi.getLatestModVersion();

			if (isNewerVersion(latestVersion)) {
				List<class_2561> textList = new ArrayList<>();
				textList.add(class_2561.method_43470("§7New version of §2Chunks fade in §7is available!"));

				class_2583 linkStyle = class_2583.field_24360.method_10958(new class_2558.class_10608(URI.create(latestVersion.downloadUrl)));

				textList.add(class_2561.method_43470("§7v" + latestVersion.version + "§r§7 changelog:"));
				textList.add(class_2561.method_43470("§7" + latestVersion.changelog));
				textList.addAll(class_2561.method_43470("§7§nClick to download").method_36136(linkStyle));

				class_310 minecraft = class_310.method_1551();
				class_746 player = minecraft.field_1724;

				if (player == null)
					return;

				for (class_2561 text : textList)
					player.method_7353(text, false);
			}
		}).start();
	}

	private static boolean isNewerVersion(ModrinthVersion modrinthVersion) {
		if (modrinthVersion == null)
			return false;

		return Services.PLATFORM.getModVersion().compareTo(modrinthVersion.version) < 0;
	}
}
