/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein;

import com.koteinik.chunksfadein.Logger;
import com.koteinik.chunksfadein.compat.dh.ext.LodRendererExt;
import com.koteinik.chunksfadein.hooks.CompatibilityHook;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pipeline.transform.TransformPatcher;
import net.minecraft.client.Minecraft;

public class ShaderUtils {
    public static LodRendererExt lodRenderer = null;
    private static Object irisTransformCache;
    private static Object monocleTransformCache;
    private static Method mapClear;

    public static boolean reloadOnEveryChange() {
        return CompatibilityHook.isIrisLoaded || CompatibilityHook.isDHRenderingEnabled();
    }

    public static void reloadWorldRenderer() {
        try {
            if (CompatibilityHook.isIrisLoaded) {
                mapClear.invoke(irisTransformCache, new Object[0]);
                if (monocleTransformCache != null) {
                    mapClear.invoke(monocleTransformCache, new Object[0]);
                }
            }
            if (CompatibilityHook.isIrisShaderPackInUse()) {
                Iris.reload();
            } else {
                Minecraft minecraft = Minecraft.getInstance();
                minecraft.levelRenderer.allChanged();
            }
            if (CompatibilityHook.isDHRenderingEnabled() && lodRenderer != null) {
                lodRenderer.rebuildShaders();
            }
        }
        catch (Exception e) {
            Logger.warn("Failed to reload renderers:", e);
        }
    }

    static {
        if (CompatibilityHook.isIrisLoaded) {
            try {
                Field cache = TransformPatcher.class.getDeclaredField("cache");
                cache.setAccessible(true);
                irisTransformCache = cache.get(null);
                mapClear = Map.class.getDeclaredMethod("clear", new Class[0]);
            }
            catch (Exception e) {
                Logger.error("Failed to get Iris methods:", e);
            }
            try {
                Field field = Class.forName("dev.ferriarnus.monocle.ShaderTransformer").getDeclaredField("shaderTransformationCache");
                field.setAccessible(true);
                monocleTransformCache = field.get(null);
            }
            catch (Throwable t) {
                t.printStackTrace();
                monocleTransformCache = null;
            }
        } else {
            irisTransformCache = null;
            mapClear = null;
        }
    }
}

