/*
 * Decompiled with CFR 0.152.
 */
package com.ccbbc.cb_custom;

import com.ccbbc.cb_custom.Config;
import com.ccbbc.cb_custom.item.GreenBottleItem;
import com.mojang.datafixers.util.Unit;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;

@Mod(value="cb_custom")
public class cbcustom {
    public static final String MODID = "cb_custom";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"cb_custom");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"cb_custom");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"cb_custom");
    public static final DeferredItem<Item> GREEN_BOTTLE = ITEMS.register("green_bottle", () -> new GreenBottleItem(new Item.Properties().stacksTo(1).fireResistant()));
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TOYS_TAB = CREATIVE_MODE_TABS.register("toys_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"cb_custom.tab.workspace")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> ((Item)GREEN_BOTTLE.get()).getDefaultInstance()).displayItems((parameters, output) -> output.accept((ItemLike)GREEN_BOTTLE.get())).build());
    private int serverTickCounter;
    public static final DeferredRegister<DataComponentType<?>> ENCHANTMENT_COMPONENT_TYPES = DeferredRegister.create((ResourceKey)Registries.ENCHANTMENT_EFFECT_COMPONENT_TYPE, (String)"cb_custom");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Unit>> ELIXIR_BURST_EFFECT = ENCHANTMENT_COMPONENT_TYPES.register("elixir_burst_effect", () -> DataComponentType.builder().persistent(Codec.unit((Object)Unit.INSTANCE)).build());

    public cbcustom(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        ENCHANTMENT_COMPONENT_TYPES.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        event.enqueueWork(() -> DispenserBlock.registerBehavior((ItemLike)((ItemLike)GREEN_BOTTLE.get()), (source, stack) -> {
            ServerLevel level = source.level();
            Direction facing = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            BlockPos pos = source.pos().relative(facing);
            BlockState state = level.getBlockState(pos);
            boolean success = false;
            if (state.getBlock() instanceof BonemealableBlock) {
                BonemealableBlock bm;
                Block patt0$temp;
                BlockState current = state;
                int safety = 64;
                while (safety-- > 0 && (patt0$temp = current.getBlock()) instanceof BonemealableBlock && (bm = (BonemealableBlock)patt0$temp).isValidBonemealTarget((LevelReader)level, pos, current)) {
                    bm.performBonemeal(level, level.random, pos, current);
                    current = level.getBlockState(pos);
                    success = true;
                }
            }
            if (success) {
                level.levelEvent(1505, pos, 15);
                return stack;
            }
            return new DefaultDispenseItemBehavior().dispense(source, stack);
        }));
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.isEmpty() || right.isEmpty()) {
            return;
        }
        boolean edible = left.get(DataComponents.FOOD) != null;
        boolean isPotion = left.getItem() instanceof PotionItem;
        boolean isMilk = left.is(Items.MILK_BUCKET);
        if (!(edible || isPotion || isMilk)) {
            return;
        }
        ItemEnchantments bookEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)right);
        if (bookEnchantments.isEmpty()) {
            return;
        }
        Holder elixir = null;
        for (Object2IntMap.Entry e : bookEnchantments.entrySet()) {
            Holder h = (Holder)e.getKey();
            if (((Enchantment)h.value()).effects().get((DataComponentType)ELIXIR_BURST_EFFECT.get()) == null) continue;
            elixir = h;
            break;
        }
        if (elixir == null) {
            return;
        }
        ItemStack result = left.copy();
        ItemEnchantments.Mutable out = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)result));
        out.set(elixir, 1);
        EnchantmentHelper.setEnchantments((ItemStack)result, (ItemEnchantments)out.toImmutable());
        event.setOutput(result);
        event.setMaterialCost(1);
        event.setCost(2L);
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        ServerLevel level;
        ++this.serverTickCounter;
        if (this.serverTickCounter < 200) {
            return;
        }
        this.serverTickCounter = 0;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            BlockPos pos;
            level = player.serverLevel();
            CompoundTag tag = player.getPersistentData();
            boolean obtained = tag.getBoolean("cb_custom_green_bottle_obtained");
            boolean hasBottle = player.getInventory().hasAnyOf(Set.of((Item)GREEN_BOTTLE.get()));
            if (hasBottle && !obtained) {
                tag.putBoolean("cb_custom_green_bottle_obtained", true);
                obtained = true;
            }
            if (obtained || hasBottle) continue;
            long dayTime = level.getDayTime() % 24000L;
            boolean isNight = dayTime >= 13000L && dayTime <= 23000L;
            double chance = 0.0;
            String weather = "clear";
            if (level.isThundering()) {
                chance = (Double)Config.THUNDER_BOTTLE_CHANCE.get();
                weather = "thunder";
            } else if (level.isRaining()) {
                chance = (Double)Config.RAIN_BOTTLE_CHANCE.get();
                weather = "rain";
            } else if (isNight) {
                chance = (Double)Config.CLEAR_NIGHT_BOTTLE_CHANCE.get();
                weather = "clear_night";
            }
            if (level.random.nextDouble() >= chance || (pos = this.findSafeSpawnPos(level, player.getX(), player.getY(), player.getZ())) == null) continue;
            ItemStack stack = new ItemStack((ItemLike)GREEN_BOTTLE.get());
            ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, stack);
            itemEntity.setGlowingTag(true);
            itemEntity.setInvulnerable(true);
            itemEntity.getPersistentData().putBoolean("cb_custom_storm_spawned", true);
            level.addFreshEntity((Entity)itemEntity);
            level.sendParticles((ParticleOptions)ParticleTypes.END_ROD, itemEntity.getX(), itemEntity.getY() + 0.5, itemEntity.getZ(), 40, 0.5, 0.5, 0.5, 0.02);
            level.playSound(null, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.AMBIENT, 1.0f, 0.8f);
            server.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"cb_custom.message.bottle_spawned"), false);
            LOGGER.info("Spawned bottle near {} at {} chance {} ({})", new Object[]{player.getGameProfile().getName(), pos, chance, weather});
        }
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            level = player.serverLevel();
            List nearby = level.getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate(0.8));
            for (ItemEntity itemEntity : nearby) {
                CompoundTag eTag;
                ItemStack stack;
                if (!itemEntity.isAlive() || !(stack = itemEntity.getItem()).is((Item)GREEN_BOTTLE.get()) || !(eTag = itemEntity.getPersistentData()).getBoolean("cb_custom_storm_spawned")) continue;
                itemEntity.discard();
                CompoundTag tag = player.getPersistentData();
                tag.putBoolean("cb_custom_green_bottle_obtained", true);
                ItemStack grant = new ItemStack((ItemLike)GREEN_BOTTLE.get());
                player.getInventory().add(grant);
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.6f, 1.2f);
                if (level instanceof ServerLevel) {
                    ServerLevel sl = level;
                    sl.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, player.getX(), player.getY() + 0.5, player.getZ(), 20, 0.25, 0.25, 0.25, 0.02);
                }
                LOGGER.info("Player {} obtained storm bottle", (Object)player.getGameProfile().getName());
            }
        }
    }

    private BlockPos findSafeSpawnPos(ServerLevel level, double px, double py, double pz) {
        for (int i = 0; i < 16; ++i) {
            AABB aabb;
            int z;
            int y;
            double angle = level.random.nextDouble() * Math.PI * 2.0;
            int dist = 10 + level.random.nextInt(11);
            int x = Mth.floor((double)(px + Math.cos(angle) * (double)dist));
            BlockPos pos = new BlockPos(x, y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = Mth.floor((double)(pz + Math.sin(angle) * (double)dist))), z);
            BlockPos below = pos.below();
            BlockState bsBelow = level.getBlockState(below);
            if (bsBelow.isAir() || bsBelow.getFluidState().isSource() || bsBelow.getBlock() instanceof LiquidBlock || !level.noCollision(aabb = new AABB((double)x + 0.2, (double)y + 0.2, (double)z + 0.2, (double)x + 0.8, (double)y + 1.8, (double)z + 0.8))) continue;
            return pos;
        }
        return null;
    }

    @SubscribeEvent
    public void onUseFinish(LivingEntityUseItemEvent.Finish event) {
        boolean edibleOrPotion;
        ItemStack stack = event.getItem();
        LivingEntity user = event.getEntity();
        if (stack.isEmpty() || user.level().isClientSide()) {
            return;
        }
        boolean bl = edibleOrPotion = stack.getUseAnimation() == UseAnim.EAT || stack.getUseAnimation() == UseAnim.DRINK || stack.getItem() instanceof PotionItem;
        if (!edibleOrPotion) {
            return;
        }
        AtomicBoolean hasEffect = new AtomicBoolean(false);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchant, lvl) -> {
            if (((Enchantment)enchant.value()).effects().get((DataComponentType)ELIXIR_BURST_EFFECT.get()) != null) {
                hasEffect.set(true);
            }
        });
        if (!hasEffect.get()) {
            return;
        }
        DamageSource src = user.damageSources().magic();
        user.hurt(src, 100.0f);
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof ThrownPotion)) {
            return;
        }
        ThrownPotion potion = (ThrownPotion)projectile;
        ItemStack stack = potion.getItem();
        if (stack.isEmpty() || potion.level().isClientSide()) {
            return;
        }
        AtomicBoolean hasEffect = new AtomicBoolean(false);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchant, lvl) -> {
            if (((Enchantment)enchant.value()).effects().get((DataComponentType)ELIXIR_BURST_EFFECT.get()) != null) {
                hasEffect.set(true);
            }
        });
        if (!hasEffect.get()) {
            return;
        }
        Level level = potion.level();
        AABB aabb = new AABB(potion.getX() - 4.0, potion.getY() - 4.0, potion.getZ() - 4.0, potion.getX() + 4.0, potion.getY() + 4.0, potion.getZ() + 4.0);
        List list = level.getEntitiesOfClass(LivingEntity.class, aabb);
        for (LivingEntity target : list) {
            LivingEntity l;
            Entity entity;
            DamageSource src = level.damageSources().indirectMagic((Entity)potion, (entity = potion.getOwner()) instanceof LivingEntity ? (l = (LivingEntity)entity) : null);
            target.hurt(src, 100.0f);
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        boolean edible = stack.get(DataComponents.FOOD) != null;
        boolean isMilk = stack.is(Items.MILK_BUCKET);
        if (!edible && !isMilk) {
            return;
        }
        AtomicBoolean hasEffect = new AtomicBoolean(false);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchant, lvl) -> {
            if (((Enchantment)enchant.value()).effects().get((DataComponentType)ELIXIR_BURST_EFFECT.get()) != null) {
                hasEffect.set(true);
            }
        });
        if (!hasEffect.get()) {
            return;
        }
        event.getEntity().startUsingItem(event.getHand());
        event.setCancellationResult(InteractionResult.CONSUME);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onBottleEnchantOffhand(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack main = event.getItemStack();
        if (main.isEmpty() || !main.is((Item)GREEN_BOTTLE.get())) {
            return;
        }
        ItemStack off = player.getOffhandItem();
        if (off.isEmpty()) {
            return;
        }
        boolean edible = off.get(DataComponents.FOOD) != null;
        boolean isPotionBottle = off.getItem() instanceof PotionItem;
        boolean isSplash = off.is(Items.SPLASH_POTION);
        boolean isLingering = off.is(Items.LINGERING_POTION);
        if (!(edible || isPotionBottle || isSplash || isLingering)) {
            return;
        }
        AtomicBoolean alreadyHas = new AtomicBoolean(false);
        EnchantmentHelper.runIterationOnItem((ItemStack)off, (enchant, lvl) -> {
            if (((Enchantment)enchant.value()).effects().get((DataComponentType)ELIXIR_BURST_EFFECT.get()) != null) {
                alreadyHas.set(true);
            }
        });
        if (alreadyHas.get()) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (player.level().isClientSide()) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"elixir_burst"));
        Registry registry = player.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Optional opt = registry.getHolder(key);
        if (opt.isEmpty()) {
            return;
        }
        Holder.Reference holder = (Holder.Reference)opt.get();
        ItemStack result = off.copy();
        ItemEnchantments.Mutable out = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)result));
        out.set((Holder)holder, 1);
        EnchantmentHelper.setEnchantments((ItemStack)result, (ItemEnchantments)out.toImmutable());
        player.setItemInHand(InteractionHand.OFF_HAND, result);
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }
}

