/*
 * Decompiled with CFR 0.152.
 */
package com.ccbbc.cb_custom.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class GreenBottleItem
extends Item {
    public GreenBottleItem(Item.Properties properties) {
        super(properties);
    }

    public String getDescriptionId() {
        return "cb_custom.item.green_bottle";
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"item.cb_custom.green_bottle.desc1").withStyle(ChatFormatting.DARK_GREEN).withStyle(ChatFormatting.BOLD));
        tooltip.add((Component)Component.translatable((String)"item.cb_custom.green_bottle.desc2").withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.ITALIC));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        Block block = state.getBlock();
        if (block instanceof BonemealableBlock) {
            boolean grown;
            BonemealableBlock bonemealable = (BonemealableBlock)block;
            if (!level.isClientSide && (grown = this.forceMature(bonemealable, (ServerLevel)level, pos, state)) && context.getPlayer() != null) {
                context.getPlayer().gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                level.levelEvent(1505, pos, 15);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    private boolean forceMature(BonemealableBlock block, ServerLevel level, BlockPos pos, BlockState initial) {
        BonemealableBlock bm;
        Block block2;
        boolean changed = false;
        BlockState current = initial;
        int safety = 64;
        while (safety-- > 0 && (block2 = current.getBlock()) instanceof BonemealableBlock && (bm = (BonemealableBlock)block2).isValidBonemealTarget((LevelReader)level, pos, current)) {
            bm.performBonemeal(level, level.random, pos, current);
            current = level.getBlockState(pos);
            changed = true;
        }
        return changed;
    }
}

