/*
 * Decompiled with CFR 0.152.
 */
package yoflixxz.defaultpaper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class CombatLogPlugin
extends JavaPlugin
implements Listener {
    private final Map<UUID, Long> combatTimers = new HashMap<UUID, Long>();
    private final Map<UUID, UUID> combatOpponents = new HashMap<UUID, UUID>();
    private final Map<UUID, Boolean> combatMessageSent = new HashMap<UUID, Boolean>();
    private final Set<UUID> recentlyCombatLogged = new HashSet<UUID>();
    private List<String> blockedCommands;
    private List<String> blockedItems;
    private Map<String, Integer> worldTimers = new HashMap<String, Integer>();
    private int defaultCombatDuration;
    private boolean requireDamage;
    private String msgCombatEnter;
    private String msgCombatExit;
    private String msgCombatLog;
    private String msgCombatLogRejoin;
    private String msgCommandBlocked;
    private String msgItemBlocked;
    private String msgActionBar;
    private boolean showEnter;
    private boolean showExit;
    private boolean showLog;
    private boolean showLogRejoin;
    private boolean showCmdBlock;
    private boolean showItemBlock;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.startCombatTimerTask();
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.blockedCommands = config.getStringList("blocked-commands");
        this.blockedItems = config.getStringList("blocked-items");
        this.defaultCombatDuration = config.getInt("combat-duration", 20);
        this.requireDamage = config.getBoolean("require-damage", true);
        this.msgCombatEnter = this.color(config.getString("messages.combat-enter"));
        this.msgCombatExit = this.color(config.getString("messages.combat-exit"));
        this.msgCombatLog = this.color(config.getString("messages.combat-log"));
        this.msgCombatLogRejoin = this.color(config.getString("messages.combat-log-rejoin"));
        this.msgCommandBlocked = this.color(config.getString("messages.command-blocked"));
        this.msgItemBlocked = this.color(config.getString("messages.item-blocked"));
        this.msgActionBar = this.color(config.getString("messages.action-bar"));
        this.showEnter = config.getBoolean("messages.enable-combat-enter", true);
        this.showExit = config.getBoolean("messages.enable-combat-exit", true);
        this.showLog = config.getBoolean("messages.enable-combat-log", true);
        this.showLogRejoin = config.getBoolean("messages.enable-combat-log-rejoin", true);
        this.showCmdBlock = config.getBoolean("messages.enable-command-blocked", true);
        this.showItemBlock = config.getBoolean("messages.enable-item-blocked", true);
        if (config.isConfigurationSection("combat-timers")) {
            for (String world : config.getConfigurationSection("combat-timers").getKeys(false)) {
                this.worldTimers.put(world, config.getInt("combat-timers." + world));
            }
        }
    }

    private String color(String s) {
        return s == null ? "" : ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    private void startCombatTimerTask() {
        new BukkitRunnable(){

            public void run() {
                long now = System.currentTimeMillis();
                Iterator<Map.Entry<UUID, Long>> iter = CombatLogPlugin.this.combatTimers.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<UUID, Long> entry = iter.next();
                    UUID uuid = entry.getKey();
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    if (player == null || now >= entry.getValue()) {
                        if (player != null && CombatLogPlugin.this.showExit) {
                            player.sendMessage(CombatLogPlugin.this.msgCombatExit);
                            player.sendActionBar("");
                        }
                        CombatLogPlugin.this.combatOpponents.remove(uuid);
                        CombatLogPlugin.this.combatMessageSent.remove(uuid);
                        iter.remove();
                        continue;
                    }
                    int remaining = (int)((entry.getValue() - now) / 1000L) + 1;
                    if (player == null) continue;
                    player.sendActionBar(CombatLogPlugin.this.msgActionBar.replace("%time%", String.valueOf(remaining)));
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player attacker;
        Player victim;
        block9: {
            block10: {
                Player shooterPlayer;
                Entity entity;
                block8: {
                    Player p;
                    Entity entity2 = event.getEntity();
                    if (!(entity2 instanceof Player)) {
                        return;
                    }
                    victim = (Player)entity2;
                    attacker = null;
                    entity = event.getDamager();
                    if (!(entity instanceof Player)) break block8;
                    attacker = p = (Player)entity;
                    break block9;
                }
                entity = event.getDamager();
                if (!(entity instanceof Projectile)) break block10;
                Projectile projectile = (Projectile)entity;
                ProjectileSource shooter = projectile.getShooter();
                if (!(shooter instanceof Player)) break block9;
                attacker = shooterPlayer = (Player)shooter;
                break block9;
            }
            if (event.getDamager().getType() == EntityType.END_CRYSTAL) {
                for (Entity nearby : event.getDamager().getNearbyEntities(8.0, 8.0, 8.0)) {
                    Player p;
                    if (!(nearby instanceof Player)) continue;
                    attacker = p = (Player)nearby;
                    break;
                }
            }
        }
        if (attacker == null || attacker.equals((Object)victim)) {
            return;
        }
        if (!attacker.getWorld().getPVP()) {
            return;
        }
        if (this.requireDamage && !(event.getDamager() instanceof Player) && !(event.getDamager() instanceof Projectile) && event.getDamager().getType() != EntityType.END_CRYSTAL) {
            return;
        }
        String world = victim.getWorld().getName();
        int duration = this.worldTimers.getOrDefault(world, this.defaultCombatDuration);
        long expire = System.currentTimeMillis() + (long)duration * 1000L;
        this.combatTimers.put(victim.getUniqueId(), expire);
        this.combatTimers.put(attacker.getUniqueId(), expire);
        this.combatOpponents.put(victim.getUniqueId(), attacker.getUniqueId());
        this.combatOpponents.put(attacker.getUniqueId(), victim.getUniqueId());
        if (!this.combatMessageSent.getOrDefault(victim.getUniqueId(), false).booleanValue() && this.showEnter) {
            victim.sendMessage(this.msgCombatEnter.replace("%player%", attacker.getName()));
            this.combatMessageSent.put(victim.getUniqueId(), true);
        }
        if (!this.combatMessageSent.getOrDefault(attacker.getUniqueId(), false).booleanValue() && this.showEnter) {
            attacker.sendMessage(this.msgCombatEnter.replace("%player%", victim.getName()));
            this.combatMessageSent.put(attacker.getUniqueId(), true);
        }
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (!this.combatTimers.containsKey(player.getUniqueId())) {
            return;
        }
        String cmd = event.getMessage().split(" ")[0].toLowerCase();
        for (String blocked : this.blockedCommands) {
            if (!cmd.equalsIgnoreCase("/" + blocked)) continue;
            event.setCancelled(true);
            if (this.showCmdBlock) {
                player.sendMessage(this.msgCommandBlocked);
            }
            return;
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.combatTimers.containsKey(player.getUniqueId())) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        String name = item.getType().toString().toLowerCase();
        if (this.blockedItems.contains(name)) {
            event.setCancelled(true);
            if (this.showItemBlock) {
                player.sendMessage(this.msgItemBlocked);
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player opponent;
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!this.combatTimers.containsKey(uuid)) {
            return;
        }
        if (this.showLog) {
            Bukkit.broadcastMessage((String)this.msgCombatLog.replace("%player%", player.getName()));
        }
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            player.getWorld().dropItemNaturally(player.getLocation(), item);
        }
        player.getInventory().clear();
        player.setHealth(0.0);
        this.recentlyCombatLogged.add(uuid);
        UUID opponentId = this.combatOpponents.remove(uuid);
        if (opponentId != null && (opponent = Bukkit.getPlayer((UUID)opponentId)) != null) {
            this.combatTimers.remove(opponentId);
            this.combatMessageSent.remove(opponentId);
            if (this.showExit) {
                opponent.sendMessage(this.msgCombatExit);
                opponent.sendActionBar("");
            }
        }
        this.combatTimers.remove(uuid);
        this.combatMessageSent.remove(uuid);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.recentlyCombatLogged.remove(player.getUniqueId()) && this.showLogRejoin) {
            player.sendMessage(this.msgCombatLogRejoin);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player opponent;
        Player player = event.getEntity();
        UUID uuid = player.getUniqueId();
        if (!this.combatTimers.containsKey(uuid)) {
            return;
        }
        UUID opponentId = this.combatOpponents.remove(uuid);
        if (opponentId != null && (opponent = Bukkit.getPlayer((UUID)opponentId)) != null) {
            this.combatTimers.remove(opponentId);
            this.combatMessageSent.remove(opponentId);
            if (this.showExit) {
                opponent.sendMessage(this.msgCombatExit);
                opponent.sendActionBar("");
            }
        }
        this.combatTimers.remove(uuid);
        this.combatMessageSent.remove(uuid);
    }
}

