/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.mixin;

import com.github.tartaricacid.netmusic.client.gui.CDBurnerMenuScreen;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.network.NetworkHandler;
import com.github.tartaricacid.netmusic.network.message.SetMusicIDMessage;
import com.gly091020.util.NetMusicListUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CDBurnerMenuScreen.class}, remap=false)
public class BurnerSongListMixin {
    @Shadow
    private EditBox textField;
    @Shadow
    private Component tips;
    @Shadow
    private Checkbox readOnlyButton;
    @Unique
    private static final Pattern LIST_ID_REG = Pattern.compile("^list/(\\d+)$");

    @Inject(method={"handleCraftButton"}, at={@At(value="INVOKE", target="Ljava/util/regex/Matcher;matches()Z")}, cancellable=true)
    public void onCraft(CallbackInfo ci) {
        Matcher matcher = LIST_ID_REG.matcher(this.textField.m_94155_());
        if (matcher.find()) {
            long listID = Long.parseLong(matcher.group(1));
            try {
                List<ItemMusicCD.SongInfo> songs = NetMusicListUtil.getMusicList(listID);
                if (!songs.isEmpty()) {
                    for (ItemMusicCD.SongInfo info : songs) {
                        info.readOnly = this.readOnlyButton.m_93840_();
                        NetworkHandler.CHANNEL.sendToServer((Object)new SetMusicIDMessage(info));
                    }
                }
            }
            catch (Exception e) {
                this.tips = Component.m_237115_((String)"gui.netmusic.cd_burner.get_info_error");
            }
            ci.cancel();
        }
    }
}

