/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.block;

import com.github.tartaricacid.netmusic.block.BlockMusicPlayer;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.gly091020.block.EnderMusicPlayerEntity;
import com.gly091020.util.NetMusicListUtil;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderMusicPlayer
extends BlockMusicPlayer {
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnderMusicPlayerEntity(pos, state);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity = worldIn.m_7702_(pos);
        if (!(entity instanceof EnderMusicPlayerEntity)) {
            return InteractionResult.PASS;
        }
        EnderMusicPlayerEntity enderMusicPlayer = (EnderMusicPlayerEntity)entity;
        if (playerIn.m_6144_() && !enderMusicPlayer.isPlay()) {
            if (worldIn.f_46443_) {
                playerIn.m_216990_(SoundEvents.f_11871_);
                return InteractionResult.SUCCESS;
            }
            UUID uuid = playerIn.m_20148_();
            if (enderMusicPlayer.hasPlayer(uuid)) {
                enderMusicPlayer.removePlayer(uuid);
                playerIn.m_213846_((Component)Component.m_237110_((String)"block.net_music_list.ender_music_player.remove_player", (Object[])new Object[]{playerIn.m_5446_()}));
            } else {
                playerIn.m_213846_((Component)Component.m_237110_((String)"block.net_music_list.ender_music_player.add_player", (Object[])new Object[]{playerIn.m_5446_()}));
                enderMusicPlayer.addPlayer(uuid);
            }
            return InteractionResult.SUCCESS;
        }
        ItemStackHandler handler = enderMusicPlayer.getPlayerInv();
        if (!handler.getStackInSlot(0).m_41619_()) {
            ItemStack extract = handler.extractItem(0, 1, false);
            EnderMusicPlayer.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)extract);
            enderMusicPlayer.markDirty();
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = playerIn.m_21205_();
        ItemMusicCD.SongInfo info = ItemMusicCD.getSongInfo((ItemStack)stack);
        if (info == null) {
            return InteractionResult.PASS;
        }
        if (!NetMusicListUtil.hasLoginNeed() && info.vip) {
            if (worldIn.f_46443_) {
                playerIn.m_213846_((Component)Component.m_237115_((String)"message.netmusic.music_player.need_vip").m_130940_(ChatFormatting.RED));
            }
            return InteractionResult.FAIL;
        }
        handler.insertItem(0, stack.m_41777_(), false);
        if (!playerIn.m_7500_()) {
            stack.m_41774_(1);
        }
        enderMusicPlayer.setPlayToClient(info);
        enderMusicPlayer.markDirty();
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        EnderMusicPlayerEntity musicPlayer;
        ItemStack stack;
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof EnderMusicPlayerEntity && !(stack = (musicPlayer = (EnderMusicPlayerEntity)te).getPlayerInv().getStackInSlot(0)).m_41619_()) {
            Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)stack);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }
}

