/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.packet;

import com.github.tartaricacid.netmusic.client.audio.MusicPlayManager;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.gly091020.NetMusicList;
import com.gly091020.hud.MusicInfoHud;
import com.gly091020.item.NetMusicPlayerItem;
import com.gly091020.packet.PlayEnderMusicPlayerPacket;
import com.gly091020.packet.PlayerPlayMusicPacket;
import com.gly091020.sounds.EnderPlayerNetMusicSound;
import com.gly091020.sounds.PlayerNetMusicSound;
import com.gly091020.util.LoginNeedUtil;
import com.gly091020.util.NetMusicListUtil;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ClientHandler {
    public static void handleClientPlayerPlayPacket(PlayerPlayMusicPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context c = ctx.get();
        if (c.getDirection().getReceptionSide().isClient()) {
            c.enqueueWork(() -> CompletableFuture.runAsync(() -> {
                Entity p;
                if (Minecraft.m_91087_().f_91073_ != null && (p = Minecraft.m_91087_().f_91073_.m_6815_(packet.playerID())) instanceof Player) {
                    ItemStack stack1;
                    ItemStack stack;
                    String url1;
                    Player player = (Player)p;
                    String finalUrl = packet.url();
                    if (NetMusicListUtil.hasLoginNeed() && (url1 = LoginNeedUtil.getUrl(finalUrl)) != null) {
                        finalUrl = url1;
                    }
                    MusicPlayManager.play((String)finalUrl, (String)packet.songName(), url -> new PlayerNetMusicSound(player, (URL)url, packet.timeSecond(), packet.slot()));
                    if (player == Minecraft.m_91087_().f_91074_ && (stack = player.m_150109_().m_8020_(packet.slot())).m_150930_((Item)NetMusicList.MUSIC_PLAYER_ITEM.get()) && (stack1 = NetMusicPlayerItem.getContainer(stack).m_8020_(0)).m_41720_() instanceof ItemMusicCD) {
                        MusicInfoHud.setInfo(packet.info(), stack, packet.slot());
                    }
                }
            }, Util.m_183991_()));
        } else {
            NetMusicList.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
        }
        c.setPacketHandled(true);
    }

    public static void handleClientEnderPlayerPlayPacket(PlayEnderMusicPlayerPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context c = ctx.get();
        if (c.getDirection().getReceptionSide().isClient()) {
            c.enqueueWork(() -> CompletableFuture.runAsync(() -> {
                String url1;
                String finalUrl = packet.url;
                if (NetMusicListUtil.hasLoginNeed() && (url1 = LoginNeedUtil.getUrl(finalUrl)) != null) {
                    finalUrl = url1;
                }
                MusicPlayManager.play((String)finalUrl, (String)packet.songName, url -> new EnderPlayerNetMusicSound(packet.pos, (URL)url, packet.timeSecond));
            }));
        }
    }
}

