/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.sounds;

import com.github.tartaricacid.netmusic.client.audio.NetMusicAudioStream;
import com.github.tartaricacid.netmusic.init.InitSounds;
import com.gly091020.NetMusicList;
import com.gly091020.block.EnderMusicPlayerEntity;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class EnderPlayerNetMusicSound
extends AbstractTickableSoundInstance {
    final BlockPos pos;
    final URL url;
    final int countTick;
    int tick = 0;

    public EnderPlayerNetMusicSound(BlockPos pos, URL songUrl, int second) {
        super((SoundEvent)InitSounds.NET_MUSIC.get(), SoundSource.RECORDS, SoundInstance.m_235150_());
        this.pos = pos;
        this.url = songUrl;
        this.countTick = second * 20;
        this.f_119573_ = 4.0f;
        this.f_119575_ = (float)pos.m_123341_() + 0.5f;
        this.f_119576_ = (float)pos.m_123342_() + 0.5f;
        this.f_119577_ = (float)pos.m_123343_() + 0.5f;
    }

    public void m_7788_() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            this.m_119609_();
            return;
        }
        ++this.tick;
        if (this.tick > this.countTick + 50) {
            this.m_119609_();
        } else if (world.m_46467_() % 8L == 0L) {
            for (int i = 0; i < 2; ++i) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.f_119575_ - 0.5 + world.f_46441_.m_188500_(), this.f_119576_ + world.f_46441_.m_188500_() + 1.0, this.f_119577_ - 0.5 + world.f_46441_.m_188500_(), world.f_46441_.m_188583_(), world.f_46441_.m_188583_(), (double)world.f_46441_.m_188503_(3));
            }
        }
        BlockEntity te = world.m_7702_(this.pos);
        if (te instanceof EnderMusicPlayerEntity) {
            EnderMusicPlayerEntity musicPlay = (EnderMusicPlayerEntity)te;
            if (!musicPlay.isPlay()) {
                this.m_119609_();
            }
        } else {
            this.m_119609_();
        }
    }

    @NotNull
    public CompletableFuture<AudioStream> getStream(@NotNull SoundBufferLibrary soundBuffers, @NotNull Sound sound, boolean looping) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return new NetMusicAudioStream(this.url);
            }
            catch (IOException | UnsupportedAudioFileException e) {
                NetMusicList.LOGGER.error("\u51fa\u73b0\u9519\u8bef\uff1a", (Throwable)e);
                return null;
            }
        }, Util.m_183991_());
    }

    @NotNull
    public SoundInstance.Attenuation m_7438_() {
        return SoundInstance.Attenuation.NONE;
    }
}

