/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.hud;

import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.gly091020.NetMusicList;
import com.gly091020.item.NetMusicListItem;
import com.gly091020.item.NetMusicPlayerItem;
import com.gly091020.util.NetMusicListKeyMapping;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class MusicListLayer {
    public static boolean isRender = false;
    public static int index = -1;
    public static int count = 0;

    public static void render(@NotNull GuiGraphics guiGraphics) {
        if (!isRender) {
            index = -1;
            return;
        }
        if (Minecraft.m_91087_().f_91066_.f_92062_) {
            return;
        }
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p == null) {
            return;
        }
        ItemStack i = p.m_21205_();
        if (!i.m_150930_((Item)NetMusicList.MUSIC_PLAYER_ITEM.get())) {
            isRender = false;
            return;
        }
        ItemStack disc = NetMusicPlayerItem.getContainer(i).m_8020_(0);
        if (!disc.m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get())) {
            isRender = false;
            return;
        }
        Integer m = NetMusicListItem.getSongIndex(disc);
        if (index == -1) {
            index = m;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        int height = Minecraft.m_91087_().m_91268_().m_85446_();
        List<ItemMusicCD.SongInfo> songList = NetMusicListItem.getSongInfoList(disc);
        PoseStack pose = guiGraphics.m_280168_();
        int length = NetMusicList.CONFIG.selectHudCount;
        pose.m_85836_();
        float scale = NetMusicList.CONFIG.selectHudSize;
        count = songList.size();
        if (m.intValue() == songList.size()) {
            isRender = false;
            return;
        }
        RenderSystem.enableBlend();
        List<Integer> indexList = MusicListLayer.getIndexList(index, length, count, false);
        int margin = 2;
        float selectedSize = 1.3f;
        int n = indexList.size() - 1;
        Objects.requireNonNull(font);
        float f = n * (9 + margin);
        Objects.requireNonNull(font);
        float totalHeight = f + 9.0f * selectedSize;
        pose.m_252880_((float)(width - 5), (float)height / 2.0f, 0.0f);
        pose.m_85841_(scale, scale, 1.0f);
        pose.m_252880_(0.0f, -totalHeight / 2.0f, 0.0f);
        float y = 0.0f;
        float b = 0.45f;
        float v = (float)(1.0 / Math.pow(7.3890560989306495 * (double)b, 1.0 / (1.0 - Math.ceil((float)length / 2.0f))));
        for (Integer listIndex : indexList) {
            if (listIndex != null) {
                ItemMusicCD.SongInfo songInfo = songList.get(listIndex);
                String name = MusicListLayer.getMusicText(songInfo);
                MutableComponent text = Component.m_237113_((String)name);
                if (songInfo.vip) {
                    text.m_7220_((Component)Component.m_237113_((String)" [VIP]").m_130940_(ChatFormatting.RED));
                }
                int textWidth = font.m_92852_((FormattedText)text);
                pose.m_85836_();
                if (listIndex == index) {
                    pose.m_252880_(-((float)textWidth * selectedSize + 4.0f), y, 0.0f);
                    pose.m_85841_(selectedSize, selectedSize, 1.0f);
                    MusicListLayer.drawString(guiGraphics, font, text, 0, 0, -1);
                    Objects.requireNonNull(font);
                    y += 9.0f * selectedSize + (float)margin;
                } else {
                    float alpha = (float)((double)b * Math.pow(v, -Math.abs(listIndex - index) + 1));
                    pose.m_252880_((float)(-(textWidth + 4)), y, 0.0f);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                    MusicListLayer.drawString(guiGraphics, font, text, 0, 0, 0xFFFFFF);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Objects.requireNonNull(font);
                    y += (float)(9 + margin);
                }
                pose.m_85849_();
                continue;
            }
            Objects.requireNonNull(font);
            y += (float)(9 + margin);
        }
        RenderSystem.disableBlend();
        pose.m_85849_();
    }

    private static void drawString(GuiGraphics guiGraphics, Font font, MutableComponent text, int x, int y, int color) {
        if (NetMusicList.CONFIG.glowingText) {
            int glowColor = -16777216;
            Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
            MultiBufferSource.BufferSource bufferSource = guiGraphics.m_280091_();
            font.m_168645_(text.m_7532_(), (float)x, (float)y, color, -16777216, matrix, (MultiBufferSource)bufferSource, 0xF000F0);
        }
        guiGraphics.m_280614_(font, (Component)text, x, y, color, !NetMusicList.CONFIG.glowingText);
    }

    private static String getMusicText(ItemMusicCD.SongInfo info) {
        if (!NetMusicList.CONFIG.selectHudShowArtist) {
            return NetMusicListKeyMapping.TOGGLE_MUSIC_TRANSFORM.m_90857_() ? MusicListLayer.getTransName(info) : info.songName;
        }
        StringBuilder artists = new StringBuilder();
        if (info.artists != null && !info.artists.isEmpty()) {
            artists.append("\u2014\u2014");
            String join = String.join((CharSequence)", ", info.artists);
            artists.append(join);
        }
        return (NetMusicListKeyMapping.TOGGLE_MUSIC_TRANSFORM.m_90857_() ? MusicListLayer.getTransName(info) : info.songName) + String.valueOf(artists);
    }

    private static String getTransName(ItemMusicCD.SongInfo info) {
        if (info.transName.isEmpty()) {
            return info.songName;
        }
        return info.transName;
    }

    private static List<Integer> getIndexList(int current, int length, int total, boolean loop) {
        if (current < 0 || current > total - 1) {
            return IntStream.range(0, length).mapToObj(i -> null).toList();
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int half = length / 2;
        for (int i2 = -half; i2 <= half; ++i2) {
            int idx = current + i2;
            if (loop) {
                idx = (idx + total) % total;
            } else if (idx < 0 || idx >= total) {
                indexList.add(null);
                continue;
            }
            indexList.add(idx);
        }
        return indexList;
    }
}

