/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.util;

import com.github.tartaricacid.netmusic.NetMusic;
import com.gly091020.NetMusicList;
import com.gly091020.util.FileDownloadThread;
import com.gly091020.util.LoginNeedUtil;
import com.gly091020.util.NetMusicListUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class CacheManager {
    private static Map<String, String> musicCache = new HashMap<String, String>();
    private static final Gson GSON = new Gson();
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(5);
    public static final String DIR_NAME = "netMusicListCache";
    public static final String INDEX_FILE_NAME = "index.json";
    public static final Path PATH = FMLPaths.CONFIGDIR.get().resolve("netMusicListCache");
    public static final List<FileDownloadThread> threads = new ArrayList<FileDownloadThread>();

    public static void init() {
        if (!NetMusicList.CONFIG.enableCache) {
            return;
        }
        try {
            if (PATH.toFile().isFile()) {
                Files.createDirectory(PATH, new FileAttribute[0]);
            }
            Files.writeString(PATH.resolve(INDEX_FILE_NAME), (CharSequence)"{}", new OpenOption[0]);
        }
        catch (IOException e) {
            NetMusicList.LOGGER.error("\u7f13\u5b58\u65e0\u6cd5\u521b\u5efa\uff1a", (Throwable)e);
        }
    }

    public static void load() {
        if (!NetMusicList.CONFIG.enableCache) {
            return;
        }
        try {
            musicCache = (Map)GSON.fromJson(Files.readString(PATH.resolve(INDEX_FILE_NAME)), TypeToken.get(Object.class));
            if (!CacheManager.checkCache()) {
                CacheManager.save();
            }
        }
        catch (Exception e) {
            NetMusicList.LOGGER.error("\u7f13\u5b58\u8bfb\u53d6\u5931\u8d25\uff1a", (Throwable)e);
            CacheManager.init();
        }
    }

    public static void save() {
        if (!NetMusicList.CONFIG.enableCache) {
            return;
        }
        try {
            Files.writeString(PATH.resolve(INDEX_FILE_NAME), (CharSequence)GSON.toJson(musicCache), new OpenOption[0]);
        }
        catch (Exception e) {
            NetMusicList.LOGGER.error("\u7f13\u5b58\u5199\u5165\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public static boolean checkCache() {
        if (!NetMusicList.CONFIG.enableCache) {
            return true;
        }
        ArrayList<String> keys = new ArrayList<String>();
        musicCache.forEach((k, v) -> {
            if (!PATH.resolve(v + ".mp3").toFile().isFile()) {
                keys.add((String)k);
            }
        });
        keys.forEach(l -> musicCache.remove(l));
        return keys.isEmpty();
    }

    private static void startDownload(String downloadUrl, long resourceId, String fileType, String uuid) {
        if (!NetMusicList.CONFIG.enableCache) {
            return;
        }
        FileDownloadThread thread = new FileDownloadThread(downloadUrl, resourceId, fileType, uuid);
        EXECUTOR_SERVICE.submit(thread);
        threads.add(thread);
    }

    public static void startImgDownload(long resourceId, String uuid) {
        if (!NetMusicList.CONFIG.enableCache) {
            return;
        }
        EXECUTOR_SERVICE.submit(() -> {
            try {
                CacheManager.startDownload(NetMusicListUtil.getIconUrl(NetMusic.NET_EASE_WEB_API.song(resourceId)).toString(), resourceId, ".png", uuid);
            }
            catch (Exception e) {
                NetMusicList.LOGGER.error("\u51fa\u73b0\u9519\u8bef\uff1a", (Throwable)e);
            }
        });
    }

    public static void startSongDownload(long resourceId, String uuid) {
        if (!NetMusicList.CONFIG.enableCache) {
            return;
        }
        EXECUTOR_SERVICE.submit(() -> {
            try {
                CacheManager.startDownload(CacheManager.pasteUrl(resourceId), resourceId, ".mp3", uuid);
            }
            catch (Exception e) {
                NetMusicList.LOGGER.error("\u51fa\u73b0\u9519\u8bef\uff1a", (Throwable)e);
            }
        });
    }

    public static void startLycDownload(long resourceId, String uuid) {
        if (!NetMusicList.CONFIG.enableCache) {
            return;
        }
        EXECUTOR_SERVICE.submit(() -> {
            try {
                NetMusicListUtil.Lyric lyc = NetMusicListUtil.getLyric(NetMusic.NET_EASE_WEB_API.lyric(resourceId));
                if (lyc == null) {
                    return;
                }
                Files.writeString(PATH.resolve(uuid + ".lyc.json"), (CharSequence)lyc.toJson(), new OpenOption[0]);
            }
            catch (Exception e) {
                NetMusicList.LOGGER.error("\u51fa\u73b0\u9519\u8bef\uff1a", (Throwable)e);
            }
        });
    }

    public static String pasteUrl(long resourceId) {
        String r;
        if (NetMusicListUtil.hasLoginNeed() && (r = LoginNeedUtil.getUrl("?id=" + resourceId)) != null) {
            return r;
        }
        try {
            return NetMusicListUtil.resolveRedirect(new URL(String.format("https://music.163.com/song/media/outer/url?id=%s.mp3", resourceId)), 3, Map.of()).toString();
        }
        catch (IOException e) {
            return String.format("https://music.163.com/song/media/outer/url?id=%s.mp3", resourceId);
        }
    }

    private static void addCache(long resourceId, String uuid) {
        if (!NetMusicList.CONFIG.enableCache) {
            return;
        }
        musicCache.put(String.valueOf(resourceId), uuid);
        CacheManager.save();
    }

    public static boolean hasCache(long resourceId) {
        if (!NetMusicList.CONFIG.enableCache) {
            return false;
        }
        return musicCache.containsKey(String.valueOf(resourceId));
    }

    public static Path getImageCache(long resourceId) {
        if (!NetMusicList.CONFIG.enableCache) {
            return null;
        }
        if (!CacheManager.hasCache(resourceId)) {
            return null;
        }
        Path path = PATH.resolve(musicCache.get(String.valueOf(resourceId)) + ".png");
        if (path.toFile().isFile()) {
            return path;
        }
        return null;
    }

    public static String getSongCache(long resourceId) {
        if (!NetMusicList.CONFIG.enableCache) {
            return null;
        }
        if (!CacheManager.hasCache(resourceId)) {
            return null;
        }
        Path path = PATH.resolve(musicCache.get(String.valueOf(resourceId)) + ".mp3");
        if (path.toFile().isFile()) {
            return path.toFile().toURI().toString();
        }
        return null;
    }

    public static NetMusicListUtil.Lyric getLycCache(long resourceId) {
        if (!NetMusicList.CONFIG.enableCache) {
            return null;
        }
        if (!CacheManager.hasCache(resourceId)) {
            return null;
        }
        Path path = PATH.resolve(musicCache.get(String.valueOf(resourceId)) + ".lyc.json");
        if (path.toFile().isFile()) {
            try {
                return NetMusicListUtil.Lyric.fromJson(Files.readString(path));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static void tick() {
        if (!NetMusicList.CONFIG.enableCache) {
            return;
        }
        Iterator<FileDownloadThread> iterator = threads.iterator();
        while (iterator.hasNext()) {
            FileDownloadThread t = iterator.next();
            if (t.isCompleted() && Objects.equals(t.getFileType(), ".mp3")) {
                CacheManager.addCache(t.getResourceId(), t.getThreadId());
                iterator.remove();
                continue;
            }
            if (!t.isFailed()) continue;
            NetMusicList.LOGGER.error("\u7f13\u5b58\u51fa\u73b0\u9519\u8bef\uff1a{}", (Object)t.getErrorMessage());
            iterator.remove();
        }
    }

    public static float getDownloadProgress(long resourceId) {
        if (!NetMusicList.CONFIG.enableCache) {
            return 0.0f;
        }
        for (FileDownloadThread thread : threads) {
            if (thread.getResourceId() != resourceId || !Objects.equals(thread.getFileType(), ".mp3")) continue;
            return thread.getProgress();
        }
        return 0.0f;
    }
}

