/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.util;

import com.gly091020.util.CacheManager;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class FileDownloadThread
extends Thread {
    private final String downloadUrl;
    private final long resourceId;
    private final String threadId;
    private final Path downloadDir;
    private final String fileType;
    private volatile float progress = 0.0f;
    private volatile long totalBytes = 0L;
    private volatile long downloadedBytes = 0L;
    private volatile boolean completed = false;
    private volatile boolean failed = false;
    private volatile String errorMessage = "";

    public FileDownloadThread(String downloadUrl, long resourceId, String fileType, String id) {
        this.downloadUrl = downloadUrl;
        this.resourceId = resourceId;
        this.threadId = id;
        this.downloadDir = CacheManager.PATH;
        this.fileType = fileType;
        this.setName("DownloadThread-" + this.threadId);
    }

    @Override
    public void run() {
        try {
            Files.createDirectories(this.downloadDir, new FileAttribute[0]);
            String fileName = this.threadId + this.fileType + ".tmp";
            Path filePath = this.downloadDir.resolve(fileName);
            URL url = new URL(this.downloadUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(30000);
            this.totalBytes = connection.getContentLengthLong();
            try (InputStream inputStream = connection.getInputStream();
                 FileOutputStream outputStream = new FileOutputStream(filePath.toFile());){
                int bytesRead;
                if (connection.getResponseCode() == 404) {
                    throw new Exception("404 not found");
                }
                byte[] buffer = new byte[8192];
                long totalRead = 0L;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    if (this.isInterrupted()) {
                        Files.deleteIfExists(filePath);
                        return;
                    }
                    outputStream.write(buffer, 0, bytesRead);
                    this.downloadedBytes = totalRead += (long)bytesRead;
                    if (this.totalBytes <= 0L) continue;
                    this.progress = (float)totalRead / (float)this.totalBytes;
                }
            }
            Thread.sleep(100L);
            String finalFileName = this.threadId + this.fileType;
            Path finalPath = this.downloadDir.resolve(finalFileName);
            Files.move(filePath, finalPath, new CopyOption[0]);
            this.completed = true;
        }
        catch (Exception e) {
            this.failed = true;
            this.errorMessage = e.getMessage();
        }
    }

    public float getProgress() {
        return this.progress;
    }

    public long getDownloadedBytes() {
        return this.downloadedBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public long getResourceId() {
        return this.resourceId;
    }

    public String getFileType() {
        return this.fileType;
    }
}

