/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.packet;

import com.gly091020.NetMusicList;
import com.gly091020.item.MusicPlayerContainer;
import com.gly091020.item.NetMusicListItem;
import com.gly091020.item.NetMusicPlayerItem;
import com.gly091020.packet.DeleteMusicDataPacket;
import com.gly091020.packet.MoveMusicDataPacket;
import com.gly091020.packet.MusicListDataPacket;
import com.gly091020.packet.PlayerPlayMusicPacket;
import com.gly091020.packet.UpdateMusicTickCTSPacket;
import com.gly091020.packet.UpdatePlayerMusicPacket;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ServerHandler {
    public static void handleServerMusicListDataPacket(MusicListDataPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (stack = player.m_21205_()).m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get())) {
                NetMusicListItem.setSongIndex(stack, packet.index());
                NetMusicListItem.setPlayMode(stack, packet.playMode());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handleServerDeleteMusicDataPacket(DeleteMusicDataPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (stack = player.m_21205_()).m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get())) {
                NetMusicListItem.deleteSong(stack, packet.index());
            }
        });
    }

    public static void handleServerMoveMusicDataPacket(MoveMusicDataPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (stack = player.m_21205_()).m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get())) {
                NetMusicListItem.moveSong(stack, packet.fromIndex(), packet.toIndex());
            }
        });
    }

    public static void handleServerPlayerPlayPacket(PlayerPlayMusicPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            return;
        }
        NetMusicList.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public static void handleServerUpdateMusicPacket(UpdatePlayerMusicPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_150109_().m_8020_(packet.slot());
        if (stack.m_150930_((Item)NetMusicList.MUSIC_PLAYER_ITEM.get())) {
            MusicPlayerContainer container = new MusicPlayerContainer(stack);
            ItemStack stack1 = container.m_8020_(0);
            NetMusicListItem.setSongIndex(stack1, packet.index());
            container.m_6836_(0, stack1);
            NetMusicPlayerItem.playSound(stack, (Player)player, packet.slot());
        }
    }

    public static void handlePlayerUpdateTickPacket(UpdateMusicTickCTSPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_150109_().m_8020_(packet.slot());
        if (stack.m_150930_((Item)NetMusicList.MUSIC_PLAYER_ITEM.get())) {
            stack.m_41784_().m_128405_("tick", packet.tick());
        }
    }
}

