/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.util;

import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.gly091020.NetMusicList;
import com.gly091020.client.PauseSoundManager;
import com.gly091020.config.NetMusicListConfig;
import com.gly091020.mixin.TickableSoundGetterMixins;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import oshi.util.tuples.Pair;

public class NetMusicListUtil {
    public static final Gson GSON = new Gson();
    public static final UUID _5112151111121 = UUID.fromString("91bd580f-5f17-4e30-872f-2e480dd9a220");
    public static final UUID N44 = UUID.fromString("5a33e9b0-35bc-44ed-9b4e-03e3e180a3d2");
    public static boolean globalStopMusic = false;

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(SoundEvent event) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)event, (float)1.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static long getIdFromInfo(ItemMusicCD.SongInfo info) throws IllegalAccessException {
        String s = info.songUrl;
        String[] parts = s.split("[?&]id=");
        if (parts.length <= 1) {
            throw new IllegalAccessException("\u89e3\u6790\u5931\u8d25");
        }
        String idPart = parts[1].split("&")[0];
        return Long.parseLong(idPart.replace(".mp3", ""));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static URL getIconUrl(String json) throws Exception {
        Map data = (Map)GSON.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
        Map song = (Map)((List)data.get("songs")).get(0);
        Object album = song.get("album");
        return new URL((String)((Map)album).get("picUrl"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static AbstractTexture getTextureFromURL(URL imageUrl) throws IOException {
        try (InputStream stream = imageUrl.openConnection().getInputStream();){
            BufferedImage bufferedImage = ImageIO.read(stream);
            if (bufferedImage == null) {
                throw new IOException("\u65e0\u6cd5\u8bfb\u53d6\u56fe\u7247 - \u4e0d\u652f\u6301\u7684\u683c\u5f0f\u6216\u635f\u574f\u7684\u6587\u4ef6");
            }
            NativeImage nativeImage = new NativeImage(bufferedImage.getWidth(), bufferedImage.getHeight(), false);
            for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                for (int x = 0; x < bufferedImage.getWidth(); ++x) {
                    int argb = bufferedImage.getRGB(x, y);
                    int a = argb >> 24 & 0xFF;
                    int r = argb >> 16 & 0xFF;
                    int g = argb >> 8 & 0xFF;
                    int b = argb & 0xFF;
                    int rgba = a << 24 | b << 16 | g << 8 | r;
                    nativeImage.m_84988_(x, y, rgba | 0xFF000000);
                }
            }
            DynamicTexture dynamicTexture = new DynamicTexture(nativeImage);
            return dynamicTexture;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static AbstractTexture getTextureFromPath(Path imagePath) throws IOException {
        try (InputStream stream = Files.newInputStream(imagePath, new OpenOption[0]);){
            BufferedImage bufferedImage = ImageIO.read(stream);
            if (bufferedImage == null) {
                throw new IOException("\u65e0\u6cd5\u8bfb\u53d6\u56fe\u7247 - \u4e0d\u652f\u6301\u7684\u683c\u5f0f\u6216\u635f\u574f\u7684\u6587\u4ef6");
            }
            NativeImage nativeImage = new NativeImage(bufferedImage.getWidth(), bufferedImage.getHeight(), false);
            for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                for (int x = 0; x < bufferedImage.getWidth(); ++x) {
                    int argb = bufferedImage.getRGB(x, y);
                    int a = argb >> 24 & 0xFF;
                    int r = argb >> 16 & 0xFF;
                    int g = argb >> 8 & 0xFF;
                    int b = argb & 0xFF;
                    int rgba = a << 24 | b << 16 | g << 8 | r;
                    nativeImage.m_84988_(x, y, rgba | 0xFF000000);
                }
            }
            DynamicTexture dynamicTexture = new DynamicTexture(nativeImage);
            return dynamicTexture;
        }
    }

    public static String secondsToMinutesSeconds(int totalSeconds) {
        if (totalSeconds < 0) {
            return "00:00";
        }
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    public static Lyric getLyric(String json) {
        Pair<Float, String> p;
        Map data = (Map)GSON.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
        String lrc = (String)((Map)data.get("lrc")).get("lyric");
        String transformlLrc = "";
        if (data.containsKey("tlyric")) {
            transformlLrc = (String)((Map)data.get("tlyric")).get("lyric");
        }
        if (lrc.isEmpty()) {
            return null;
        }
        LinkedHashMap<Float, String> transformLyricMap = null;
        if (!transformlLrc.isEmpty()) {
            transformLyricMap = new LinkedHashMap<Float, String>();
            for (String part : transformlLrc.split("\n")) {
                p = NetMusicListUtil.getLyricPair(part);
                if (p == null) continue;
                transformLyricMap.put((Float)p.getA(), (String)p.getB());
            }
        }
        LinkedHashMap<Float, String> lyricMap = new LinkedHashMap<Float, String>();
        for (String part : lrc.split("\n")) {
            p = NetMusicListUtil.getLyricPair(part);
            if (p == null) continue;
            lyricMap.put((Float)p.getA(), (String)p.getB());
        }
        return new Lyric(lyricMap, transformLyricMap);
    }

    private static Pair<Float, String> getLyricPair(String input) {
        Pattern pattern = Pattern.compile("^\\[(\\d+):(\\d+)[.:](\\d+)](.*)$");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            int minutes = Integer.parseInt(matcher.group(1));
            int seconds = Integer.parseInt(matcher.group(2));
            int milliseconds = Integer.parseInt(matcher.group(3));
            String text = matcher.group(4);
            float totalSeconds = (float)(minutes * 60 + seconds) + (float)milliseconds / 1000.0f;
            return new Pair((Object)Float.valueOf(totalSeconds), (Object)text.trim());
        }
        return null;
    }

    public static boolean isGLY() {
        return Objects.equals(Minecraft.m_91087_().m_91094_().m_240411_(), _5112151111121);
    }

    public static boolean isN44() {
        return Objects.equals(Minecraft.m_91087_().m_91094_().m_240411_(), N44);
    }

    public static List<TickableSoundInstance> getTickableSounds() {
        return ((TickableSoundGetterMixins.SoundEngineMixin)((TickableSoundGetterMixins.SoundManagerMixin)Minecraft.m_91087_().m_91106_()).getSoundEngine()).getTickableSoundInstances();
    }

    public static void reloadConfig() {
        ConfigHolder holder = AutoConfig.getConfigHolder(NetMusicListConfig.class);
        holder.setConfig((ConfigData)NetMusicList.CONFIG);
        holder.save();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isPaused() {
        return ((PauseSoundManager)Minecraft.m_91087_().m_91106_()).isPaused();
    }

    public static class Lyric {
        private final Map<Float, String> lyric;
        private final Map<Float, String> transformLyric;

        public Lyric(Map<Float, String> lyric, @Nullable Map<Float, String> transformLyric) {
            this.lyric = lyric;
            this.transformLyric = transformLyric;
        }

        public Pair<String, String> getLyric(float second) {
            List keyList = this.lyric.keySet().stream().toList();
            List<String> valueList = this.lyric.values().stream().toList();
            String text = "";
            float lyricTime = 0.0f;
            String transformText = null;
            for (int i = 0; i < this.lyric.size(); ++i) {
                if (i == this.lyric.size() - 1) {
                    text = valueList.get(i);
                    lyricTime = ((Float)keyList.get(i)).floatValue();
                    break;
                }
                if (!(((Float)keyList.get(i)).floatValue() <= second) || !(((Float)keyList.get(i + 1)).floatValue() > second)) continue;
                text = valueList.get(i);
                lyricTime = ((Float)keyList.get(i)).floatValue();
                break;
            }
            if (this.transformLyric != null) {
                transformText = this.transformLyric.getOrDefault(Float.valueOf(lyricTime), null);
            }
            return new Pair((Object)text, transformText);
        }
    }
}

