/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.client;

import com.gly091020.NetMusicListKeyMapping;
import com.gly091020.NetMusicListUtil;
import com.gly091020.hud.MusicInfoHud;
import com.gly091020.hud.MusicListLayer;
import com.gly091020.sounds.PlayerNetMusicSound;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="net_music_list")
public class ClientEventHandler {
    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Pre event) {
        GuiGraphics graphics = event.getGuiGraphics();
        MusicInfoHud.render(graphics);
        MusicListLayer.render(graphics);
    }

    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        if (!MusicListLayer.isRender) {
            return;
        }
        double d = event.getScrollDelta();
        if (Math.abs(d) >= 1.0) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
        if ((MusicListLayer.index -= (int)(d * (double)(NetMusicListKeyMapping.TOGGLE_MUSIC_SPEED_UP.m_90857_() ? 5 : 1))) < 0) {
            MusicListLayer.index = 0;
        }
        if (MusicListLayer.index >= MusicListLayer.count) {
            MusicListLayer.index = MusicListLayer.count - 1;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        IntegratedServer server = Minecraft.m_91087_().m_91092_();
        if (!Minecraft.m_91087_().m_91090_() || server != null && server.m_6992_()) {
            return;
        }
        List<TickableSoundInstance> sounds = NetMusicListUtil.getTickableSounds();
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen != null && !NetMusicListUtil.isPaused() && screen.m_7043_()) {
            for (TickableSoundInstance instance : sounds) {
                if (!(instance instanceof PlayerNetMusicSound)) continue;
                PlayerNetMusicSound playerNetMusicSound = (PlayerNetMusicSound)instance;
                playerNetMusicSound.onlyTickUpdate();
            }
        }
    }
}

