/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.hud;

import com.github.tartaricacid.netmusic.NetMusic;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.gly091020.NetMusicList;
import com.gly091020.NetMusicListUtil;
import com.gly091020.item.NetMusicPlayerItem;
import java.net.URL;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

@OnlyIn(value=Dist.CLIENT)
public class MusicInfoHud {
    private static final ResourceLocation DEFAULT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"net_music_list", (String)"textures/gui/default.png");
    private static ItemMusicCD.SongInfo info;
    private static ResourceLocation icon;
    private static long id;
    private static NetMusicListUtil.Lyric lyric;
    private static ItemStack stack;
    private static int slot;
    private static int left;
    private static int top;
    private static Thread thread;

    public static void render(@NotNull GuiGraphics guiGraphics) {
        if (!NetMusicList.CONFIG.musicHUD) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.f_92062_) {
            return;
        }
        if (info == null) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        guiGraphics.m_280163_(Objects.requireNonNullElse(icon, DEFAULT_TEXTURE), left, top, 0.0f, 0.0f, 40, 40, 40, 40);
        String text = "";
        text = MusicInfoHud.info.transName.isEmpty() ? MusicInfoHud.info.songName : String.format("%s(%s)", MusicInfoHud.info.songName, MusicInfoHud.info.transName);
        guiGraphics.m_280488_(font, text, left + 50, top, -1);
        int count = MusicInfoHud.info.songTime;
        if (stack != null) {
            ItemStack stack1;
            if (Minecraft.m_91087_().f_91074_ != null) {
                stack1 = Minecraft.m_91087_().f_91074_.m_150109_().m_8020_(slot);
                if (!stack1.m_150930_((Item)NetMusicList.MUSIC_PLAYER_ITEM.get()) || NetMusicPlayerItem.getContainer(stack1).m_7983_()) {
                    MusicInfoHud.clearInfo();
                    return;
                }
            } else {
                MusicInfoHud.clearInfo();
                return;
            }
            int tick = stack1.m_41784_().m_128451_("tick");
            int tickWidth = 100;
            Objects.requireNonNull(font);
            Objects.requireNonNull(font);
            guiGraphics.m_280509_(left + 50, top + 9 + 4, left + 50 + tickWidth, top + 9 + 6, -5592406);
            Objects.requireNonNull(font);
            int n = (int)((float)(left + 50) + (float)tickWidth * MusicInfoHud.clamp(((float)count - (float)tick / 20.0f) / (float)count, 0.0f, 1.0f));
            Objects.requireNonNull(font);
            guiGraphics.m_280509_(left + 50, top + 9 + 4, n, top + 9 + 6, -1);
            String string = String.format("%s/%s", NetMusicListUtil.secondsToMinutesSeconds((int)((float)count - (float)tick / 20.0f)), NetMusicListUtil.secondsToMinutesSeconds(count));
            Objects.requireNonNull(font);
            guiGraphics.m_280488_(font, string, left + 50 + tickWidth + 5, top + 9 + 1, -1);
            if (lyric != null) {
                Pair<String, String> lyricPart = lyric.getLyric(MusicInfoHud.clamp((float)count - (float)tick / 20.0f, 0.0f, Float.MAX_VALUE));
                String string2 = (String)lyricPart.getA();
                Objects.requireNonNull(font);
                guiGraphics.m_280488_(font, string2, left + 50, top + (9 * 2 + 1), -1);
                if (lyricPart.getB() != null && !((String)lyricPart.getB()).isEmpty()) {
                    String string3 = (String)lyricPart.getB();
                    Objects.requireNonNull(font);
                    guiGraphics.m_280488_(font, string3, left + 50, top + (9 + 1) * 3, -1);
                }
            }
        }
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    public static ItemMusicCD.SongInfo getInfo() {
        return info;
    }

    public static void setPos(int x, int y) {
        left = x;
        top = y;
    }

    public static void setInfo(ItemMusicCD.SongInfo info, @NotNull ItemStack playerStack, int slot) {
        MusicInfoHud.info = info;
        MusicInfoHud.slot = slot;
        if (thread != null) {
            thread.interrupt();
            thread = null;
        }
        if (icon != null) {
            Minecraft.m_91087_().m_91097_().m_118513_(icon);
            icon = null;
        }
        lyric = null;
        stack = playerStack;
        MusicInfoHud.getData();
    }

    public static void clearInfo() {
        info = null;
    }

    public static void getData() {
        if (info != null) {
            try {
                id = NetMusicListUtil.getIdFromInfo(info);
                thread = new Thread(() -> MusicInfoHud.getDataByThread(id));
                thread.start();
            }
            catch (Exception e) {
                NetMusicList.LOGGER.error("\u89e3\u6790\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            }
        }
    }

    private static void getDataByThread(long id) {
        try {
            URL icon_url = NetMusicListUtil.getIconUrl(NetMusic.NET_EASE_WEB_API.song(id));
            ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"net_music_list", (String)String.format("icon_%s", id));
            Minecraft.m_91087_().m_91097_().m_118495_(resourceLocation, NetMusicListUtil.getTextureFromURL(icon_url));
            NetMusicListUtil.Lyric l = NetMusicListUtil.getLyric(NetMusic.NET_EASE_WEB_API.lyric(id));
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            icon = resourceLocation;
            lyric = l;
        }
        catch (Exception e) {
            NetMusicList.LOGGER.error("\u89e3\u6790\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
    }

    static {
        left = 10;
        top = 10;
    }
}

