/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.sounds;

import com.github.tartaricacid.netmusic.client.audio.NetMusicAudioStream;
import com.github.tartaricacid.netmusic.init.InitItems;
import com.github.tartaricacid.netmusic.init.InitSounds;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.gly091020.NetMusicList;
import com.gly091020.item.NetMusicListItem;
import com.gly091020.item.NetMusicPlayerItem;
import com.gly091020.packet.UpdateMusicTickCTSPacket;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PlayerNetMusicSound
extends AbstractTickableSoundInstance {
    final Player player;
    final URL url;
    final int countTick;
    int tick = 0;
    final int slot;
    String clientUrl;

    public PlayerNetMusicSound(Player player, URL songUrl, int second, int slot) {
        super((SoundEvent)InitSounds.NET_MUSIC.get(), SoundSource.RECORDS, SoundInstance.m_235150_());
        this.player = player;
        this.url = songUrl;
        this.countTick = second * 20;
        this.f_119573_ = 4.0f;
        this.f_119575_ = player.m_20185_();
        this.f_119576_ = player.m_20186_();
        this.f_119577_ = player.m_20189_();
        this.slot = slot;
    }

    public void m_7788_() {
        ClientLevel level;
        ItemStack itemStack;
        if (this.player.m_213877_()) {
            this.m_119609_();
        }
        if (!(itemStack = this.player.m_150109_().m_8020_(this.slot)).m_150930_((Item)NetMusicList.MUSIC_PLAYER_ITEM.get())) {
            this.m_119609_();
        }
        if ((itemStack = NetMusicPlayerItem.getContainer(itemStack).m_8020_(0)).m_150930_((Item)InitItems.MUSIC_CD.get())) {
            if (ItemMusicCD.getSongInfo((ItemStack)itemStack) == null) {
                this.m_119609_();
            }
        } else if (itemStack.m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get())) {
            ItemMusicCD.SongInfo info = NetMusicListItem.getSongInfo(itemStack);
            if (info == null) {
                this.m_119609_();
            } else {
                if (this.clientUrl == null) {
                    this.clientUrl = info.songUrl;
                }
                if (!Objects.equals(this.clientUrl, info.songUrl)) {
                    this.m_119609_();
                }
            }
        } else {
            this.m_119609_();
        }
        if ((level = Minecraft.m_91087_().f_91073_) == null) {
            this.m_119609_();
        } else {
            ++this.tick;
            if (this.tick > this.countTick + 50) {
                this.m_119609_();
            } else {
                this.f_119575_ = this.player.m_20185_();
                this.f_119576_ = this.player.m_20186_();
                this.f_119577_ = this.player.m_20189_();
                if (level.m_46467_() % 8L == 0L) {
                    for (int i = 0; i < 2; ++i) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.f_119575_ - 0.5 + level.f_46441_.m_188500_(), this.f_119576_ + 1.5 + level.f_46441_.m_188500_(), this.f_119577_ - 0.5 + level.f_46441_.m_188500_(), level.f_46441_.m_188583_(), level.f_46441_.m_188583_(), (double)level.f_46441_.m_188503_(3));
                    }
                }
            }
        }
        if (this.tick % 20 == 0 && this.isClientPlayer()) {
            NetMusicList.CHANNEL.sendToServer((Object)new UpdateMusicTickCTSPacket(this.slot, this.countTick - this.tick));
        }
        if (this.m_7801_() && this.isClientPlayer()) {
            NetMusicList.CHANNEL.sendToServer((Object)new UpdateMusicTickCTSPacket(this.slot, -1));
        }
    }

    public void onlyTickUpdate() {
        ++this.tick;
        if (this.tick % 20 == 0 && this.isClientPlayer()) {
            NetMusicList.CHANNEL.sendToServer((Object)new UpdateMusicTickCTSPacket(this.slot, this.countTick - this.tick));
        }
        if (this.m_7801_() && this.isClientPlayer()) {
            NetMusicList.CHANNEL.sendToServer((Object)new UpdateMusicTickCTSPacket(this.slot, -1));
        }
    }

    @NotNull
    public CompletableFuture<AudioStream> getStream(@NotNull SoundBufferLibrary soundBuffers, @NotNull Sound sound, boolean looping) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return new NetMusicAudioStream(this.url);
            }
            catch (IOException | UnsupportedAudioFileException e) {
                NetMusicList.LOGGER.error("\u51fa\u73b0\u9519\u8bef\uff1a", (Throwable)e);
                return null;
            }
        }, Util.m_183991_());
    }

    public boolean isClientPlayer() {
        if (Minecraft.m_91087_().f_91074_ != null) {
            return this.player.m_20148_() == Minecraft.m_91087_().f_91074_.m_20148_();
        }
        return false;
    }
}

