/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.client;

import com.gly091020.util.CacheManager;
import com.gly091020.util.FileDownloadThread;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class CacheManagerScreen
extends Screen {
    private static final DecimalFormat PROGRESS_FORMAT = new DecimalFormat("0.0%");
    private static final DecimalFormat SIZE_FORMAT = new DecimalFormat("0.00");
    private int refreshTicks = 0;
    private static final int REFRESH_INTERVAL = 5;

    public CacheManagerScreen() {
        super((Component)Component.m_237113_((String)"\u4e0b\u8f7d\u76d1\u63a7"));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        guiGraphics.m_280137_(this.f_96547_, "\u4e0b\u8f7d\u4efb\u52a1\u76d1\u63a7", this.f_96543_ / 2, 20, 0xFFFFFF);
        List<FileDownloadThread> downloads = CacheManager.getThreads();
        String countText = "\u6d3b\u8dc3\u4e0b\u8f7d\u4efb\u52a1: " + downloads.size();
        guiGraphics.m_280488_(this.f_96547_, countText, 10, 50, 0xFFFFFF);
        int startY = 80;
        int lineHeight = 30;
        if (downloads.isEmpty()) {
            guiGraphics.m_280137_(this.f_96547_, "\u6ca1\u6709\u6d3b\u8dc3\u7684\u4e0b\u8f7d\u4efb\u52a1", this.f_96543_ / 2, startY, 0x888888);
        } else {
            for (int i = 0; i < downloads.size(); ++i) {
                FileDownloadThread thread = downloads.get(i);
                this.renderDownloadEntry(guiGraphics, thread, 10, startY + i * lineHeight, this.f_96543_ - 20);
            }
        }
        poseStack.m_85849_();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void renderDownloadEntry(GuiGraphics guiGraphics, FileDownloadThread thread, int x, int y, int width) {
        String progressText;
        String threadInfo = String.format("ID: %s | \u8d44\u6e90: %d | \u7c7b\u578b: %s", thread.getThreadId(), thread.getResourceId(), thread.getFileType());
        guiGraphics.m_280488_(this.f_96547_, threadInfo, x, y, 0xFFFFFF);
        float progress = thread.getProgress();
        long downloaded = thread.getDownloadedBytes();
        long total = thread.getTotalBytes();
        if (total > 0L) {
            String downloadedStr = this.formatFileSize(downloaded);
            String totalStr = this.formatFileSize(total);
            progressText = String.format("%s / %s (%s)", downloadedStr, totalStr, PROGRESS_FORMAT.format(progress));
        } else {
            progressText = String.format("%s / \u672a\u77e5\u5927\u5c0f (%s)", this.formatFileSize(downloaded), PROGRESS_FORMAT.format(progress));
        }
        guiGraphics.m_280488_(this.f_96547_, progressText, x, y + 10, 0xCCCCCC);
        int progressBarWidth = width - 20;
        int progressBarHeight = 6;
        int progressBarX = x;
        int progressBarY = y + 20;
        guiGraphics.m_280509_(progressBarX, progressBarY, progressBarX + progressBarWidth, progressBarY + progressBarHeight, -11184811);
        int progressWidth = (int)((float)progressBarWidth * progress);
        int color = this.getProgressBarColor(thread);
        guiGraphics.m_280509_(progressBarX, progressBarY, progressBarX + progressWidth, progressBarY + progressBarHeight, color);
        String statusText = this.getStatusText(thread);
        int statusColor = this.getStatusColor(thread);
        guiGraphics.m_280488_(this.f_96547_, statusText, x + progressBarWidth + 5, progressBarY, statusColor);
    }

    private String getStatusText(FileDownloadThread thread) {
        if (thread.isCompleted()) {
            return "\u5b8c\u6210";
        }
        if (thread.isFailed()) {
            return "\u5931\u8d25: " + thread.getErrorMessage();
        }
        if (thread.isInterrupted()) {
            return "\u5df2\u4e2d\u65ad";
        }
        return "\u4e0b\u8f7d\u4e2d...";
    }

    private int getStatusColor(FileDownloadThread thread) {
        if (thread.isCompleted()) {
            return -16711936;
        }
        if (thread.isFailed()) {
            return -65536;
        }
        if (thread.isInterrupted()) {
            return -23296;
        }
        return -256;
    }

    private int getProgressBarColor(FileDownloadThread thread) {
        if (thread.isCompleted()) {
            return -16711936;
        }
        if (thread.isFailed()) {
            return -65536;
        }
        if (thread.isInterrupted()) {
            return -23296;
        }
        return -16776961;
    }

    private String formatFileSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return SIZE_FORMAT.format((double)bytes / 1024.0) + " KB";
        }
        return SIZE_FORMAT.format((double)bytes / 1048576.0) + " MB";
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.refreshTicks;
        if (this.refreshTicks >= 5) {
            this.refreshTicks = 0;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.m_91152_(null);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }
}

