/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.client;

import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.gly091020.NetMusicList;
import com.gly091020.packet.DeleteMusicDataPacket;
import com.gly091020.packet.MoveMusicDataPacket;
import com.gly091020.packet.MusicListDataPacket;
import com.gly091020.util.NetMusicListUtil;
import com.gly091020.util.PlayMode;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class MusicSelectionScreen
extends Screen {
    private final List<String> musicList;
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"net_music_list", (String)"textures/gui/bg.png");
    private static final ResourceLocation GLY091020 = ResourceLocation.fromNamespaceAndPath((String)"net_music_list", (String)"textures/gui/gly091020.png");
    private static ResourceLocation PLAYER_HAND = null;
    private static final ResourceLocation BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"net_music_list", (String)"textures/gui/button.png");
    private final int backgroundWidth = 321;
    private final int backgroundHeight = 161;
    private int left;
    private int top;
    private PlayModeButton playModeButton;
    private MusicListWidget listWidget;
    private Integer index;
    private final PlayMode mode;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private float lastScroll = 0.0f;
    private float CDRotation = 0.0f;
    private float nowSpeed = 0.0f;
    private float pointerRotation = 0.0f;

    public MusicSelectionScreen(List<String> musicList, PlayMode mode, Integer index) {
        super((Component)Component.m_237115_((String)"gui.net_music_list.title"));
        this.musicList = musicList;
        this.mode = mode;
        this.index = index;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.left = (this.f_96543_ - this.backgroundWidth) / 2;
        this.top = (this.f_96544_ - this.backgroundHeight) / 2;
        this.listWidget = new MusicListWidget();
        for (String music : this.musicList) {
            this.listWidget.addMusicEntry(music);
        }
        this.listWidget.addMusicEntry(Component.m_237115_((String)"gui.net_music_list.add").getString());
        this.listWidget.m_6987_((AbstractSelectionList.Entry)((MusicListEntry)((Object)this.listWidget.m_6702_().get(this.index))));
        this.m_142416_((GuiEventListener)this.listWidget);
        this.playModeButton = new PlayModeButton(this.left + 4 + 3, this.top + 133, button -> {
            this.playModeButton.playMode = this.playModeButton.playMode.getNext();
            this.playModeButton.m_257544_(Tooltip.m_257550_((Component)this.playModeButton.playMode.getName()));
            this.sendPackage();
        }, this.mode);
        this.m_142416_((GuiEventListener)this.playModeButton);
        this.deleteButton = new Button(Button.m_253074_((Component)Component.m_237115_((String)"gui.net_music_list.delete"), button -> this.deleteMusic()).m_252794_(this.left + 4 + 66 + 3, this.top + 133).m_253046_(50, 22)){

            protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                guiGraphics.m_280027_(BUTTON_TEXTURE, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 25, 25, 3, 3, 3, 3);
                this.m_280139_(guiGraphics, MusicSelectionScreen.this.f_96547_, -1);
            }
        };
        this.upButton = new MoveButton(this.left + 4 + 22 + 3, this.top + 133, button -> this.moveMusic(true), true);
        this.downButton = new MoveButton(this.left + 4 + 44 + 3, this.top + 133, button -> this.moveMusic(false), false);
        this.deleteButton.f_93623_ = this.canDelete();
        this.upButton.f_93623_ = this.canMove(true);
        this.downButton.f_93623_ = this.canMove(false);
        this.m_142416_((GuiEventListener)this.deleteButton);
        this.m_142416_((GuiEventListener)this.upButton);
        this.m_142416_((GuiEventListener)this.downButton);
        this.lastScroll = (float)this.listWidget.m_93517_();
        this.nowSpeed = 0.0f;
        if (this.musicList.size() == this.listWidget.getSelectedIndex()) {
            this.pointerRotation = 45.0f;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_280273_(@NotNull GuiGraphics guiGraphics) {
        super.m_280273_(guiGraphics);
        guiGraphics.m_280163_(BACKGROUND_TEXTURE, this.left, this.top, 0.0f, 0.0f, 321, 161, 512, 256);
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    public void renderCD(@NotNull GuiGraphics guiGraphics, float delta) {
        guiGraphics.m_280168_().m_85836_();
        float scrollSpeed = (float)Math.abs(this.listWidget.m_93517_() - (double)this.lastScroll);
        if ((double)scrollSpeed <= 0.3) {
            scrollSpeed = 0.0f;
        }
        this.nowSpeed = (double)Math.abs(scrollSpeed - this.nowSpeed) > 0.01 ? (scrollSpeed > this.nowSpeed ? (this.nowSpeed += 0.1f) : (this.nowSpeed -= 0.1f)) : scrollSpeed;
        this.nowSpeed = MusicSelectionScreen.clamp(this.nowSpeed, 0.0f, 0.5f);
        this.CDRotation += this.nowSpeed * delta * 10.0f;
        this.lastScroll = Math.abs((double)this.lastScroll - this.listWidget.m_93517_()) <= 3.0 ? (float)this.listWidget.m_93517_() : ((double)this.lastScroll < this.listWidget.m_93517_() ? (this.lastScroll += (float)(Math.abs((double)this.lastScroll - this.listWidget.m_93517_()) / 10.0)) : (this.lastScroll -= (float)(Math.abs((double)this.lastScroll - this.listWidget.m_93517_()) / 10.0)));
        int x = this.left + 15;
        int y = this.top + 15;
        int size = 100;
        guiGraphics.m_280168_().m_252880_((float)x + (float)size / 2.0f, (float)y + (float)size / 2.0f, 0.0f);
        guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(this.CDRotation));
        guiGraphics.m_280168_().m_252880_((float)(-x) - (float)size / 2.0f, (float)(-y) - (float)size / 2.0f, 0.0f);
        if (NetMusicListUtil.isGLY()) {
            guiGraphics.m_280411_(GLY091020, x, y, size, size, 0.0f, 0.0f, 256, 256, 256, 256);
        } else if (NetMusicListUtil.isN44()) {
            if (PLAYER_HAND == null) {
                PLAYER_HAND = Minecraft.m_91087_().m_91109_().m_240306_(Minecraft.m_91087_().m_91094_().m_92548_());
            }
            guiGraphics.m_280411_(PLAYER_HAND, x, y, size, size, 8.0f, 8.0f, 8, 8, 64, 64);
        } else {
            guiGraphics.m_280411_(BACKGROUND_TEXTURE, x, y, size, size, 322.0f, 0.0f, 128, 128, 512, 256);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public void renderPointer(@NotNull GuiGraphics guiGraphics, float delta) {
        if (this.musicList.size() == this.listWidget.getSelectedIndex()) {
            if (this.pointerRotation < 45.0f) {
                this.pointerRotation += 10.0f * delta;
                if (this.pointerRotation > 44.0f) {
                    this.pointerRotation = 45.0f;
                }
            }
        } else if (this.pointerRotation > 0.0f) {
            this.pointerRotation -= 10.0f * delta;
            if (this.pointerRotation < 1.0f) {
                this.pointerRotation = 0.0f;
            }
        }
        int x = this.left + 50;
        int y = this.top + 3;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)(x + 55), (float)(y + 3), 0.0f);
        guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(this.pointerRotation));
        guiGraphics.m_280168_().m_252880_((float)(-x - 55), (float)(-y - 3), 0.0f);
        guiGraphics.m_280411_(BACKGROUND_TEXTURE, x, y, 64, 58, 0.0f, 187.0f, 69, 66, 512, 256);
        guiGraphics.m_280168_().m_85849_();
    }

    public void m_88315_(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280273_(context);
        super.m_88315_(context, mouseX, mouseY, delta);
        this.renderCD(context, delta);
        this.renderPointer(context, delta);
    }

    public boolean m_7933_(int p_96552_, int p_96553_, int p_96554_) {
        if (p_96552_ == 261 && this.canDelete()) {
            this.deleteMusic();
            return true;
        }
        if (p_96552_ == 265 && this.canMove(true)) {
            this.moveMusic(true);
            return true;
        }
        if (p_96552_ == 264 && this.canMove(false)) {
            this.moveMusic(false);
            return true;
        }
        if (p_96552_ == 256 && super.m_7933_(p_96552_, p_96553_, p_96554_)) {
            this.sendPackage();
            return true;
        }
        return super.m_7933_(p_96552_, p_96553_, p_96554_);
    }

    public void deleteMusic() {
        if (this.listWidget.getSelectedIndex() != this.musicList.size()) {
            int o;
            int o1 = o = this.listWidget.getSelectedIndex();
            this.musicList.remove(o);
            if (o == this.musicList.size()) {
                --o;
            }
            if (o < 0) {
                o = 0;
            }
            this.index = o;
            this.m_169413_();
            this.m_7856_();
            this.listWidget.setSelectedIndex(o);
            this.index = this.listWidget.getSelectedIndex();
            MusicSelectionScreen.sendToServer(new DeleteMusicDataPacket(o1));
            this.updateButton();
            this.sendPackage();
        }
    }

    public void moveMusic(boolean isUp) {
        if (this.listWidget.getSelectedIndex() != this.musicList.size()) {
            int i1 = this.listWidget.getSelectedIndex() - (isUp ? 1 : -1);
            MusicSelectionScreen.sendToServer(new MoveMusicDataPacket(this.listWidget.getSelectedIndex(), i1));
            MusicListEntry l = (MusicListEntry)this.listWidget.m_93511_();
            String l1 = this.musicList.get(this.listWidget.getSelectedIndex());
            this.musicList.set(this.listWidget.getSelectedIndex(), this.musicList.get(i1));
            this.musicList.set(i1, l1);
            this.listWidget.setEntry(this.listWidget.getSelectedIndex(), (MusicListEntry)((Object)this.listWidget.m_6702_().get(i1)));
            this.listWidget.setEntry(i1, l);
            this.index = i1;
            this.listWidget.setSelectedIndex(i1);
            this.updateButton();
            this.sendPackage();
        }
    }

    public static void sendToServer(Object payload) {
        NetMusicList.CHANNEL.sendToServer(payload);
    }

    public void updateButton() {
        this.deleteButton.f_93623_ = this.canDelete();
        this.upButton.f_93623_ = this.canMove(true);
        this.downButton.f_93623_ = this.canMove(false);
    }

    public boolean canDelete() {
        return this.index.intValue() != this.musicList.size();
    }

    public boolean canMove(boolean isUp) {
        if (isUp) {
            if (!this.canDelete()) {
                return false;
            }
            return this.index > 0;
        }
        if (!this.canDelete()) {
            return false;
        }
        return this.index < this.musicList.size() - 1;
    }

    public void sendPackage() {
        this.index = this.listWidget.getSelectedIndex();
        MusicSelectionScreen.sendToServer(new MusicListDataPacket(this.index, this.playModeButton.playMode));
    }

    public static void open(List<ItemMusicCD.SongInfo> musicList, PlayMode mode, Integer index) {
        ArrayList<String> l = new ArrayList<String>();
        for (ItemMusicCD.SongInfo info : musicList) {
            if (info.artists.isEmpty()) {
                l.add(info.songName);
                continue;
            }
            StringBuilder a = new StringBuilder();
            for (String artist : info.artists) {
                a.append(artist);
                a.append("\u3001");
            }
            String t = "";
            if (info.readOnly) {
                t = Component.m_237115_((String)"gui.net_music_list.read_only").getString();
            } else if (info.vip) {
                t = Component.m_237115_((String)"gui.net_music_list.vip").getString();
            }
            String AT = a.toString();
            l.add(String.format("%s%s \u2014\u2014 %s", info.songName, t, AT.substring(0, AT.length() - 1)));
        }
        if (index < 0 || index > musicList.size()) {
            NetMusicList.LOGGER.error("\u9519\u8bef\u7684\u7d22\u5f15\uff1a{}", (Object)index);
            return;
        }
        Minecraft.m_91087_().m_91152_((Screen)new MusicSelectionScreen(l, mode, index));
    }

    private class MusicListWidget
    extends ObjectSelectionList<MusicListEntry> {
        public MusicListWidget() {
            Minecraft minecraft = Minecraft.m_91087_();
            Objects.requireNonNull(MusicSelectionScreen.this.f_96547_);
            super(minecraft, 197, 153, 12, 12, 9 + 1);
            this.f_93393_ = MusicSelectionScreen.this.left + 122;
            this.f_93392_ = 321 + MusicSelectionScreen.this.left - 5;
            this.m_93473_(false, 0);
            this.m_93496_(false);
        }

        protected int m_5756_() {
            return this.f_93390_ + this.f_93388_ - 5;
        }

        public int m_5759_() {
            return this.f_93388_ - 16;
        }

        public void addMusicEntry(String musicName) {
            this.m_7085_((AbstractSelectionList.Entry)new MusicListEntry(musicName));
        }

        public void m_88315_(@NotNull GuiGraphics guiGraphics, int x, int y, float d) {
            super.m_88315_(guiGraphics, x, y, d);
            if (this.m_93518_() > 0) {
                int l = this.m_5756_();
                int i1 = (int)((float)(this.f_93389_ * this.f_93389_) / (float)this.m_5775_());
                i1 = Mth.m_14045_((int)i1, (int)32, (int)(this.f_93389_ - 8));
                int k = (int)this.m_93517_() * (this.f_93389_ - i1) / this.m_93518_() + this.f_93390_;
                if (k < this.f_93390_) {
                    k = this.f_93390_;
                }
                guiGraphics.m_280027_(ResourceLocation.fromNamespaceAndPath((String)"net_music_list", (String)"textures/gui/bar.png"), l - 1, k, 5, i1, 5, 18, 1, 4, 1, 13);
            }
        }

        public int getSelectedIndex() {
            return this.m_6702_().indexOf(this.m_93511_());
        }

        public void setSelectedIndex(int index) {
            this.m_6987_((AbstractSelectionList.Entry)((MusicListEntry)((Object)this.m_6702_().get(index))));
        }

        public void setEntry(int index, MusicListEntry entry) {
            List l = this.m_6702_();
            l.set(index, entry);
        }
    }

    private class MusicListEntry
    extends ObjectSelectionList.Entry<MusicListEntry> {
        private final String musicName;

        public MusicListEntry(String musicName) {
            this.musicName = musicName;
        }

        @NotNull
        public Component m_142172_() {
            return Component.m_237113_((String)this.musicName);
        }

        public void m_6311_(@NotNull GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (hovered) {
                context.m_280509_(x, y, x + entryWidth - 4, y + entryHeight, -2130706433);
            }
            context.m_280488_(MusicSelectionScreen.this.f_96547_, MusicSelectionScreen.this.f_96547_.m_92834_(this.musicName, entryWidth - 10), x + 5, y + (entryHeight - 10) / 2 + 1, 0xFFFFFF);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            super.m_6375_(mouseX, mouseY, button);
            MusicSelectionScreen.this.index = MusicSelectionScreen.this.listWidget.m_6702_().indexOf((Object)this);
            MusicSelectionScreen.this.listWidget.setSelectedIndex(MusicSelectionScreen.this.index);
            MusicSelectionScreen.this.sendPackage();
            MusicSelectionScreen.this.updateButton();
            return true;
        }
    }

    public static class PlayModeButton
    extends Button {
        public PlayMode playMode;

        protected PlayModeButton(int x, int y, Button.OnPress onPress, PlayMode playMode) {
            super(x, y, 22, 22, (Component)Component.m_237119_(), onPress, Button.f_252438_);
            this.playMode = playMode;
            this.m_257544_(Tooltip.m_257550_((Component)this.playMode.getName()));
        }

        protected void m_87963_(@NotNull GuiGraphics context, int p_282682_, int p_281714_, float p_282542_) {
            super.m_87963_(context, p_282682_, p_281714_, p_282542_);
            int x = 0;
            switch (this.playMode) {
                case SEQUENTIAL: {
                    x = 1;
                    break;
                }
                case RANDOM: {
                    x = 26;
                    break;
                }
                case LOOP: {
                    x = 51;
                }
            }
            context.m_280027_(BUTTON_TEXTURE, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 25, 25, 3, 3, 3, 3);
            context.m_280163_(BACKGROUND_TEXTURE, this.m_252754_(), this.m_252907_(), (float)x, 162.0f, this.f_93618_, this.f_93619_, 512, 256);
        }
    }

    public static class MoveButton
    extends Button {
        boolean isUp;

        protected MoveButton(int x, int y, Button.OnPress onPress, boolean isUP) {
            super(x, y, 22, 22, (Component)Component.m_237119_(), onPress, Button.f_252438_);
            this.isUp = isUP;
        }

        protected void m_87963_(@NotNull GuiGraphics context, int p_282682_, int p_281714_, float p_282542_) {
            context.m_280260_(BUTTON_TEXTURE, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 4, 25, 25, 0, 0);
            context.m_280163_(BACKGROUND_TEXTURE, this.m_252754_(), this.m_252907_(), this.isUp ? 76.0f : 101.0f, 162.0f, this.f_93618_, this.f_93619_, 512, 256);
        }
    }
}

