/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.client;

import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.gly091020.NetMusicList;
import com.gly091020.PlayMode;
import com.gly091020.packet.DeleteMusicDataPacket;
import com.gly091020.packet.MoveMusicDataPacket;
import com.gly091020.packet.MusicListDataPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class OldMusicSelectionScreen
extends Screen {
    private final List<String> musicList;
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("net_music_list", "textures/gui/old_bg.png");
    private final int backgroundWidth = 256;
    private final int backgroundHeight = 230;
    private int left;
    private int top;
    private PlayModeButton playModeButton;
    private MusicListWidget listWidget;
    private Integer index;
    private final PlayMode mode;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;

    public OldMusicSelectionScreen(List<String> musicList, PlayMode mode, Integer index) {
        super((Component)Component.m_237115_((String)"gui.net_music_list.title"));
        this.musicList = musicList;
        this.mode = mode;
        this.index = index;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.left = (this.f_96543_ - this.backgroundWidth) / 2;
        this.top = (this.f_96544_ - this.backgroundHeight) / 2;
        this.listWidget = new MusicListWidget();
        for (String music : this.musicList) {
            this.listWidget.addMusicEntry(music);
        }
        this.listWidget.addMusicEntry(Component.m_237115_((String)"gui.net_music_list.add").getString());
        this.listWidget.m_6987_((AbstractSelectionList.Entry)((MusicListEntry)((Object)this.listWidget.m_6702_().get(this.index))));
        this.m_142416_((GuiEventListener)this.listWidget);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.net_music_list.close"), button -> {
            this.sendPackage();
            this.m_7379_();
        }).m_252794_(this.left + 128 - 50, this.top + 230 - 24).m_253046_(100, 20).m_253136_());
        this.playModeButton = new PlayModeButton(this.left + 10, this.top + 230 - 90, button -> {
            this.playModeButton.playMode = this.playModeButton.playMode.getNext();
            this.playModeButton.m_257544_(Tooltip.m_257550_((Component)this.playModeButton.playMode.getName()));
            this.sendPackage();
        }, this.mode);
        this.m_142416_((GuiEventListener)this.playModeButton);
        this.deleteButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.net_music_list.delete"), button -> this.deleteMusic()).m_252794_(this.left + 256 - 90 - 23, this.top + 230 - 90).m_253046_(80, 22).m_253136_();
        this.upButton = new MoveButton(this.left + 256 - 27, this.top + 230 - 90, button -> this.moveMusic(true), true);
        this.downButton = new MoveButton(this.left + 256 - 27, this.top + 230 - 90 + 22, button -> this.moveMusic(false), false);
        this.deleteButton.f_93623_ = this.canDelete();
        this.upButton.f_93623_ = this.canMove(true);
        this.downButton.f_93623_ = this.canMove(false);
        this.m_142416_((GuiEventListener)this.deleteButton);
        this.m_142416_((GuiEventListener)this.upButton);
        this.m_142416_((GuiEventListener)this.downButton);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280273_(context);
        Objects.requireNonNull(this.f_96547_);
        int fontHeight = 9;
        context.m_280218_(BACKGROUND_TEXTURE, this.left, this.top, 0, 0, 256, 230);
        context.m_280653_(this.f_96547_, this.f_96539_, this.left + 128, this.top + 6, 0x404040);
        context.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.net_music_list.play_list"), this.left + 10, this.top + 6 + fontHeight + 6, 0, false);
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    public boolean m_7933_(int p_96552_, int p_96553_, int p_96554_) {
        if (p_96552_ == 261 && this.canDelete()) {
            this.deleteMusic();
            return true;
        }
        if (p_96552_ == 265 && this.canMove(true)) {
            this.moveMusic(true);
            return true;
        }
        if (p_96552_ == 264 && this.canMove(false)) {
            this.moveMusic(false);
            return true;
        }
        if (p_96552_ == 256 && super.m_7933_(p_96552_, p_96553_, p_96554_)) {
            this.sendPackage();
            return true;
        }
        return super.m_7933_(p_96552_, p_96553_, p_96554_);
    }

    public void deleteMusic() {
        if (this.listWidget.getSelectedIndex() != this.musicList.size()) {
            int o;
            int o1 = o = this.listWidget.getSelectedIndex();
            this.musicList.remove(o);
            if (o == this.musicList.size()) {
                --o;
            }
            if (o < 0) {
                o = 0;
            }
            this.index = o;
            this.m_169413_();
            this.m_7856_();
            this.listWidget.setSelectedIndex(o);
            this.index = this.listWidget.getSelectedIndex();
            NetMusicList.CHANNEL.sendToServer((Object)new DeleteMusicDataPacket(o1));
            this.updateButton();
            this.sendPackage();
        }
    }

    public void moveMusic(boolean isUp) {
        if (this.listWidget.getSelectedIndex() != this.musicList.size()) {
            int i1 = this.listWidget.getSelectedIndex() - (isUp ? 1 : -1);
            NetMusicList.CHANNEL.sendToServer((Object)new MoveMusicDataPacket(this.listWidget.getSelectedIndex(), i1));
            MusicListEntry l = (MusicListEntry)this.listWidget.m_93511_();
            String l1 = this.musicList.get(this.listWidget.getSelectedIndex());
            this.musicList.set(this.listWidget.getSelectedIndex(), this.musicList.get(i1));
            this.musicList.set(i1, l1);
            this.listWidget.setEntry(this.listWidget.getSelectedIndex(), (MusicListEntry)((Object)this.listWidget.m_6702_().get(i1)));
            this.listWidget.setEntry(i1, l);
            this.index = i1;
            this.listWidget.setSelectedIndex(i1);
            this.updateButton();
            this.sendPackage();
        }
    }

    public void updateButton() {
        this.deleteButton.f_93623_ = this.canDelete();
        this.upButton.f_93623_ = this.canMove(true);
        this.downButton.f_93623_ = this.canMove(false);
    }

    public boolean canDelete() {
        return this.index.intValue() != this.musicList.size();
    }

    public boolean canMove(boolean isUp) {
        if (isUp) {
            if (!this.canDelete()) {
                return false;
            }
            return this.index > 0;
        }
        if (!this.canDelete()) {
            return false;
        }
        return this.index < this.musicList.size() - 1;
    }

    public void sendPackage() {
        this.index = this.listWidget.getSelectedIndex();
        NetMusicList.CHANNEL.sendToServer((Object)new MusicListDataPacket(this.index, this.playModeButton.playMode));
    }

    public static void open(List<ItemMusicCD.SongInfo> musicList, PlayMode mode, Integer index) {
        ArrayList<String> l = new ArrayList<String>();
        for (ItemMusicCD.SongInfo info : musicList) {
            if (info.artists.isEmpty()) {
                l.add(info.songName);
                continue;
            }
            StringBuilder a = new StringBuilder();
            for (String artist : info.artists) {
                a.append(artist);
                a.append("\u3001");
            }
            l.add(String.format("%s \u2014\u2014 %s", a, info.songName));
        }
        if (index < 0 || index > musicList.size()) {
            NetMusicList.LOGGER.error("\u9519\u8bef\u7684\u7d22\u5f15\uff1a{}", (Object)index);
            return;
        }
        Minecraft.m_91087_().m_91152_((Screen)new OldMusicSelectionScreen(l, mode, index));
    }

    private class MusicListWidget
    extends ObjectSelectionList<MusicListEntry> {
        public MusicListWidget() {
            Minecraft minecraft = Minecraft.m_91087_();
            int n = OldMusicSelectionScreen.this.top + 24;
            Objects.requireNonNull(OldMusicSelectionScreen.this.f_96547_);
            int n2 = n + 9;
            int n3 = 230 + OldMusicSelectionScreen.this.top - 100;
            Objects.requireNonNull(OldMusicSelectionScreen.this.f_96547_);
            super(minecraft, 246, 180, n2, n3, 9 + 1);
            this.f_93393_ = OldMusicSelectionScreen.this.left + 5;
            this.f_93392_ = 256 + OldMusicSelectionScreen.this.left - 5;
            this.m_93496_(false);
        }

        protected int m_5756_() {
            return this.f_93392_ + this.f_93388_ - 6;
        }

        public int m_5759_() {
            return this.f_93388_ - 16;
        }

        public void addMusicEntry(String musicName) {
            this.m_7085_((AbstractSelectionList.Entry)new MusicListEntry(musicName));
        }

        public void m_93471_(boolean renderSelection) {
            super.m_93471_(renderSelection);
        }

        protected void m_7733_(GuiGraphics context) {
            context.m_280509_(OldMusicSelectionScreen.this.left, OldMusicSelectionScreen.this.top, OldMusicSelectionScreen.this.left + this.f_93388_, OldMusicSelectionScreen.this.top + this.f_93389_, 0);
        }

        public int getSelectedIndex() {
            return this.m_6702_().indexOf(this.m_93511_());
        }

        public void setSelectedIndex(int index) {
            this.m_6987_((AbstractSelectionList.Entry)((MusicListEntry)((Object)this.m_6702_().get(index))));
        }

        public void setEntry(int index, MusicListEntry entry) {
            List l = this.m_6702_();
            l.set(index, entry);
        }
    }

    private class MusicListEntry
    extends ObjectSelectionList.Entry<MusicListEntry> {
        private final String musicName;

        public MusicListEntry(String musicName) {
            this.musicName = musicName;
        }

        @NotNull
        public Component m_142172_() {
            return Component.m_237113_((String)this.musicName);
        }

        public void m_6311_(@NotNull GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (hovered) {
                context.m_280509_(x, y, x + entryWidth - 3, y + entryHeight, -2130706433);
            }
            context.m_280430_(OldMusicSelectionScreen.this.f_96547_, (Component)Component.m_237113_((String)this.musicName), x + 5, y + (entryHeight - 10) / 2, 0xFFFFFF);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            super.m_6375_(mouseX, mouseY, button);
            OldMusicSelectionScreen.this.index = OldMusicSelectionScreen.this.listWidget.m_6702_().indexOf((Object)this);
            OldMusicSelectionScreen.this.listWidget.setSelectedIndex(OldMusicSelectionScreen.this.index);
            OldMusicSelectionScreen.this.sendPackage();
            OldMusicSelectionScreen.this.updateButton();
            return true;
        }
    }

    public static class PlayModeButton
    extends Button {
        public PlayMode playMode;

        protected PlayModeButton(int x, int y, Button.OnPress onPress, PlayMode playMode) {
            super(x, y, 22, 22, (Component)Component.m_237119_(), onPress, Button.f_252438_);
            this.playMode = playMode;
            this.m_257544_(Tooltip.m_257550_((Component)this.playMode.getName()));
        }

        protected void m_87963_(@NotNull GuiGraphics context, int p_282682_, int p_281714_, float p_282542_) {
            super.m_87963_(context, p_282682_, p_281714_, p_282542_);
            int x = 0;
            switch (this.playMode) {
                case SEQUENTIAL: {
                    x = 44;
                    break;
                }
                case RANDOM: {
                    x = 66;
                    break;
                }
                case LOOP: {
                    x = 88;
                }
            }
            context.m_280218_(BACKGROUND_TEXTURE, this.m_252754_(), this.m_252907_(), x, 230, this.f_93618_, this.f_93619_);
        }
    }

    public static class MoveButton
    extends Button {
        boolean isUp;

        protected MoveButton(int x, int y, Button.OnPress onPress, boolean isUP) {
            super(x, y, 22, 22, (Component)Component.m_237119_(), onPress, Button.f_252438_);
            this.isUp = isUP;
        }

        protected void m_87963_(@NotNull GuiGraphics context, int p_282682_, int p_281714_, float p_282542_) {
            super.m_87963_(context, p_282682_, p_281714_, p_282542_);
            context.m_280218_(BACKGROUND_TEXTURE, this.m_252754_(), this.m_252907_(), this.isUp ? 110 : 132, 230, this.f_93618_, this.f_93619_);
        }
    }
}

