/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.hud;

import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.gly091020.NetMusicList;
import com.gly091020.item.NetMusicListItem;
import com.gly091020.item.NetMusicPlayerItem;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MusicListLayer {
    public static boolean isRender = false;
    public static int index = -1;
    public static int count = 0;

    public static void render(@NotNull GuiGraphics guiGraphics) {
        if (!isRender) {
            index = -1;
            return;
        }
        if (Minecraft.m_91087_().f_91066_.f_92062_) {
            return;
        }
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p == null) {
            return;
        }
        ItemStack i = p.m_21205_();
        if (!i.m_150930_((Item)NetMusicList.MUSIC_PLAYER_ITEM.get())) {
            isRender = false;
            return;
        }
        ItemStack disc = NetMusicPlayerItem.getContainer(i).m_8020_(0);
        if (!disc.m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get())) {
            isRender = false;
            return;
        }
        Integer m = NetMusicListItem.getSongIndex(disc);
        if (index == -1) {
            index = m;
        }
        int j = 0;
        Font font = Minecraft.m_91087_().f_91062_;
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        int height = Minecraft.m_91087_().m_91268_().m_85446_();
        int max_width = 0;
        List<ItemMusicCD.SongInfo> songList = NetMusicListItem.getSongInfoList(disc);
        PoseStack pose = guiGraphics.m_280168_();
        int length = NetMusicList.CONFIG.selectHudCount;
        pose.m_85836_();
        float scale = NetMusicList.CONFIG.selectHudSize;
        pose.m_252880_((float)width * (1.0f - scale), (float)height / 2.0f * (1.0f - scale), 0.0f);
        pose.m_85841_(scale, scale, 1.0f);
        count = songList.size();
        if (m.intValue() == songList.size()) {
            isRender = false;
            return;
        }
        if (index - length / 2 < 0) {
            for (l = 0; l < length; ++l) {
                if (l >= songList.size() || font.m_92895_(name = MusicListLayer.getMusicText(songList.get(l))) <= max_width) continue;
                max_width = font.m_92895_(name);
            }
        } else if (index + length / 2 >= songList.size()) {
            for (l = songList.size() - length; l < songList.size(); ++l) {
                if (l < 0 || font.m_92895_(name = MusicListLayer.getMusicText(songList.get(l))) <= max_width) continue;
                max_width = font.m_92895_(name);
            }
        } else {
            for (l = index - length / 2; l < index + length / 2; ++l) {
                if (l >= songList.size() || l < 0 || font.m_92895_(name = MusicListLayer.getMusicText(songList.get(l))) <= max_width) continue;
                max_width = font.m_92895_(name);
            }
        }
        if (max_width <= 0) {
            isRender = false;
            return;
        }
        int n = height / 2;
        Objects.requireNonNull(font);
        int yPos = n - length * (9 + 2) / 2;
        RenderSystem.enableBlend();
        Objects.requireNonNull(font);
        guiGraphics.m_280509_(width - max_width - 9, yPos - 4, width - 5, yPos + length * (9 + 2), Integer.MIN_VALUE);
        if (index - length < 0) {
            for (int l = 0; l < length; ++l) {
                if (l >= songList.size()) continue;
                String string = MusicListLayer.getMusicText(songList.get(l));
                Objects.requireNonNull(font);
                guiGraphics.m_280488_(font, string, width - max_width - 7, yPos + j * (9 + 2), 0xFFFFFF);
                if (l == index) {
                    Objects.requireNonNull(font);
                    Objects.requireNonNull(font);
                    guiGraphics.m_280509_(width - max_width - 7, yPos + j * (9 + 2) - 2, width - 7, yPos + (j + 1) * (9 + 2) - 2, -2130706433);
                }
                ++j;
            }
        } else if (index + length >= songList.size()) {
            for (int l = songList.size() - length; l < songList.size(); ++l) {
                if (l < 0) continue;
                String string = MusicListLayer.getMusicText(songList.get(l));
                Objects.requireNonNull(font);
                guiGraphics.m_280488_(font, string, width - max_width - 7, yPos + j * (9 + 2), 0xFFFFFF);
                if (l == index) {
                    Objects.requireNonNull(font);
                    Objects.requireNonNull(font);
                    guiGraphics.m_280509_(width - max_width - 7, yPos + j * (9 + 2) - 2, width - 7, yPos + (j + 1) * (9 + 2) - 2, -2130706433);
                }
                ++j;
            }
        } else {
            for (int l = index - length / 2; l < index + length / 2; ++l) {
                if (l >= songList.size() || l < 0) continue;
                String string = MusicListLayer.getMusicText(songList.get(l));
                Objects.requireNonNull(font);
                guiGraphics.m_280488_(font, string, width - max_width - 7, yPos + j * (9 + 2), 0xFFFFFF);
                if (l == index) {
                    Objects.requireNonNull(font);
                    Objects.requireNonNull(font);
                    guiGraphics.m_280509_(width - max_width - 7, yPos + j * (9 + 2) - 2, width - 7, yPos + (j + 1) * (9 + 2) - 2, -2130706433);
                }
                ++j;
            }
        }
        RenderSystem.disableBlend();
        pose.m_85849_();
    }

    private static String getMusicText(ItemMusicCD.SongInfo info) {
        if (!NetMusicList.CONFIG.selectHudShowArtist) {
            return info.songName;
        }
        StringBuilder artists = new StringBuilder();
        if (info.artists != null && !info.artists.isEmpty()) {
            artists.append("\u2014\u2014");
            for (String a : info.artists) {
                artists.append(a);
                artists.append(", ");
            }
        }
        return info.songName + artists.substring(0, artists.length() - 2);
    }
}

