/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.item;

import com.github.tartaricacid.netmusic.init.InitBlocks;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.gly091020.NetMusicList;
import com.gly091020.PlayMode;
import com.gly091020.client.OldMusicSelectionScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetMusicListItem
extends ItemMusicCD {
    private static final String listKey = "NetMusicSongInfoList";

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public static List<ItemMusicCD.SongInfo> getSongInfoList(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get()) && (tag = stack.m_41784_()).m_128441_(listKey)) {
            ArrayList<ItemMusicCD.SongInfo> l = new ArrayList<ItemMusicCD.SongInfo>();
            for (Object compound : tag.m_128437_(listKey, 10).toArray()) {
                CompoundTag c1 = (CompoundTag)compound;
                l.add(ItemMusicCD.SongInfo.deserializeNBT((CompoundTag)c1));
            }
            return l;
        }
        return new ArrayList<ItemMusicCD.SongInfo>();
    }

    public static void nextMusic(ItemStack stack) {
        if (stack.m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get())) {
            switch (NetMusicListItem.getPlayMode(stack)) {
                case RANDOM: {
                    int i = RandomSource.m_216327_().m_216339_(0, NetMusicListItem.getSongInfoList(stack).size() - 1);
                    NetMusicListItem.setSongIndex(stack, i);
                    break;
                }
                case SEQUENTIAL: {
                    int i = NetMusicListItem.getSongIndex(stack) + 1;
                    if (i >= NetMusicListItem.getSongInfoList(stack).size()) {
                        i = 0;
                    }
                    NetMusicListItem.setSongIndex(stack, i);
                }
            }
        }
    }

    public static ItemMusicCD.SongInfo getSongInfo(ItemStack stack) {
        List<ItemMusicCD.SongInfo> l = NetMusicListItem.getSongInfoList(stack);
        if (l.isEmpty()) {
            return null;
        }
        Integer i = NetMusicListItem.getSongIndex(stack);
        if (i >= 0 && i >= l.size()) {
            return null;
        }
        return l.get(i);
    }

    public static Integer getSongIndex(ItemStack stack) {
        if (stack.m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get())) {
            CompoundTag l = stack.m_41784_();
            if (!l.m_128441_("index")) {
                CompoundTag l1 = new CompoundTag();
                l1.m_128405_("index", 0);
                List<ItemMusicCD.SongInfo> l2 = NetMusicListItem.getSongInfoList(stack);
                ListTag nl1 = new ListTag();
                for (ItemMusicCD.SongInfo songInfo : l2) {
                    CompoundTag n1 = new CompoundTag();
                    ItemMusicCD.SongInfo.serializeNBT((ItemMusicCD.SongInfo)songInfo, (CompoundTag)n1);
                    nl1.add((Object)n1);
                }
                l1.m_128365_(listKey, (Tag)nl1);
                stack.m_41751_(l1);
                return 0;
            }
            return l.m_128451_("index");
        }
        return -1;
    }

    public static void deleteSong(ItemStack stack, int index) {
        CompoundTag n;
        if (stack.m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get()) && (n = stack.m_41784_()).m_128441_(listKey)) {
            ListTag l = n.m_128437_(listKey, 10);
            l.remove(index);
            n.m_128365_(listKey, (Tag)l);
            n.m_128405_("index", 0);
            stack.m_41751_(n);
        }
    }

    public static void moveSong(ItemStack stack, int from, int to) {
        CompoundTag n;
        if (stack.m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get()) && (n = stack.m_41784_()).m_128441_(listKey)) {
            ListTag l = n.m_128437_(listKey, 10);
            Tag j = l.get(from);
            l.set(from, l.get(to));
            l.set(to, j);
        }
    }

    public static void setSongIndex(ItemStack stack, Integer index) {
        if (stack.m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get())) {
            CompoundTag n = stack.m_41784_();
            n.m_128405_("index", index.intValue());
            stack.m_41751_(n);
        }
    }

    public static ItemStack setSongInfo(ItemMusicCD.SongInfo info, ItemStack stack) {
        if (stack.m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get())) {
            List<ItemMusicCD.SongInfo> l = NetMusicListItem.getSongInfoList(stack);
            CompoundTag oldCompound = new CompoundTag();
            ListTag l1 = new ListTag();
            for (ItemMusicCD.SongInfo songInfo : l) {
                CompoundTag n1 = new CompoundTag();
                ItemMusicCD.SongInfo.serializeNBT((ItemMusicCD.SongInfo)songInfo, (CompoundTag)n1);
                l1.add((Object)n1);
            }
            oldCompound.m_128365_(listKey, (Tag)l1);
            CompoundTag tag = stack.m_41784_();
            List<ItemMusicCD.SongInfo> l12 = NetMusicListItem.getSongInfoList(stack);
            if (NetMusicListItem.getSongIndex(stack) >= l12.size()) {
                ListTag nl = tag.m_128437_(listKey, 10);
                CompoundTag sn = new CompoundTag();
                ItemMusicCD.SongInfo.serializeNBT((ItemMusicCD.SongInfo)info, (CompoundTag)sn);
                nl.add((Object)sn);
                tag.m_128365_(listKey, (Tag)nl);
                NetMusicListItem.setSongIndex(stack, l12.size() + 1);
                stack.m_41751_(tag);
                return stack;
            }
            ItemMusicCD.SongInfo d = l12.get(NetMusicListItem.getSongIndex(stack));
            if (d == null) {
                return stack;
            }
            ListTag nl = tag.m_128437_(listKey, 10);
            CompoundTag sn = new CompoundTag();
            ItemMusicCD.SongInfo.serializeNBT((ItemMusicCD.SongInfo)info, (CompoundTag)sn);
            nl.set(NetMusicListItem.getSongIndex(stack).intValue(), (Tag)sn);
            tag.m_128365_(listKey, (Tag)nl);
            stack.m_41751_(tag);
        }
        return stack;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> componentList, @NotNull TooltipFlag flag) {
        String name = Component.m_237115_((String)"tooltip.net_music_list.play_mode").getString();
        Object text = "\u00a7a\u258d \u00a77" + name + ": \u00a76" + NetMusicListItem.getPlayMode(stack).getName().getString();
        if (NetMusicListItem.getSongInfoList(stack).isEmpty()) {
            componentList.add((Component)Component.m_237115_((String)"tooltips.netmusic.cd.empty").m_130940_(ChatFormatting.RED));
        }
        componentList.add((Component)Component.m_237113_((String)text));
        ItemMusicCD.SongInfo info = NetMusicListItem.getSongInfo(stack);
        Language language = Language.m_128107_();
        if (info != null) {
            if (info.transName != null && !info.transName.isEmpty()) {
                name = language.m_6834_("tooltips.netmusic.cd.trans_name");
                text = "\u00a7a\u258d \u00a77" + name + ": \u00a76" + info.transName;
                componentList.add((Component)Component.m_237113_((String)text));
            }
            if (info.artists != null && !info.artists.isEmpty()) {
                text = StringUtils.join((Iterable)info.artists, (String)" | ");
                name = language.m_6834_("tooltips.netmusic.cd.artists");
                text = "\u00a7a\u258d \u00a77" + name + ": \u00a73" + (String)text;
                componentList.add((Component)Component.m_237113_((String)text));
            }
            name = language.m_6834_("tooltips.netmusic.cd.time");
            text = "\u00a7a\u258d \u00a77" + name + ": \u00a75" + this.getSongTime(info.songTime);
            componentList.add((Component)Component.m_237113_((String)text));
        }
    }

    private String getSongTime(int songTime) {
        int min = songTime / 60;
        int sec = songTime % 60;
        String minStr = min <= 9 ? "0" + min : "" + min;
        String secStr = sec <= 9 ? "0" + sec : "" + sec;
        String format = Language.m_128107_().m_6834_("tooltips.netmusic.cd.time.format");
        return String.format(format, minStr, secStr);
    }

    public static PlayMode getPlayMode(ItemStack stack) {
        CompoundTag n = stack.m_41784_();
        if (!n.m_128441_("play_mode")) {
            NetMusicListItem.setPlayMode(stack, PlayMode.LOOP);
            return PlayMode.LOOP;
        }
        return PlayMode.getMode(n.m_128451_("play_mode"));
    }

    public static void setPlayMode(ItemStack stack, PlayMode mode) {
        CompoundTag n = stack.m_41784_();
        n.m_128405_("play_mode", mode.ordinal());
        stack.m_41751_(n);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43723_().m_21205_();
        if (!stack.m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get())) {
            return InteractionResult.PASS;
        }
        if (context.m_43725_().m_8055_(context.m_8083_()).m_60713_((Block)InitBlocks.MUSIC_PLAYER.get())) {
            if (NetMusicListItem.getSongInfoList(stack).isEmpty()) {
                return InteractionResult.PASS;
            }
            if (NetMusicListItem.getSongIndex(stack) >= NetMusicListItem.getSongInfoList(stack).size()) {
                NetMusicListItem.setSongIndex(stack, NetMusicListItem.getSongInfoList(stack).size() - 1);
            }
            return InteractionResult.PASS;
        }
        if (context.m_43725_().f_46443_) {
            List<ItemMusicCD.SongInfo> l = NetMusicListItem.getSongInfoList(stack);
            OldMusicSelectionScreen.open(l, NetMusicListItem.getPlayMode(stack), NetMusicListItem.getSongIndex(stack));
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        if (Objects.equals(super.m_7626_(stack), Component.m_237115_((String)this.m_5671_(stack)))) {
            return Component.m_237110_((String)"item.net_music_list.name", (Object[])new Object[]{NetMusicListItem.getSongInfoList(stack).size()});
        }
        return Component.m_237110_((String)"item.net_music_list.info", (Object[])new Object[]{super.m_7626_(stack)});
    }
}

